/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.auth;

import io.confluent.rest.RestConfig;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.util.security.Constraint;

public final class AuthUtil {
    private AuthUtil() {
    }

    public static boolean isCorsEnabled(RestConfig restConfig) {
        String allowedOrigins = restConfig.getString("access.control.allow.origin");
        return !allowedOrigins.trim().isEmpty();
    }

    public static ConstraintMapping createGlobalAuthConstraint(RestConfig restConfig) {
        List roles = restConfig.getList("authentication.roles");
        boolean omitOptions = AuthUtil.isCorsEnabled(restConfig);
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(true);
        constraint.setRoles(roles.toArray(new String[0]));
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setMethod("*");
        if (omitOptions) {
            mapping.setMethodOmissions(new String[]{"OPTIONS"});
        }
        mapping.setPathSpec("/*");
        return mapping;
    }

    public static List<ConstraintMapping> createUnsecuredConstraints(RestConfig restConfig) {
        List unsecuredPaths = restConfig.getList("authentication.skip.paths");
        return unsecuredPaths.stream().map(AuthUtil::toUnsecuredConstraint).collect(Collectors.toList());
    }

    private static ConstraintMapping toUnsecuredConstraint(String unsecuredPath) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(false);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setMethod("*");
        mapping.setPathSpec(unsecuredPath);
        return mapping;
    }
}

