/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.ApplicationServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class ApplicationGroup {
    private final ApplicationServer<?> server;
    private final List<Application<?>> applications = new ArrayList();

    ApplicationGroup(ApplicationServer<?> server) {
        this.server = Objects.requireNonNull(server);
    }

    void addApplication(Application<?> application) {
        application.setServer(this.server);
        this.applications.add(application);
    }

    List<Application<?>> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    void doStop() {
        for (Application<?> application : this.applications) {
            application.metrics.close();
            application.doShutdown();
        }
    }
}

