/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.Application;
import io.confluent.rest.ApplicationGroup;
import io.confluent.rest.FileWatcher;
import io.confluent.rest.MetricsListener;
import io.confluent.rest.RestConfig;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationServer<T extends RestConfig>
extends Server {
    private final T config;
    private final ApplicationGroup applications;
    private final SslContextFactory sslContextFactory;
    private List<NetworkTrafficServerConnector> connectors = new ArrayList<NetworkTrafficServerConnector>();
    private static final Logger log = LoggerFactory.getLogger(ApplicationServer.class);

    static boolean isJava11Compatible() {
        String versionString = System.getProperty("java.specification.version");
        StringTokenizer st = new StringTokenizer(versionString, ".");
        int majorVersion = Integer.parseInt(st.nextToken());
        return majorVersion >= 11;
    }

    public ApplicationServer(T config) {
        this(config, ApplicationServer.createThreadPool(config));
    }

    public ApplicationServer(T config, ThreadPool threadPool) {
        super(threadPool);
        this.config = config;
        this.applications = new ApplicationGroup(this);
        int gracefulShutdownMs = config.getInt("shutdown.graceful.ms");
        if (gracefulShutdownMs > 0) {
            super.setStopTimeout((long)gracefulShutdownMs);
        }
        super.setStopAtShutdown(true);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        super.addEventListener((Container.Listener)mbContainer);
        super.addBean((Object)mbContainer);
        this.sslContextFactory = this.createSslContextFactory((RestConfig)((Object)config));
        this.configureConnectors(this.sslContextFactory);
    }

    static List<URI> parseListeners(List<String> listenersConfig, int deprecatedPort, List<String> supportedSchemes, String defaultScheme) {
        if (listenersConfig.isEmpty() || listenersConfig.get(0).isEmpty()) {
            log.warn("DEPRECATION warning: `listeners` configuration is not configured. Falling back to the deprecated `port` configuration.");
            listenersConfig = new ArrayList<String>(1);
            listenersConfig.add(defaultScheme + "://0.0.0.0:" + deprecatedPort);
        }
        ArrayList<URI> listeners = new ArrayList<URI>(listenersConfig.size());
        for (String listenerStr : listenersConfig) {
            URI uri;
            try {
                uri = new URI(listenerStr);
            }
            catch (URISyntaxException use) {
                throw new ConfigException("Could not parse a listener URI from the `listener` configuration option.");
            }
            String scheme = uri.getScheme();
            if (scheme == null) {
                throw new ConfigException("Found a listener without a scheme. All listeners must have a scheme. The listener without a scheme is: " + listenerStr);
            }
            if (uri.getPort() == -1) {
                throw new ConfigException("Found a listener without a port. All listeners must have a port. The listener without a port is: " + listenerStr);
            }
            if (!supportedSchemes.contains(scheme)) {
                log.warn("Found a listener with an unsupported scheme (supported: {}). Ignoring listener '{}'", supportedSchemes, (Object)listenerStr);
                continue;
            }
            listeners.add(uri);
        }
        if (listeners.isEmpty()) {
            throw new ConfigException("No listeners are configured. Must have at least one listener.");
        }
        return listeners;
    }

    public void registerApplication(Application application) {
        this.applications.addApplication(application);
    }

    public List<Application<?>> getApplications() {
        return this.applications.getApplications();
    }

    private void attachMetricsListener(Metrics metrics, Map<String, String> tags) {
        MetricsListener metricsListener = new MetricsListener(metrics, "jetty", tags);
        for (NetworkTrafficServerConnector connector : this.connectors) {
            connector.addNetworkTrafficListener((NetworkTrafficListener)metricsListener);
        }
    }

    private void addJettyThreadPoolMetrics(Metrics metrics, Map<String, String> tags) {
        String requestQueueSizeName = "request-queue-size";
        String metricGroupName = "jetty-metrics";
        MetricName requestQueueSizeMetricName = metrics.metricName(requestQueueSizeName, metricGroupName, "The number of requests in the jetty thread pool queue.", tags);
        Gauge queueSize = (config, now) -> this.getQueueSize();
        metrics.addMetric(requestQueueSizeMetricName, (MetricValueProvider)queueSize);
        String busyThreadCountName = "busy-thread-count";
        MetricName busyThreadCountMetricName = metrics.metricName(busyThreadCountName, metricGroupName, "jetty thread pool busy thread count.", tags);
        Gauge busyThreadCount = (config, now) -> this.getBusyThreads();
        metrics.addMetric(busyThreadCountMetricName, (MetricValueProvider)busyThreadCount);
        String threadPoolUsageName = "thread-pool-usage";
        MetricName threadPoolUsageMetricName = metrics.metricName(threadPoolUsageName, metricGroupName, " jetty thread pool usage.", Collections.emptyMap());
        Gauge threadPoolUsage = (config, now) -> (double)this.getBusyThreads() / (double)this.getMaxThreads();
        metrics.addMetric(threadPoolUsageMetricName, (MetricValueProvider)threadPoolUsage);
    }

    private void finalizeHandlerCollection(HandlerCollection handlers, HandlerCollection wsHandlers) {
        handlers.addHandler((Handler)new DefaultHandler());
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)handlers);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{statsHandler, wsHandlers});
        super.setHandler(this.wrapWithGzipHandler((Handler)contexts));
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.applications.doStop();
    }

    protected final void doStart() throws Exception {
        HandlerCollection handlers = new HandlerCollection();
        HandlerCollection wsHandlers = new HandlerCollection();
        for (Application<?> app : this.applications.getApplications()) {
            this.attachMetricsListener(app.getMetrics(), app.getMetricsTags());
            this.addJettyThreadPoolMetrics(app.getMetrics(), app.getMetricsTags());
            handlers.addHandler(app.configureHandler());
            wsHandlers.addHandler(app.configureWebSocketHandler());
        }
        this.finalizeHandlerCollection(handlers, wsHandlers);
        super.doStart();
    }

    private void configureClientAuth(SslContextFactory sslContextFactory, RestConfig config) {
        String clientAuthentication = config.getString("ssl.client.authentication");
        if (config.originals().containsKey("ssl.client.auth")) {
            if (config.originals().containsKey("ssl.client.authentication")) {
                log.warn("The {} configuration is deprecated. Since a value has been supplied for the {} configuration, that will be used instead", (Object)"ssl.client.auth", (Object)"ssl.client.authentication");
            } else {
                log.warn("The configuration {} is deprecated and should be replaced with {}", (Object)"ssl.client.auth", (Object)"ssl.client.authentication");
                clientAuthentication = config.getBoolean("ssl.client.auth") != false ? "REQUIRED" : "NONE";
            }
        }
        switch (clientAuthentication) {
            case "REQUIRED": {
                sslContextFactory.setNeedClientAuth(true);
                break;
            }
            case "REQUESTED": {
                sslContextFactory.setWantClientAuth(true);
                break;
            }
            case "NONE": {
                break;
            }
            default: {
                throw new ConfigException("Unexpected value for {} configuration: {}", (Object)"ssl.client.authentication", clientAuthentication);
            }
        }
    }

    private Path getWatchLocation(RestConfig config) {
        Path keystorePath = Paths.get(config.getString("ssl.keystore.location"), new String[0]);
        String watchLocation = config.getString("ssl.keystore.watch.location");
        if (!watchLocation.isEmpty()) {
            keystorePath = Paths.get(watchLocation, new String[0]);
        }
        return keystorePath;
    }

    private SslContextFactory createSslContextFactory(RestConfig config) {
        List cipherSuites;
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (!config.getString("ssl.keystore.location").isEmpty()) {
            sslContextFactory.setKeyStorePath(config.getString("ssl.keystore.location"));
            sslContextFactory.setKeyStorePassword(config.getPassword("ssl.keystore.password").value());
            sslContextFactory.setKeyManagerPassword(config.getPassword("ssl.key.password").value());
            sslContextFactory.setKeyStoreType(config.getString("ssl.keystore.type"));
            if (!config.getString("ssl.keymanager.algorithm").isEmpty()) {
                sslContextFactory.setKeyManagerFactoryAlgorithm(config.getString("ssl.keymanager.algorithm"));
            }
            if (config.getBoolean("ssl.keystore.reload").booleanValue()) {
                Path watchLocation = this.getWatchLocation(config);
                try {
                    FileWatcher.onFileChange(watchLocation, () -> ApplicationServer.lambda$createSslContextFactory$4((SslContextFactory)sslContextFactory, config));
                    log.info("Enabled SSL cert auto reload for: " + watchLocation);
                }
                catch (IOException e) {
                    log.error("Can not enabled SSL cert auto reload", (Throwable)e);
                }
            }
        }
        this.configureClientAuth((SslContextFactory)sslContextFactory, config);
        List enabledProtocols = config.getList("ssl.enabled.protocols");
        if (!enabledProtocols.isEmpty()) {
            sslContextFactory.setIncludeProtocols(enabledProtocols.toArray(new String[0]));
        }
        if (!(cipherSuites = config.getList("ssl.cipher.suites")).isEmpty()) {
            sslContextFactory.setIncludeCipherSuites(cipherSuites.toArray(new String[0]));
        }
        sslContextFactory.setEndpointIdentificationAlgorithm(config.getString("ssl.endpoint.identification.algorithm"));
        if (!config.getString("ssl.truststore.location").isEmpty()) {
            sslContextFactory.setTrustStorePath(config.getString("ssl.truststore.location"));
            sslContextFactory.setTrustStorePassword(config.getPassword("ssl.truststore.password").value());
            sslContextFactory.setTrustStoreType(config.getString("ssl.truststore.type"));
            if (!config.getString("ssl.trustmanager.algorithm").isEmpty()) {
                sslContextFactory.setTrustManagerFactoryAlgorithm(config.getString("ssl.trustmanager.algorithm"));
            }
        }
        sslContextFactory.setProtocol(config.getString("ssl.protocol"));
        if (!config.getString("ssl.provider").isEmpty()) {
            sslContextFactory.setProtocol(config.getString("ssl.provider"));
        }
        sslContextFactory.setRenegotiationAllowed(false);
        return sslContextFactory;
    }

    SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    private void configureConnectors(SslContextFactory sslContextFactory) {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(false);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        boolean http2Enabled = ApplicationServer.isJava11Compatible() && this.config.getBoolean("http2.enabled") != false;
        List<URI> listeners = ApplicationServer.parseListeners(this.config.getList("listeners"), this.config.getInt("port"), Arrays.asList("http", "https"), "http");
        for (URI listener : listeners) {
            if (listener.getScheme().equals("https") && httpConfiguration.getCustomizer(SecureRequestCustomizer.class) == null) {
                httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            }
            this.addConnectorForListener(httpConfiguration, httpConnectionFactory, listener, http2Enabled);
        }
    }

    private void addConnectorForListener(HttpConfiguration httpConfiguration, HttpConnectionFactory httpConnectionFactory, URI listener, boolean http2Enabled) {
        NetworkTrafficServerConnector connector;
        if (http2Enabled) {
            log.info("Adding listener with HTTP/2: " + listener.toString());
            if (listener.getScheme().equals("http")) {
                HTTP2CServerConnectionFactory h2cConnectionFactory = new HTTP2CServerConnectionFactory(httpConfiguration);
                connector = new NetworkTrafficServerConnector((Server)this, null, null, null, 0, 0, new ConnectionFactory[]{httpConnectionFactory, h2cConnectionFactory});
            } else {
                HTTP2ServerConnectionFactory h2ConnectionFactory = new HTTP2ServerConnectionFactory(httpConfiguration);
                ALPNServerConnectionFactory alpnConnectionFactory = new ALPNServerConnectionFactory(new String[0]);
                alpnConnectionFactory.setDefaultProtocol(HttpVersion.HTTP_1_1.asString());
                SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(this.sslContextFactory, alpnConnectionFactory.getProtocol());
                connector = new NetworkTrafficServerConnector((Server)this, null, null, null, 0, 0, new ConnectionFactory[]{sslConnectionFactory, alpnConnectionFactory, h2ConnectionFactory, httpConnectionFactory});
            }
            connector.addBean((Object)HttpCompliance.RFC7230);
        } else {
            log.info("Adding listener: " + listener.toString());
            connector = listener.getScheme().equals("http") ? new NetworkTrafficServerConnector((Server)this, (ConnectionFactory)httpConnectionFactory) : new NetworkTrafficServerConnector((Server)this, (ConnectionFactory)httpConnectionFactory, this.sslContextFactory);
        }
        connector.setPort(listener.getPort());
        connector.setHost(listener.getHost());
        connector.setIdleTimeout(this.config.getLong("idle.timeout.ms").longValue());
        this.connectors.add(connector);
        super.addConnector((Connector)connector);
    }

    List<URL> getListeners() {
        return Arrays.stream(this.getServer().getConnectors()).filter(connector -> connector instanceof ServerConnector).map(ServerConnector.class::cast).map(connector -> {
            try {
                String protocol = new HashSet(connector.getProtocols()).stream().map(String::toLowerCase).anyMatch(s -> s.equals("ssl")) ? "https" : "http";
                int localPort = connector.getLocalPort();
                return new URL(protocol, "localhost", localPort, "");
            }
            catch (Exception e) {
                throw new RuntimeException("Malformed listener", e);
            }
        }).collect(Collectors.toList());
    }

    public int getThreads() {
        return this.getThreadPool().getThreads();
    }

    public int getBusyThreads() {
        return ((QueuedThreadPool)this.getThreadPool()).getBusyThreads();
    }

    public int getMaxThreads() {
        return this.config.getInt("thread.pool.max");
    }

    public int getQueueSize() {
        return ((QueuedThreadPool)this.getThreadPool()).getQueueSize();
    }

    public int getQueueCapacity() {
        return this.config.getInt("request.queue.capacity");
    }

    static Handler wrapWithGzipHandler(RestConfig config, Handler handler) {
        if (config.getBoolean("compression.enable").booleanValue()) {
            GzipHandler gzip = new GzipHandler();
            gzip.setIncludedMethods(new String[]{"GET", "POST"});
            gzip.setHandler(handler);
            return gzip;
        }
        return handler;
    }

    private Handler wrapWithGzipHandler(Handler handler) {
        return ApplicationServer.wrapWithGzipHandler(this.config, handler);
    }

    private static ThreadPool createThreadPool(RestConfig config) {
        int initialCapacity = config.getInt("request.queue.capacity.init");
        int growBy = config.getInt("request.queue.capacity.growby");
        int maxCapacity = config.getInt("request.queue.capacity");
        log.info("Initial capacity {}, increased by {}, maximum capacity {}.", new Object[]{initialCapacity, growBy, maxCapacity});
        BlockingArrayQueue requestQueue = new BlockingArrayQueue(initialCapacity, growBy, maxCapacity);
        return new QueuedThreadPool(config.getInt("thread.pool.max").intValue(), config.getInt("thread.pool.min").intValue(), (BlockingQueue)requestQueue);
    }

    private static /* synthetic */ void lambda$createSslContextFactory$4(SslContextFactory sslContextFactory, RestConfig config) throws Exception {
        sslContextFactory.setKeyStorePath(config.getString("ssl.keystore.location"));
        sslContextFactory.reload(scf -> log.info("Reloaded SSL cert"));
    }
}

