/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FileWatcher.class);
    private static final ExecutorService executor = Executors.newFixedThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    });
    private volatile boolean shutdown;
    private final WatchService watchService;
    private final Path file;
    private final Callback callback;

    public FileWatcher(Path file, Callback callback) throws IOException {
        this.file = file;
        this.watchService = FileSystems.getDefault().newWatchService();
        file.getParent().register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.callback = callback;
    }

    public static void onFileChange(Path file, Callback callback) throws IOException {
        log.info("Configure watch file change: " + file);
        FileWatcher fileWatcher = new FileWatcher(file, callback);
        executor.submit(fileWatcher);
    }

    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                try {
                    this.handleNextWatchNotification();
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.info("Watch service caught exception, will continue:" + e);
                }
            }
        }
        catch (InterruptedException e) {
            log.info("Ending watch due to interrupt");
        }
    }

    private void handleNextWatchNotification() throws InterruptedException {
        log.debug("Watching file change: " + this.file);
        WatchKey key = this.watchService.take();
        log.info("Watch Key notified");
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW) {
                log.debug("Watch event is OVERFLOW");
                continue;
            }
            if (event.context() != null && !(event.context() instanceof Path)) {
                throw new ClassCastException("Expected `event.context()` to be an instance of " + Path.class + ", but it is " + event.context().getClass());
            }
            Path context = (Path)event.context();
            Path changed = this.file.getParent().resolve(context);
            log.info("Watch file change: " + context + "=>" + changed);
            if (!Files.exists(changed, new LinkOption[0]) || !changed.equals(this.file)) continue;
            log.debug("Watch matching file: " + this.file);
            try {
                this.callback.run();
            }
            catch (Exception e) {
                log.warn("Hit error callback on file change", (Throwable)e);
            }
            break;
        }
        key.reset();
    }

    public void shutdown() {
        this.shutdown = true;
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            log.info("Error closing watch service", (Throwable)e);
        }
    }

    public static interface Callback {
        public void run() throws Exception;
    }
}

