/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events.exporter;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ExporterConfig
extends AbstractConfig {
    public static final String ENABLED_CONFIG = "enabled";
    public static final String ENABLED_CONFIG_DOC = "Boolean value. True exporter should be enabled, false otherwise.";
    public static final boolean ENABLED_CONFIG_DEFAULT = true;
    public static final String TYPE_CONFIG = "type";
    public static final String TYPE_CONFIG_DOC = "The type of the exporter. Value must be on of " + Arrays.asList(ExporterType.values());
    public static final String PREFIX_EXPORTER = "confluent.telemetry.exporter.";
    public static final String PREFIX_EVENTS = "events.";
    public static final Set<String> EXPORTER_COMMON_CONFIGS = ImmutableSet.of((Object)"type", (Object)"enabled");
    public static final Set<String> EXPORTER_COMMON_CONFIG_PREFIXES = ImmutableSet.of((Object)"producer.");
    public static final Set<String> RECONFIGURABLES = ImmutableSet.of((Object)"enabled");

    private static ConfigDef defineExporterConfigs(ConfigDef def) {
        return new ConfigDef(def).define(ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, ENABLED_CONFIG_DOC).define(TYPE_CONFIG, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.LambdaValidator.with((name, value) -> ExporterConfig.parseType(value), () -> Arrays.asList(ExporterType.values()).toString()), ConfigDef.Importance.LOW, TYPE_CONFIG_DOC);
    }

    public static ExporterType parseType(Object value) {
        if (value == null || value.toString().isEmpty()) {
            throw new ConfigException("'type' is a required config.");
        }
        try {
            return ExporterType.valueOf(value.toString());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("'type' must be one of: " + Arrays.asList(ExporterType.values()) + " however we found '" + value.toString() + "'");
        }
    }

    public ExporterConfig(Map<String, ?> originals) {
        super(ExporterConfig.defineExporterConfigs(new ConfigDef()), originals);
    }

    public ExporterConfig(ConfigDef definition, Map<?, ?> originals) {
        this(definition, originals, true);
    }

    public ExporterConfig(ConfigDef definition, Map<?, ?> originals, boolean doLog) {
        super(ExporterConfig.defineExporterConfigs(definition), originals, doLog);
    }

    public ExporterType getType() {
        return ExporterConfig.parseType(this.getString(TYPE_CONFIG));
    }

    public boolean isEnabled() {
        return this.getBoolean(ENABLED_CONFIG);
    }

    public static enum ExporterType {
        http,
        kafka,
        test;

    }
}

