/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.events.exporter.kafka;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.Encoding;
import io.cloudevents.core.provider.EventFormatProvider;
import io.cloudevents.kafka.impl.KafkaSerializerMessageWriterImpl;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.EventUtils;
import io.confluent.telemetry.events.exporter.kafka.AsyncKafkaExporter;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAsyncKafkaExporter
extends AsyncKafkaExporter<Event> {
    private static final Logger log = LoggerFactory.getLogger(EventAsyncKafkaExporter.class);
    Encoding encoding = Encoding.BINARY;
    EventFormat format = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        if (configs.containsKey("cloudevent.codec") && configs.get("cloudevent.codec").equals(Encoding.STRUCTURED.toString())) {
            this.encoding = Encoding.STRUCTURED;
        }
        this.dataSerializer = event -> {
            String topic = this.topicName;
            if (event.extensionNames().contains("route")) {
                topic = event.extension("route");
            }
            CloudEvent data = EventUtils.toCloudEvent(event);
            RecordHeaders headers = new RecordHeaders();
            byte[] binaryData = this.encoding == Encoding.STRUCTURED ? (byte[])new KafkaSerializerMessageWriterImpl((Headers)headers).writeStructured(data, this.format) : (byte[])new KafkaSerializerMessageWriterImpl((Headers)headers).writeBinary(data);
            return new ProducerRecord(topic, null, null, null, (Object)binaryData, (Iterable)headers);
        };
    }
}

