/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.runtime.CucumberException;
import cucumber.runtime.MethodFormat;
import cucumber.runtime.Timeout;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class Utils {
    private Utils() {
    }

    public static boolean isInstantiable(Class<?> clazz) {
        boolean isNonStaticInnerClass = !Modifier.isStatic(clazz.getModifiers()) && clazz.getEnclosingClass() != null;
        return Modifier.isPublic(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers()) && !isNonStaticInnerClass;
    }

    public static Object invoke(final Object target, Method method, long timeoutMillis, final Object ... args) throws Throwable {
        final Method targetMethod = Utils.targetMethod(target, method);
        return Timeout.timeout(new Timeout.Callback<Object>(){

            @Override
            public Object call() throws Throwable {
                boolean accessible = targetMethod.isAccessible();
                try {
                    targetMethod.setAccessible(true);
                    Object object = targetMethod.invoke(target, args);
                    return object;
                }
                catch (IllegalArgumentException e) {
                    throw new CucumberException("Failed to invoke " + MethodFormat.FULL.format(targetMethod) + ", caused by " + e.getClass().getName() + ": " + e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    throw new CucumberException("Failed to invoke " + MethodFormat.FULL.format(targetMethod) + ", caused by " + e.getClass().getName() + ": " + e.getMessage(), e);
                }
                finally {
                    targetMethod.setAccessible(accessible);
                }
            }
        }, timeoutMillis);
    }

    private static Method targetMethod(Object target, Method method) throws NoSuchMethodException {
        Class<?> targetClass = target.getClass();
        Class<?> declaringClass = method.getDeclaringClass();
        if (targetClass.getClassLoader().equals(declaringClass.getClassLoader())) {
            return method;
        }
        if (Modifier.isPublic(method.getModifiers())) {
            return targetClass.getMethod(method.getName(), method.getParameterTypes());
        }
        for (Class<?> currentClass = targetClass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        throw new NoSuchMethodException(String.valueOf(method));
    }

    public static Type listItemType(Type type) {
        return Utils.typeArg(type, List.class, 0);
    }

    public static Type mapKeyType(Type type) {
        return Utils.typeArg(type, Map.class, 0);
    }

    public static Type mapValueType(Type type) {
        return Utils.typeArg(type, Map.class, 1);
    }

    private static Type typeArg(Type type, Class<?> wantedRawType, int index) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class && wantedRawType.isAssignableFrom((Class)rawType)) {
                Type result = parameterizedType.getActualTypeArguments()[index];
                if (result instanceof TypeVariable) {
                    throw new CucumberException("Generic types must be explicit");
                }
                return result;
            }
            return null;
        }
        return null;
    }

    public static URL toURL(String pathOrUrl) {
        try {
            if (!pathOrUrl.endsWith("/")) {
                pathOrUrl = pathOrUrl + "/";
            }
            if (pathOrUrl.matches("^(file|http|https):.*")) {
                return new URL(pathOrUrl);
            }
            return new URL("file:" + pathOrUrl);
        }
        catch (MalformedURLException e) {
            throw new CucumberException("Bad URL:" + pathOrUrl, e);
        }
    }

    public static String htmlEscape(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;").replace("/", "&#x2F;");
    }
}

