/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.formatter.Formatter;
import cucumber.api.formatter.StrictAware;
import cucumber.runtime.CucumberException;
import cucumber.runtime.formatter.TestSourcesModel;
import cucumber.runtime.io.URLOutputStream;
import cucumber.runtime.io.UTF8OutputStreamWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TestNGFormatter
implements Formatter,
StrictAware {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Writer writer;
    private final Document document;
    private final Element results;
    private final Element suite;
    private final Element test;
    private Element clazz;
    private Element root;
    private TestMethod testMethod;
    private EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        @Override
        public void receive(TestSourceRead event) {
            TestNGFormatter.this.handleTestSourceRead(event);
        }
    };
    private EventHandler<TestCaseStarted> caseStartedHandler = new EventHandler<TestCaseStarted>(){

        @Override
        public void receive(TestCaseStarted event) {
            TestNGFormatter.this.handleTestCaseStarted(event);
        }
    };
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        @Override
        public void receive(TestStepFinished event) {
            TestNGFormatter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<TestCaseFinished> caseFinishedHandler = new EventHandler<TestCaseFinished>(){

        @Override
        public void receive(TestCaseFinished event) {
            TestNGFormatter.this.handleTestCaseFinished();
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            TestNGFormatter.this.finishReport();
        }
    };

    public TestNGFormatter(URL url) throws IOException {
        this.writer = new UTF8OutputStreamWriter(new URLOutputStream(url));
        TestMethod.treatSkippedAsFailure = false;
        TestMethod.currentFeatureFile = null;
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.results = this.document.createElement("testng-results");
            this.suite = this.document.createElement("suite");
            this.test = this.document.createElement("test");
            this.suite.appendChild(this.test);
            this.results.appendChild(this.suite);
            this.document.appendChild(this.results);
        }
        catch (ParserConfigurationException e) {
            throw new CucumberException("Error initializing DocumentBuilder.", e);
        }
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    @Override
    public void setStrict(boolean strict) {
        TestMethod.treatSkippedAsFailure = strict;
    }

    private void handleTestSourceRead(TestSourceRead event) {
        TestMethod.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (TestMethod.currentFeatureFile == null || !TestMethod.currentFeatureFile.equals(event.testCase.getUri())) {
            TestMethod.currentFeatureFile = event.testCase.getUri();
            TestMethod.previousTestCaseName = "";
            TestMethod.exampleNumber = 1;
            this.clazz = this.document.createElement("class");
            this.clazz.setAttribute("name", TestMethod.testSources.getFeature(event.testCase.getUri()).getName());
            this.test.appendChild(this.clazz);
        }
        this.root = this.document.createElement("test-method");
        this.clazz.appendChild(this.root);
        this.testMethod = new TestMethod(event.testCase);
        this.testMethod.start(this.root);
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (!event.testStep.isHook()) {
            this.testMethod.steps.add(event.testStep);
            this.testMethod.results.add(event.result);
        } else {
            this.testMethod.hooks.add(event.result);
        }
    }

    private void handleTestCaseFinished() {
        this.testMethod.finish(this.document, this.root);
    }

    private void finishReport() {
        try {
            this.results.setAttribute("total", String.valueOf(this.getElementsCountByAttribute(this.suite, "status", ".*")));
            this.results.setAttribute("passed", String.valueOf(this.getElementsCountByAttribute(this.suite, "status", "PASS")));
            this.results.setAttribute("failed", String.valueOf(this.getElementsCountByAttribute(this.suite, "status", "FAIL")));
            this.results.setAttribute("skipped", String.valueOf(this.getElementsCountByAttribute(this.suite, "status", "SKIP")));
            this.suite.setAttribute("name", TestNGFormatter.class.getName());
            this.suite.setAttribute("duration-ms", this.getTotalDuration(this.suite.getElementsByTagName("test-method")));
            this.test.setAttribute("name", TestNGFormatter.class.getName());
            this.test.setAttribute("duration-ms", this.getTotalDuration(this.suite.getElementsByTagName("test-method")));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult streamResult = new StreamResult(this.writer);
            DOMSource domSource = new DOMSource(this.document);
            transformer.transform(domSource, streamResult);
            TestNGFormatter.closeQuietly(this.writer);
        }
        catch (TransformerException e) {
            throw new CucumberException("Error transforming report.", e);
        }
    }

    private int getElementsCountByAttribute(Node node, String attributeName, String attributeValue) {
        Node namedItem;
        int count = 0;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            count += this.getElementsCountByAttribute(node.getChildNodes().item(i), attributeName, attributeValue);
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (namedItem = attributes.getNamedItem(attributeName)) != null && namedItem.getNodeValue().matches(attributeValue)) {
            ++count;
        }
        return count;
    }

    private String getTotalDuration(NodeList testCaseNodes) {
        long totalDuration = 0L;
        for (int i = 0; i < testCaseNodes.getLength(); ++i) {
            try {
                String duration = testCaseNodes.item(i).getAttributes().getNamedItem("duration-ms").getNodeValue();
                totalDuration += Long.parseLong(duration);
                continue;
            }
            catch (NumberFormatException e) {
                throw new CucumberException(e);
            }
            catch (NullPointerException e) {
                throw new CucumberException(e);
            }
        }
        return String.valueOf(totalDuration);
    }

    private static void closeQuietly(Closeable out) {
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class TestMethod {
        static String currentFeatureFile;
        static boolean treatSkippedAsFailure;
        static String previousTestCaseName;
        static int exampleNumber;
        static final TestSourcesModel testSources;
        final List<TestStep> steps = new ArrayList<TestStep>();
        final List<Result> results = new ArrayList<Result>();
        final List<Result> hooks = new ArrayList<Result>();
        final TestCase scenario;

        private TestMethod(TestCase scenario) {
            this.scenario = scenario;
        }

        private void start(Element element) {
            element.setAttribute("name", this.calculateElementName(this.scenario));
            element.setAttribute("started-at", DATE_FORMAT.format(new Date()));
        }

        private String calculateElementName(TestCase testCase) {
            String testCaseName = testCase.getName();
            if (testCaseName.equals(previousTestCaseName)) {
                return testCaseName + "_" + ++exampleNumber;
            }
            previousTestCaseName = testCaseName;
            exampleNumber = 1;
            return testCaseName;
        }

        public void finish(Document doc, Element element) {
            element.setAttribute("duration-ms", this.calculateTotalDurationString());
            element.setAttribute("finished-at", DATE_FORMAT.format(new Date()));
            StringBuilder stringBuilder = new StringBuilder();
            this.addStepAndResultListing(stringBuilder);
            Result skipped = null;
            Result failed = null;
            for (Result result : this.results) {
                if (result.is(Result.Type.FAILED) || result.is(Result.Type.AMBIGUOUS)) {
                    failed = result;
                }
                if (!result.is(Result.Type.UNDEFINED) && !result.is(Result.Type.PENDING)) continue;
                skipped = result;
            }
            for (Result result : this.hooks) {
                if (failed != null || !result.is(Result.Type.FAILED)) continue;
                failed = result;
            }
            if (failed != null) {
                element.setAttribute("status", "FAIL");
                StringWriter stringWriter = new StringWriter();
                failed.getError().printStackTrace(new PrintWriter(stringWriter));
                Element exception = this.createException(doc, failed.getError().getClass().getName(), stringBuilder.toString(), stringWriter.toString());
                element.appendChild(exception);
            } else if (skipped != null) {
                if (treatSkippedAsFailure) {
                    element.setAttribute("status", "FAIL");
                    Element exception = this.createException(doc, "The scenario has pending or undefined step(s)", stringBuilder.toString(), "The scenario has pending or undefined step(s)");
                    element.appendChild(exception);
                } else {
                    element.setAttribute("status", "SKIP");
                }
            } else {
                element.setAttribute("status", "PASS");
            }
        }

        private String calculateTotalDurationString() {
            long totalDurationNanos = 0L;
            for (Result r : this.results) {
                totalDurationNanos += r.getDuration() == null ? 0L : r.getDuration();
            }
            for (Result r : this.hooks) {
                totalDurationNanos += r.getDuration() == null ? 0L : r.getDuration();
            }
            return String.valueOf(totalDurationNanos / 1000000L);
        }

        private void addStepAndResultListing(StringBuilder sb) {
            for (int i = 0; i < this.steps.size(); ++i) {
                int length = sb.length();
                String resultStatus = "not executed";
                if (i < this.results.size()) {
                    resultStatus = this.results.get(i).getStatus().lowerCaseName();
                }
                sb.append(testSources.getKeywordFromSource(currentFeatureFile, this.steps.get(i).getStepLine()) + this.steps.get(i).getStepText());
                do {
                    sb.append(".");
                } while (sb.length() - length < 76);
                sb.append(resultStatus);
                sb.append("\n");
            }
        }

        private Element createException(Document doc, String clazz, String message, String stacktrace) {
            Element exceptionElement = doc.createElement("exception");
            exceptionElement.setAttribute("class", clazz);
            if (message != null) {
                Element messageElement = doc.createElement("message");
                messageElement.appendChild(doc.createCDATASection(message));
                exceptionElement.appendChild(messageElement);
            }
            Element stacktraceElement = doc.createElement("full-stacktrace");
            stacktraceElement.appendChild(doc.createCDATASection(stacktrace));
            exceptionElement.appendChild(stacktraceElement);
            return exceptionElement;
        }

        static {
            treatSkippedAsFailure = false;
            testSources = new TestSourcesModel();
        }
    }
}

