/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.model;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class FeaturePath {
    private FeaturePath() {
    }

    public static URI parse(String featureIdentifier) {
        if (FeaturePath.nonStandardPathSeparatorInUse(featureIdentifier)) {
            String standardized = FeaturePath.replaceNonStandardPathSeparator(featureIdentifier);
            return FeaturePath.parseAssumeFileScheme(standardized);
        }
        if (FeaturePath.probablyURI(featureIdentifier)) {
            return FeaturePath.parseProbableURI(featureIdentifier);
        }
        return FeaturePath.parseAssumeFileScheme(featureIdentifier);
    }

    private static URI parseProbableURI(String featureIdentifier) {
        return URI.create(featureIdentifier);
    }

    private static boolean probablyURI(String featureIdentifier) {
        return featureIdentifier.matches("^\\w+:.*$");
    }

    private static String replaceNonStandardPathSeparator(String featureIdentifier) {
        return featureIdentifier.replace(File.separatorChar, '/');
    }

    private static boolean nonStandardPathSeparatorInUse(String featureIdentifier) {
        return File.separatorChar != '/' && featureIdentifier.contains(File.separator);
    }

    private static URI parseAssumeFileScheme(String featureIdentifier) {
        File featureFile = new File(featureIdentifier);
        if (featureFile.isAbsolute()) {
            return featureFile.toURI();
        }
        try {
            URI root = new File("").toURI();
            URI relative = root.relativize(featureFile.toURI());
            return new URI("file", relative.getSchemeSpecificPart(), relative.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

