/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.CucumberOptions;
import cucumber.runtime.CucumberException;
import cucumber.runtime.RuntimeOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RuntimeOptionsFactory {
    private final Class clazz;
    private boolean featuresSpecified = false;
    private boolean overridingGlueSpecified = false;

    public RuntimeOptionsFactory(Class clazz) {
        this.clazz = clazz;
    }

    public RuntimeOptions create() {
        List<String> args = this.buildArgsFromOptions();
        return new RuntimeOptions(args);
    }

    private List<String> buildArgsFromOptions() {
        ArrayList<String> args = new ArrayList<String>();
        Class classWithOptions = this.clazz;
        while (this.hasSuperClass(classWithOptions)) {
            CucumberOptions options = this.getOptions(classWithOptions);
            if (options != null) {
                this.addDryRun(options, args);
                this.addMonochrome(options, args);
                this.addTags(options, args);
                this.addPlugins(options, args);
                this.addStrict(options, args);
                this.addName(options, args);
                this.addSnippets(options, args);
                this.addGlue(options, args);
                this.addFeatures(options, args);
                this.addJunitOptions(options, args);
            }
            classWithOptions = classWithOptions.getSuperclass();
        }
        this.addDefaultFeaturePathIfNoFeaturePathIsSpecified(args, this.clazz);
        this.addDefaultGlueIfNoOverridingGlueIsSpecified(args, this.clazz);
        return args;
    }

    private void addName(CucumberOptions options, List<String> args) {
        for (String name : options.name()) {
            args.add("--name");
            args.add(name);
        }
    }

    private void addSnippets(CucumberOptions options, List<String> args) {
        args.add("--snippets");
        args.add(options.snippets().toString());
    }

    private void addDryRun(CucumberOptions options, List<String> args) {
        if (options.dryRun()) {
            args.add("--dry-run");
        }
    }

    private void addMonochrome(CucumberOptions options, List<String> args) {
        if (options.monochrome() || this.runningInEnvironmentWithoutAnsiSupport()) {
            args.add("--monochrome");
        }
    }

    private void addTags(CucumberOptions options, List<String> args) {
        for (String tags : options.tags()) {
            args.add("--tags");
            args.add(tags);
        }
    }

    private void addPlugins(CucumberOptions options, List<String> args) {
        ArrayList<String> plugins = new ArrayList<String>();
        plugins.addAll(Arrays.asList(options.plugin()));
        for (String plugin : plugins) {
            args.add("--plugin");
            args.add(plugin);
        }
    }

    private void addFeatures(CucumberOptions options, List<String> args) {
        if (options != null && options.features().length != 0) {
            Collections.addAll(args, options.features());
            this.featuresSpecified = true;
        }
    }

    private void addDefaultFeaturePathIfNoFeaturePathIsSpecified(List<String> args, Class clazz) {
        if (!this.featuresSpecified) {
            args.add(RuntimeOptionsFactory.packagePath(clazz));
        }
    }

    private void addGlue(CucumberOptions options, List<String> args) {
        boolean hasGlue;
        boolean hasExtraGlue = options.extraGlue().length > 0;
        boolean bl = hasGlue = options.glue().length > 0;
        if (hasExtraGlue && hasGlue) {
            throw new CucumberException("glue and extraGlue cannot be specified at the same time");
        }
        String[] gluePaths = new String[]{};
        if (hasExtraGlue) {
            gluePaths = options.extraGlue();
        }
        if (hasGlue) {
            gluePaths = options.glue();
            this.overridingGlueSpecified = true;
        }
        for (String glue : gluePaths) {
            args.add("--glue");
            args.add(glue);
        }
    }

    private void addDefaultGlueIfNoOverridingGlueIsSpecified(List<String> args, Class clazz) {
        if (!this.overridingGlueSpecified) {
            args.add("--glue");
            args.add(RuntimeOptionsFactory.packageName(clazz));
        }
    }

    private void addStrict(CucumberOptions options, List<String> args) {
        if (options.strict()) {
            args.add("--strict");
        }
    }

    private void addJunitOptions(CucumberOptions options, List<String> args) {
        for (String junitOption : options.junit()) {
            args.add("--junit," + junitOption);
        }
    }

    private static String packagePath(Class clazz) {
        String packageName = RuntimeOptionsFactory.packageName(clazz);
        if (packageName.isEmpty()) {
            return "classpath:/";
        }
        return "classpath:" + packageName.replace('.', '/');
    }

    static String packageName(Class clazz) {
        String className = clazz.getName();
        return className.substring(0, Math.max(0, className.lastIndexOf(46)));
    }

    private boolean runningInEnvironmentWithoutAnsiSupport() {
        boolean intelliJidea = System.getProperty("idea.launcher.bin.path") != null;
        return intelliJidea;
    }

    private boolean hasSuperClass(Class classWithOptions) {
        return classWithOptions != Object.class;
    }

    private CucumberOptions getOptions(Class<?> clazz) {
        return clazz.getAnnotation(CucumberOptions.class);
    }
}

