/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.stepexpression;

import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.stepexpression.Argument;
import io.cucumber.stepexpression.DataTableArgument;
import io.cucumber.stepexpression.DocStringArgument;
import io.cucumber.stepexpression.DocStringTransformer;
import io.cucumber.stepexpression.ExpressionArgument;
import io.cucumber.stepexpression.RawTableTransformer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class StepExpression {
    private final Expression expression;
    private final DocStringTransformer<?> docStringType;
    private final RawTableTransformer<?> tableType;

    StepExpression(Expression expression, DocStringTransformer<?> docStringType, RawTableTransformer<?> tableType) {
        this.expression = expression;
        this.docStringType = docStringType;
        this.tableType = tableType;
    }

    public List<Argument> match(String text, Type ... types) {
        List match = this.expression.match(text, types);
        if (match == null) {
            return null;
        }
        return StepExpression.wrapPlusOne(match);
    }

    public String getSource() {
        return this.expression.getSource();
    }

    public List<Argument> match(String text, List<List<String>> tableArgument, Type ... types) {
        List<Argument> list = this.match(text, types);
        if (list == null) {
            return null;
        }
        list.add(new DataTableArgument(this.tableType, tableArgument));
        return list;
    }

    public List<Argument> match(String text, String docStringArgument, Type ... types) {
        List<Argument> list = this.match(text, types);
        if (list == null) {
            return null;
        }
        list.add(new DocStringArgument(this.docStringType, docStringArgument));
        return list;
    }

    private static List<Argument> wrapPlusOne(List<io.cucumber.cucumberexpressions.Argument<?>> match) {
        ArrayList<Argument> copy = new ArrayList<Argument>(match.size() + 1);
        for (io.cucumber.cucumberexpressions.Argument<?> argument : match) {
            copy.add(new ExpressionArgument(argument));
        }
        return copy;
    }
}

