/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.runtime.UndefinedStepsTracker;
import java.io.PrintStream;
import java.util.List;

class UndefinedStepsPrinter
implements EventListener {
    private final UndefinedStepsTracker undefinedStepsTracker = new UndefinedStepsTracker();
    private final PrintStream out = System.out;

    private void print() {
        this.printSnippets();
    }

    private void printSnippets() {
        List<String> snippets = this.undefinedStepsTracker.getSnippets();
        if (!snippets.isEmpty()) {
            this.out.append("\n");
            this.out.println("There were undefined steps. You can implement missing steps with the snippets below:");
            this.out.println();
            for (String snippet : snippets) {
                this.out.println(snippet);
            }
        }
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        this.undefinedStepsTracker.setEventPublisher(publisher);
        publisher.registerHandlerFor(TestRunFinished.class, new EventHandler<TestRunFinished>(){

            @Override
            public void receive(TestRunFinished event) {
                UndefinedStepsPrinter.this.print();
            }
        });
    }
}

