/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.io.ClasspathResourceLoader;
import cucumber.runtime.io.FileResourceLoader;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import java.net.URI;

public class MultiLoader
implements ResourceLoader {
    static final String FILE_SCHEME = "file";
    private final ClasspathResourceLoader classpath;
    private final FileResourceLoader fs;

    public MultiLoader(ClassLoader classLoader) {
        this.classpath = new ClasspathResourceLoader(classLoader);
        this.fs = new FileResourceLoader();
    }

    @Override
    public Iterable<Resource> resources(URI path, String suffix) {
        if ("classpath".equals(path.getScheme())) {
            return this.classpath.resources(path, suffix);
        }
        if (FILE_SCHEME.equals(path.getScheme())) {
            return this.fs.resources(path, suffix);
        }
        throw new IllegalArgumentException("Unsupported scheme: " + path);
    }
}

