/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.internal.gherkin;

import io.cucumber.core.internal.gherkin.GherkinDialect;
import io.cucumber.core.internal.gherkin.IGherkinDialectProvider;
import io.cucumber.core.internal.gherkin.ParserException;
import io.cucumber.core.internal.gherkin.ast.Location;
import io.cucumber.core.internal.gherkin.deps.com.google.gson.Gson;
import io.cucumber.core.internal.gherkin.deps.com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GherkinDialectProvider
implements IGherkinDialectProvider {
    private static Map<String, Map<String, Object>> DIALECTS;
    private final String default_dialect_name;

    public GherkinDialectProvider(String default_dialect_name) {
        this.default_dialect_name = default_dialect_name;
    }

    public GherkinDialectProvider() {
        this("en");
    }

    @Override
    public GherkinDialect getDefaultDialect() {
        return this.getDialect(this.default_dialect_name, null);
    }

    @Override
    public GherkinDialect getDialect(String language, Location location) {
        Map<String, Object> map = DIALECTS.get(language);
        if (map == null) {
            throw new ParserException.NoSuchLanguageException(language, location);
        }
        return new GherkinDialect(language, map);
    }

    @Override
    public List<String> getLanguages() {
        ArrayList<String> languages = new ArrayList<String>(DIALECTS.keySet());
        Collections.sort(languages);
        return Collections.unmodifiableList(languages);
    }

    static {
        Gson gson = new Gson();
        try (InputStreamReader reader = new InputStreamReader(GherkinDialectProvider.class.getResourceAsStream("/io/cucumber/core/internal/gherkin/gherkin-languages.json"), StandardCharsets.UTF_8);){
            DIALECTS = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, Map<String, Object>>>(){}.getType());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

