/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.options.PluginOption;
import io.cucumber.core.order.PickleOrder;
import io.cucumber.core.order.StandardPickleOrders;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.snippets.SnippetType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class RuntimeOptions
implements io.cucumber.core.feature.Options,
io.cucumber.core.runner.Options,
Options,
io.cucumber.core.filter.Options,
io.cucumber.core.backend.Options {
    private final List<URI> glue = new ArrayList<URI>();
    private final List<String> tagExpressions = new ArrayList<String>();
    private final List<Pattern> nameFilters = new ArrayList<Pattern>();
    private final List<FeatureWithLines> featurePaths = new ArrayList<FeatureWithLines>();
    private boolean dryRun;
    private boolean strict = false;
    private boolean monochrome = false;
    private boolean wip = false;
    private SnippetType snippetType = SnippetType.UNDERSCORE;
    private int threads = 1;
    private PickleOrder pickleOrder = StandardPickleOrders.lexicalUriOrder();
    private int count = 0;
    private final List<Options.Plugin> formatters = new ArrayList<Options.Plugin>();
    private final List<Options.Plugin> summaryPrinters = new ArrayList<Options.Plugin>();
    private Class<? extends ObjectFactory> objectFactoryClass;

    private RuntimeOptions() {
    }

    public static RuntimeOptions defaultOptions() {
        return new RuntimeOptions();
    }

    void addDefaultFormatterIfAbsent() {
        if (this.formatters.isEmpty()) {
            this.formatters.add(PluginOption.parse("progress"));
        }
    }

    void addDefaultSummaryPrinterIfAbsent() {
        if (this.summaryPrinters.isEmpty()) {
            this.summaryPrinters.add(PluginOption.parse("default_summary"));
        }
    }

    public int getCount() {
        return this.count;
    }

    List<Options.Plugin> getFormatters() {
        return this.formatters;
    }

    List<Options.Plugin> getSummaryPrinter() {
        return this.summaryPrinters;
    }

    public boolean isMultiThreaded() {
        return this.getThreads() > 1;
    }

    public List<Options.Plugin> plugins() {
        ArrayList<Options.Plugin> plugins = new ArrayList<Options.Plugin>();
        plugins.addAll(this.formatters);
        plugins.addAll(this.summaryPrinters);
        return plugins;
    }

    @Override
    public List<URI> getGlue() {
        return Collections.unmodifiableList(this.glue);
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isWip() {
        return this.wip;
    }

    @Override
    public List<URI> getFeaturePaths() {
        return Collections.unmodifiableList(this.featurePaths.stream().map(FeatureWithLines::uri).sorted().distinct().collect(Collectors.toList()));
    }

    @Override
    public List<String> getTagExpressions() {
        return Collections.unmodifiableList(this.tagExpressions);
    }

    @Override
    public List<Pattern> getNameFilters() {
        return Collections.unmodifiableList(this.nameFilters);
    }

    void setCount(int count) {
        this.count = count;
    }

    void setFeaturePaths(List<FeatureWithLines> featurePaths) {
        this.featurePaths.clear();
        this.featurePaths.addAll(featurePaths);
    }

    void setGlue(List<URI> parsedGlue) {
        this.glue.clear();
        this.glue.addAll(parsedGlue);
    }

    void setNameFilters(List<Pattern> nameFilters) {
        this.nameFilters.clear();
        this.nameFilters.addAll(nameFilters);
    }

    void setPickleOrder(PickleOrder pickleOrder) {
        this.pickleOrder = pickleOrder;
    }

    void setTagExpressions(List<String> tagExpressions) {
        this.tagExpressions.clear();
        this.tagExpressions.addAll(tagExpressions);
    }

    @Override
    public Map<URI, Set<Integer>> getLineFilters() {
        HashMap lineFilters = new HashMap();
        this.featurePaths.forEach(featureWithLines -> {
            SortedSet<Integer> lines = featureWithLines.lines();
            URI uri = featureWithLines.uri();
            if (lines.isEmpty()) {
                return;
            }
            lineFilters.putIfAbsent(uri, new TreeSet());
            ((Set)lineFilters.get(uri)).addAll(lines);
        });
        return Collections.unmodifiableMap(lineFilters);
    }

    @Override
    public int getLimitCount() {
        return this.getCount();
    }

    @Override
    public boolean isMonochrome() {
        return this.monochrome;
    }

    @Override
    public SnippetType getSnippetType() {
        return this.snippetType;
    }

    @Override
    public Class<? extends ObjectFactory> getObjectFactoryClass() {
        return this.objectFactoryClass;
    }

    public int getThreads() {
        return this.threads;
    }

    public PickleOrder getPickleOrder() {
        return this.pickleOrder;
    }

    void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
    }

    void setSnippetType(SnippetType snippetType) {
        this.snippetType = snippetType;
    }

    void setStrict(boolean strict) {
        this.strict = strict;
    }

    void setThreads(int threads) {
        this.threads = threads;
    }

    void setWip(boolean wip) {
        this.wip = wip;
    }

    void setObjectFactoryClass(Class<? extends ObjectFactory> objectFactoryClass) {
        this.objectFactoryClass = objectFactoryClass;
    }
}

