/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.feature.GluePath;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.options.OptionsFileParser;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.core.snippets.SnippetType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Pattern;

public final class CucumberOptionsAnnotationParser {
    private final Logger log = LoggerFactory.getLogger(CucumberOptionsAnnotationParser.class);
    private boolean featuresSpecified = false;
    private boolean overridingGlueSpecified = false;
    private OptionsProvider optionsProvider;

    private static String packagePath(Class<?> clazz) {
        String packageName = CucumberOptionsAnnotationParser.packageName(clazz);
        if (packageName.isEmpty()) {
            return "classpath:/";
        }
        return "classpath:/" + packageName.replace('.', '/');
    }

    private static String packageName(Class<?> clazz) {
        String className = clazz.getName();
        return className.substring(0, Math.max(0, className.lastIndexOf(46)));
    }

    public CucumberOptionsAnnotationParser withOptionsProvider(OptionsProvider optionsProvider) {
        this.optionsProvider = optionsProvider;
        return this;
    }

    public RuntimeOptionsBuilder parse(Class<?> clazz) {
        RuntimeOptionsBuilder args = new RuntimeOptionsBuilder();
        Class<?> classWithOptions = clazz;
        while (this.hasSuperClass(classWithOptions)) {
            CucumberOptions options = Objects.requireNonNull(this.optionsProvider).getOptions(classWithOptions);
            if (options != null) {
                this.addDryRun(options, args);
                this.addMonochrome(options, args);
                this.addTags(options, args);
                this.addPlugins(options, args);
                this.addStrict(options, args);
                this.addName(options, args);
                this.addSnippets(options, args);
                this.addGlue(options, args);
                this.addFeatures(options, args);
                this.addObjectFactory(options, args);
            }
            classWithOptions = classWithOptions.getSuperclass();
        }
        this.addDefaultFeaturePathIfNoFeaturePathIsSpecified(args, clazz);
        this.addDefaultGlueIfNoOverridingGlueIsSpecified(args, clazz);
        return args;
    }

    private void addName(CucumberOptions options, RuntimeOptionsBuilder args) {
        for (String name : options.name()) {
            Pattern pattern = Pattern.compile(name);
            args.addNameFilter(pattern);
        }
    }

    private void addSnippets(CucumberOptions options, RuntimeOptionsBuilder args) {
        args.setSnippetType(options.snippets());
    }

    private void addDryRun(CucumberOptions options, RuntimeOptionsBuilder args) {
        if (options.dryRun()) {
            args.setDryRun(true);
        }
    }

    private void addMonochrome(CucumberOptions options, RuntimeOptionsBuilder args) {
        if (options.monochrome()) {
            args.setMonochrome(true);
        }
    }

    private void addTags(CucumberOptions options, RuntimeOptionsBuilder args) {
        String[] tags = options.tags();
        if (tags.length > 1) {
            this.log.warn(() -> "Passing multiple tags through @CucumberOptions is deprecated.\nPlease use a single tag expressions e.g: @CucumberOptions(tags=\"(@cucumber or @pickle) and not @salad\")");
        }
        for (String tagExpression : tags) {
            args.addTagFilter(tagExpression);
        }
    }

    private void addPlugins(CucumberOptions options, RuntimeOptionsBuilder args) {
        for (String plugin : options.plugin()) {
            args.addPluginName(plugin, false);
        }
    }

    private void addFeatures(CucumberOptions options, RuntimeOptionsBuilder args) {
        if (options != null && options.features().length != 0) {
            for (String feature : options.features()) {
                if (feature.startsWith("@")) {
                    Path rerunFile = Paths.get(feature.substring(1), new String[0]);
                    args.addRerun(OptionsFileParser.parseFeatureWithLinesFile(rerunFile));
                    continue;
                }
                FeatureWithLines featureWithLines = FeatureWithLines.parse(feature);
                args.addFeature(featureWithLines);
            }
            this.featuresSpecified = true;
        }
    }

    private void addDefaultFeaturePathIfNoFeaturePathIsSpecified(RuntimeOptionsBuilder args, Class<?> clazz) {
        if (!this.featuresSpecified) {
            String packageName = CucumberOptionsAnnotationParser.packagePath(clazz);
            FeatureWithLines featureWithLines = FeatureWithLines.parse(packageName);
            args.addFeature(featureWithLines);
        }
    }

    private void addGlue(CucumberOptions options, RuntimeOptionsBuilder args) {
        boolean hasGlue;
        boolean hasExtraGlue = options.extraGlue().length > 0;
        boolean bl = hasGlue = options.glue().length > 0;
        if (hasExtraGlue && hasGlue) {
            throw new CucumberException("glue and extraGlue cannot be specified at the same time");
        }
        String[] gluePaths = new String[]{};
        if (hasExtraGlue) {
            gluePaths = options.extraGlue();
        }
        if (hasGlue) {
            gluePaths = options.glue();
            this.overridingGlueSpecified = true;
        }
        for (String glue : gluePaths) {
            args.addGlue(GluePath.parse(glue));
        }
    }

    private void addDefaultGlueIfNoOverridingGlueIsSpecified(RuntimeOptionsBuilder args, Class<?> clazz) {
        if (!this.overridingGlueSpecified) {
            args.addGlue(GluePath.parse(CucumberOptionsAnnotationParser.packageName(clazz)));
        }
    }

    private void addStrict(CucumberOptions options, RuntimeOptionsBuilder args) {
        if (options.strict()) {
            args.setStrict(true);
        }
    }

    private void addObjectFactory(CucumberOptions options, RuntimeOptionsBuilder args) {
        if (options.objectFactory() != null) {
            args.setObjectFactoryClass(options.objectFactory());
        }
    }

    private boolean hasSuperClass(Class<?> classWithOptions) {
        return classWithOptions != Object.class;
    }

    public static interface CucumberOptions {
        public boolean dryRun();

        public boolean strict();

        public String[] features();

        public String[] glue();

        public String[] extraGlue();

        public String[] tags();

        public String[] plugin();

        public boolean monochrome();

        public String[] name();

        public SnippetType snippets();

        public Class<? extends ObjectFactory> objectFactory();
    }

    public static interface OptionsProvider {
        public CucumberOptions getOptions(Class<?> var1);
    }
}

