/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.ParameterInfo;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.stepexpression.Argument;
import io.cucumber.core.stepexpression.ArgumentMatcher;
import io.cucumber.core.stepexpression.StepExpression;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

final class CoreStepDefinition {
    private final UUID id;
    private final StepExpression expression;
    private final ArgumentMatcher argumentMatcher;
    private final StepDefinition stepDefinition;
    private final Type[] types;

    CoreStepDefinition(UUID id, StepDefinition stepDefinition, StepExpression expression) {
        this.id = Objects.requireNonNull(id);
        this.stepDefinition = Objects.requireNonNull(stepDefinition);
        this.expression = expression;
        this.argumentMatcher = new ArgumentMatcher(this.expression);
        this.types = CoreStepDefinition.getTypes(stepDefinition.parameterInfos());
    }

    private static Type[] getTypes(List<ParameterInfo> parameterInfos) {
        if (parameterInfos == null) {
            return new Type[0];
        }
        Type[] types = new Type[parameterInfos.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = parameterInfos.get(i).getType();
        }
        return types;
    }

    StepExpression getExpression() {
        return this.expression;
    }

    StepDefinition getStepDefinition() {
        return this.stepDefinition;
    }

    List<Argument> matchedArguments(Step step) {
        return this.argumentMatcher.argumentsFrom(step, this.types);
    }

    UUID getId() {
        return this.id;
    }
}

