/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.runner.HookTestStep;
import io.cucumber.core.runner.PickleStepTestStep;
import io.cucumber.core.runner.TestCaseState;
import io.cucumber.core.runner.TestStepResultStatus;
import io.cucumber.messages.Messages;
import io.cucumber.messages.TimeConversion;
import io.cucumber.plugin.event.Group;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestStep;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

final class TestCase
implements io.cucumber.plugin.event.TestCase {
    private final Pickle pickle;
    private final List<PickleStepTestStep> testSteps;
    private final boolean dryRun;
    private final List<HookTestStep> beforeHooks;
    private final List<HookTestStep> afterHooks;
    private final UUID id;

    TestCase(UUID id, List<PickleStepTestStep> testSteps, List<HookTestStep> beforeHooks, List<HookTestStep> afterHooks, Pickle pickle, boolean dryRun) {
        this.id = id;
        this.testSteps = testSteps;
        this.beforeHooks = beforeHooks;
        this.afterHooks = afterHooks;
        this.pickle = pickle;
        this.dryRun = dryRun;
    }

    private static Messages.TestCase.TestStep.StepMatchArgumentsList.StepMatchArgument.Group makeMessageGroup(Group group) {
        Messages.TestCase.TestStep.StepMatchArgumentsList.StepMatchArgument.Group.Builder builder = Messages.TestCase.TestStep.StepMatchArgumentsList.StepMatchArgument.Group.newBuilder();
        if (group == null) {
            return builder.build();
        }
        if (group.getValue() != null) {
            builder.setValue(group.getValue());
        }
        if (group.getStart() != -1) {
            builder.setStart(group.getStart());
        }
        return builder.addAllChildren((Iterable)group.getChildren().stream().map(TestCase::makeMessageGroup).collect(Collectors.toList())).build();
    }

    private static String toString(Throwable error) {
        StringWriter stringWriter = new StringWriter();
        error.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    void run(EventBus bus) {
        boolean skipNextStep = this.dryRun;
        this.emitTestCaseMessage(bus);
        Instant start = bus.getInstant();
        UUID executionId = bus.generateId();
        this.emitTestCaseStarted(bus, start, executionId);
        TestCaseState state = new TestCaseState(bus, executionId, this);
        for (HookTestStep before : this.beforeHooks) {
            skipNextStep |= before.run(this, bus, state, this.dryRun);
        }
        for (PickleStepTestStep step : this.testSteps) {
            skipNextStep |= step.run(this, bus, state, skipNextStep);
        }
        for (HookTestStep after : this.afterHooks) {
            after.run(this, bus, state, this.dryRun);
        }
        Instant stop = bus.getInstant();
        Duration duration = Duration.between(start, stop);
        Status status = Status.valueOf((String)state.getStatus().name());
        Result result = new Result(status, duration, state.getError());
        this.emitTestCaseFinished(bus, executionId, stop, duration, status, result);
    }

    public Integer getLine() {
        return this.pickle.getLocation().getLine();
    }

    public Location getLocation() {
        return this.pickle.getLocation();
    }

    public String getKeyword() {
        return this.pickle.getKeyword();
    }

    public String getName() {
        return this.pickle.getName();
    }

    public String getScenarioDesignation() {
        return this.fileColonLine(this.getLocation().getLine()) + " # " + this.getName();
    }

    private String fileColonLine(Integer line) {
        return this.pickle.getUri().getSchemeSpecificPart() + ":" + line;
    }

    public List<String> getTags() {
        return this.pickle.getTags();
    }

    public List<TestStep> getTestSteps() {
        ArrayList<TestStep> testSteps = new ArrayList<TestStep>(this.beforeHooks);
        for (PickleStepTestStep step : this.testSteps) {
            testSteps.addAll(step.getBeforeStepHookSteps());
            testSteps.add(step);
            testSteps.addAll(step.getAfterStepHookSteps());
        }
        testSteps.addAll(this.afterHooks);
        return testSteps;
    }

    public URI getUri() {
        return this.pickle.getUri();
    }

    public UUID getId() {
        return this.id;
    }

    private void emitTestCaseMessage(EventBus bus) {
        bus.send(Messages.Envelope.newBuilder().setTestCase(Messages.TestCase.newBuilder().setId(this.id.toString()).setPickleId(this.pickle.getId()).addAllTestSteps((Iterable)this.getTestSteps().stream().map(this::createTestStep).collect(Collectors.toList()))).build());
    }

    private Messages.TestCase.TestStep createTestStep(TestStep testStep) {
        Messages.TestCase.TestStep.Builder testStepBuilder = Messages.TestCase.TestStep.newBuilder().setId(testStep.getId().toString());
        if (testStep instanceof HookTestStep) {
            HookTestStep hookTestStep = (HookTestStep)testStep;
            testStepBuilder.setHookId(hookTestStep.getId().toString());
        } else if (testStep instanceof PickleStepTestStep) {
            PickleStepTestStep pickleStep = (PickleStepTestStep)testStep;
            testStepBuilder.addAllStepDefinitionIds(Collections.singletonList(pickleStep.getId().toString())).setPickleStepId(pickleStep.getStep().getId()).addStepMatchArgumentsLists(this.getStepMatchArguments(pickleStep));
        }
        return testStepBuilder.build();
    }

    public Messages.TestCase.TestStep.StepMatchArgumentsList getStepMatchArguments(PickleStepTestStep pickleStep) {
        Messages.TestCase.TestStep.StepMatchArgumentsList.Builder builder = Messages.TestCase.TestStep.StepMatchArgumentsList.newBuilder();
        pickleStep.getDefinitionArgument().forEach(arg -> builder.addStepMatchArguments(Messages.TestCase.TestStep.StepMatchArgumentsList.StepMatchArgument.newBuilder().setParameterTypeName(arg.getParameterTypeName()).setGroup(TestCase.makeMessageGroup(arg.getGroup())).build()));
        return builder.build();
    }

    private void emitTestCaseStarted(EventBus bus, Instant start, UUID executionId) {
        bus.send(new TestCaseStarted(start, (io.cucumber.plugin.event.TestCase)this));
        bus.send(Messages.Envelope.newBuilder().setTestCaseStarted(Messages.TestCaseStarted.newBuilder().setId(executionId.toString()).setTestCaseId(this.id.toString()).setTimestamp(TimeConversion.javaInstantToTimestamp((Instant)start)).build()).build());
    }

    private void emitTestCaseFinished(EventBus bus, UUID executionId, Instant stop, Duration duration, Status status, Result result) {
        bus.send(new TestCaseFinished(stop, (io.cucumber.plugin.event.TestCase)this, result));
        Messages.TestStepFinished.TestStepResult.Builder testResultBuilder = Messages.TestStepFinished.TestStepResult.newBuilder().setStatus(TestStepResultStatus.from(status)).setDuration(TimeConversion.javaDurationToDuration((Duration)duration));
        if (result.getError() != null) {
            testResultBuilder.setMessage(TestCase.toString(result.getError()));
        }
        bus.send(Messages.Envelope.newBuilder().setTestCaseFinished(Messages.TestCaseFinished.newBuilder().setTestCaseStartedId(executionId.toString()).setTimestamp(TimeConversion.javaInstantToTimestamp((Instant)stop))).build());
    }
}

