/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.plugin.NiceAppendable;
import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.messages.internal.com.google.gson.Gson;
import io.cucumber.messages.internal.com.google.gson.GsonBuilder;
import io.cucumber.messages.internal.com.google.gson.annotations.SerializedName;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Node;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseEvent;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestSourceParsed;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;

public final class TimelineFormatter
implements ConcurrentEventListener {
    private static final String[] TEXT_ASSETS = new String[]{"/io/cucumber/core/plugin/timeline/index.html", "/io/cucumber/core/plugin/timeline/formatter.js", "/io/cucumber/core/plugin/timeline/report.css", "/io/cucumber/core/plugin/timeline/jquery-3.5.1.min.js", "/io/cucumber/core/plugin/timeline/vis.min.css", "/io/cucumber/core/plugin/timeline/vis.min.js", "/io/cucumber/core/plugin/timeline/vis.override.css", "/io/cucumber/core/plugin/timeline/chosen.jquery.min.js", "/io/cucumber/core/plugin/timeline/chosen.min.css", "/io/cucumber/core/plugin/timeline/chosen.override.css", "/io/cucumber/core/plugin/timeline/chosen-sprite.png"};
    private final Map<String, TestData> allTests = new HashMap<String, TestData>();
    private final Map<Long, GroupData> allGroups = new HashMap<Long, GroupData>();
    private final File reportDir;
    private final NiceAppendable reportJs;
    private final Map<URI, Collection<Node>> parsedTestSources = new HashMap<URI, Collection<Node>>();

    public TimelineFormatter(File reportDir) throws FileNotFoundException {
        reportDir.mkdirs();
        if (!reportDir.isDirectory()) {
            throw new CucumberException(String.format("The %s needs an existing directory. Not a directory: %s", this.getClass().getName(), reportDir.getAbsolutePath()));
        }
        this.reportDir = reportDir;
        this.reportJs = new NiceAppendable(new UTF8OutputStreamWriter(new FileOutputStream(new File(reportDir, "report.js"))));
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceParsed.class, this::handleTestSourceParsed);
        publisher.registerHandlerFor(TestCaseStarted.class, this::handleTestCaseStarted);
        publisher.registerHandlerFor(TestCaseFinished.class, this::handleTestCaseFinished);
        publisher.registerHandlerFor(TestRunFinished.class, this::finishReport);
    }

    private void handleTestSourceParsed(TestSourceParsed event) {
        this.parsedTestSources.put(event.getUri(), event.getNodes());
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        Thread currentThread = Thread.currentThread();
        Long threadId = currentThread.getId();
        TestData test = new TestData(event, threadId);
        this.allTests.put(this.getId((TestCaseEvent)event), test);
        if (!this.allGroups.containsKey(threadId)) {
            this.allGroups.put(threadId, new GroupData(currentThread));
        }
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        String id = this.getId((TestCaseEvent)event);
        this.allTests.get(id).end(event);
    }

    private void finishReport(TestRunFinished event) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        this.reportJs.append("$(document).ready(function() {");
        this.reportJs.println();
        this.appendAsJsonToJs(gson, this.reportJs, "timelineItems", this.allTests.values());
        this.reportJs.println();
        this.appendAsJsonToJs(gson, this.reportJs, "timelineGroups", new TreeMap<Long, GroupData>(this.allGroups).values());
        this.reportJs.println();
        this.reportJs.append("});");
        this.reportJs.close();
        this.copyReportFiles();
    }

    private String getId(TestCaseEvent testCaseEvent) {
        return testCaseEvent.getTestCase().getId().toString();
    }

    private void appendAsJsonToJs(Gson gson, NiceAppendable out, String pushTo, Collection<?> content) {
        out.append("CucumberHTML.").append(pushTo).append(".pushArray(");
        gson.toJson(content, (Appendable)out);
        out.append(");");
    }

    private void copyReportFiles() {
        if (this.reportDir == null) {
            return;
        }
        File outputDir = new File(this.reportDir.getPath());
        for (String textAsset : TEXT_ASSETS) {
            InputStream textAssetStream = this.getClass().getResourceAsStream(textAsset);
            if (textAssetStream == null) {
                throw new CucumberException("Couldn't find " + textAsset);
            }
            String fileName = new File(textAsset).getName();
            TimelineFormatter.copyFile(textAssetStream, new File(outputDir, fileName));
            TimelineFormatter.closeQuietly(textAssetStream);
        }
    }

    private static void copyFile(InputStream source, File dest) throws CucumberException {
        FileOutputStream os = null;
        try {
            int length;
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = source.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            try {
                throw new CucumberException("Unable to write to report file item: ", e);
            }
            catch (Throwable throwable) {
                TimelineFormatter.closeQuietly(os);
                throw throwable;
            }
        }
        TimelineFormatter.closeQuietly(os);
    }

    private static void closeQuietly(Closeable out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class TestData {
        @SerializedName(value="id")
        final String id;
        @SerializedName(value="feature")
        final String feature;
        @SerializedName(value="scenario")
        final String scenario;
        @SerializedName(value="start")
        final long startTime;
        @SerializedName(value="group")
        final long threadId;
        @SerializedName(value="content")
        final String content = "";
        @SerializedName(value="tags")
        final String tags;
        @SerializedName(value="end")
        long endTime;
        @SerializedName(value="className")
        String className;

        TestData(TestCaseStarted started, Long threadId) {
            this.id = TimelineFormatter.this.getId((TestCaseEvent)started);
            TestCase testCase = started.getTestCase();
            URI uri = testCase.getUri();
            this.feature = this.findRootNodeName(testCase);
            this.scenario = testCase.getName();
            this.startTime = started.getInstant().toEpochMilli();
            this.threadId = threadId;
            this.tags = this.buildTagsValue(testCase);
        }

        private String findRootNodeName(TestCase testCase) {
            Location location = testCase.getLocation();
            Predicate<Node> withLocation = candidate -> candidate.getLocation().equals((Object)location);
            return ((Collection)TimelineFormatter.this.parsedTestSources.get(testCase.getUri())).stream().map(node -> node.findPathTo(withLocation)).filter(Optional::isPresent).map(Optional::get).findFirst().map(nodes -> (Node)nodes.get(0)).flatMap(Node::getName).orElse("Unknown");
        }

        private String buildTagsValue(TestCase testCase) {
            StringBuilder tags = new StringBuilder();
            for (String tag : testCase.getTags()) {
                tags.append(tag.toLowerCase()).append(",");
            }
            return tags.toString();
        }

        void end(TestCaseFinished event) {
            this.endTime = event.getInstant().toEpochMilli();
            this.className = event.getResult().getStatus().name().toLowerCase(Locale.ROOT);
        }
    }

    static class GroupData {
        @SerializedName(value="id")
        final long id;
        @SerializedName(value="content")
        final String content;

        GroupData(Thread thread) {
            this.id = thread.getId();
            this.content = thread.toString();
        }
    }
}

