/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.DataTableTypeDefinition;
import io.cucumber.core.backend.DefaultDataTableCellTransformerDefinition;
import io.cucumber.core.backend.DefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.backend.DefaultParameterTransformerDefinition;
import io.cucumber.core.backend.DocStringTypeDefinition;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.JavaMethodReference;
import io.cucumber.core.backend.Located;
import io.cucumber.core.backend.ParameterTypeDefinition;
import io.cucumber.core.backend.ScenarioScoped;
import io.cucumber.core.backend.SourceReference;
import io.cucumber.core.backend.StackTraceElementReference;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.runner.AmbiguousStepDefinitionsException;
import io.cucumber.core.runner.CoreDefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.runner.CoreHookDefinition;
import io.cucumber.core.runner.CoreStepDefinition;
import io.cucumber.core.runner.DuplicateDefaultDataTableCellTransformers;
import io.cucumber.core.runner.DuplicateDefaultDataTableEntryTransformers;
import io.cucumber.core.runner.DuplicateDefaultParameterTransformers;
import io.cucumber.core.runner.DuplicateStepDefinitionException;
import io.cucumber.core.runner.PickleStepDefinitionMatch;
import io.cucumber.core.stepexpression.Argument;
import io.cucumber.core.stepexpression.StepExpression;
import io.cucumber.core.stepexpression.StepExpressionFactory;
import io.cucumber.core.stepexpression.StepTypeRegistry;
import io.cucumber.cucumberexpressions.CucumberExpression;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.ParameterByTypeTransformer;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.RegularExpression;
import io.cucumber.datatable.TableCellByTypeTransformer;
import io.cucumber.datatable.TableEntryByTypeTransformer;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.event.StepDefinedEvent;
import io.cucumber.plugin.event.StepDefinition;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class CachingGlue
implements Glue {
    private static final Comparator<CoreHookDefinition> ASCENDING = Comparator.comparingInt(CoreHookDefinition::getOrder).thenComparing(ScenarioScoped.class::isInstance);
    private final List<ParameterTypeDefinition> parameterTypeDefinitions = new ArrayList<ParameterTypeDefinition>();
    private final List<DataTableTypeDefinition> dataTableTypeDefinitions = new ArrayList<DataTableTypeDefinition>();
    private final List<DefaultParameterTransformerDefinition> defaultParameterTransformers = new ArrayList<DefaultParameterTransformerDefinition>();
    private final List<CoreDefaultDataTableEntryTransformerDefinition> defaultDataTableEntryTransformers = new ArrayList<CoreDefaultDataTableEntryTransformerDefinition>();
    private final List<DefaultDataTableCellTransformerDefinition> defaultDataTableCellTransformers = new ArrayList<DefaultDataTableCellTransformerDefinition>();
    private final List<DocStringTypeDefinition> docStringTypeDefinitions = new ArrayList<DocStringTypeDefinition>();
    private final List<CoreHookDefinition> beforeHooks = new ArrayList<CoreHookDefinition>();
    private final List<CoreHookDefinition> beforeStepHooks = new ArrayList<CoreHookDefinition>();
    private final List<io.cucumber.core.backend.StepDefinition> stepDefinitions = new ArrayList<io.cucumber.core.backend.StepDefinition>();
    private final List<CoreHookDefinition> afterStepHooks = new ArrayList<CoreHookDefinition>();
    private final List<CoreHookDefinition> afterHooks = new ArrayList<CoreHookDefinition>();
    private final Map<String, String> stepPatternByStepText = new HashMap<String, String>();
    private final Map<String, CoreStepDefinition> stepDefinitionsByPattern = new TreeMap<String, CoreStepDefinition>();
    private final EventBus bus;

    CachingGlue(EventBus bus) {
        this.bus = bus;
    }

    @Override
    public void addStepDefinition(io.cucumber.core.backend.StepDefinition stepDefinition) {
        this.stepDefinitions.add(stepDefinition);
    }

    @Override
    public void addBeforeHook(HookDefinition hookDefinition) {
        this.beforeHooks.add(CoreHookDefinition.create(hookDefinition));
        this.beforeHooks.sort(ASCENDING);
    }

    @Override
    public void addAfterHook(HookDefinition hookDefinition) {
        this.afterHooks.add(CoreHookDefinition.create(hookDefinition));
        this.afterHooks.sort(ASCENDING);
    }

    @Override
    public void addBeforeStepHook(HookDefinition hookDefinition) {
        this.beforeStepHooks.add(CoreHookDefinition.create(hookDefinition));
        this.beforeStepHooks.sort(ASCENDING);
    }

    @Override
    public void addAfterStepHook(HookDefinition hookDefinition) {
        this.afterStepHooks.add(CoreHookDefinition.create(hookDefinition));
        this.afterStepHooks.sort(ASCENDING);
    }

    @Override
    public void addParameterType(ParameterTypeDefinition parameterType) {
        this.parameterTypeDefinitions.add(parameterType);
    }

    @Override
    public void addDataTableType(DataTableTypeDefinition dataTableType) {
        this.dataTableTypeDefinitions.add(dataTableType);
    }

    @Override
    public void addDefaultParameterTransformer(DefaultParameterTransformerDefinition defaultParameterTransformer) {
        this.defaultParameterTransformers.add(defaultParameterTransformer);
    }

    @Override
    public void addDefaultDataTableEntryTransformer(DefaultDataTableEntryTransformerDefinition defaultDataTableEntryTransformer) {
        this.defaultDataTableEntryTransformers.add(CoreDefaultDataTableEntryTransformerDefinition.create(defaultDataTableEntryTransformer));
    }

    @Override
    public void addDefaultDataTableCellTransformer(DefaultDataTableCellTransformerDefinition defaultDataTableCellTransformer) {
        this.defaultDataTableCellTransformers.add(defaultDataTableCellTransformer);
    }

    @Override
    public void addDocStringType(DocStringTypeDefinition docStringType) {
        this.docStringTypeDefinitions.add(docStringType);
    }

    Collection<CoreHookDefinition> getBeforeHooks() {
        return new ArrayList<CoreHookDefinition>(this.beforeHooks);
    }

    Collection<CoreHookDefinition> getBeforeStepHooks() {
        return new ArrayList<CoreHookDefinition>(this.beforeStepHooks);
    }

    Collection<CoreHookDefinition> getAfterHooks() {
        ArrayList<CoreHookDefinition> hooks = new ArrayList<CoreHookDefinition>(this.afterHooks);
        Collections.reverse(hooks);
        return hooks;
    }

    Collection<CoreHookDefinition> getAfterStepHooks() {
        ArrayList<CoreHookDefinition> hooks = new ArrayList<CoreHookDefinition>(this.afterStepHooks);
        Collections.reverse(hooks);
        return hooks;
    }

    Collection<ParameterTypeDefinition> getParameterTypeDefinitions() {
        return this.parameterTypeDefinitions;
    }

    Collection<DataTableTypeDefinition> getDataTableTypeDefinitions() {
        return this.dataTableTypeDefinitions;
    }

    Collection<io.cucumber.core.backend.StepDefinition> getStepDefinitions() {
        return this.stepDefinitions;
    }

    Map<String, String> getStepPatternByStepText() {
        return this.stepPatternByStepText;
    }

    Map<String, CoreStepDefinition> getStepDefinitionsByPattern() {
        return this.stepDefinitionsByPattern;
    }

    Collection<DefaultParameterTransformerDefinition> getDefaultParameterTransformers() {
        return this.defaultParameterTransformers;
    }

    Collection<CoreDefaultDataTableEntryTransformerDefinition> getDefaultDataTableEntryTransformers() {
        return this.defaultDataTableEntryTransformers;
    }

    Collection<DefaultDataTableCellTransformerDefinition> getDefaultDataTableCellTransformers() {
        return this.defaultDataTableCellTransformers;
    }

    List<DocStringTypeDefinition> getDocStringTypeDefinitions() {
        return this.docStringTypeDefinitions;
    }

    void prepareGlue(StepTypeRegistry stepTypeRegistry) throws DuplicateStepDefinitionException {
        ParameterByTypeTransformer transformer;
        Located definition;
        StepExpressionFactory stepExpressionFactory = new StepExpressionFactory(stepTypeRegistry, this.bus);
        this.parameterTypeDefinitions.forEach(ptd -> {
            ParameterType<?> parameterType = ptd.parameterType();
            stepTypeRegistry.defineParameterType(parameterType);
            this.emitParameterTypeDefined(parameterType);
        });
        this.dataTableTypeDefinitions.forEach(dtd -> stepTypeRegistry.defineDataTableType(dtd.dataTableType()));
        this.docStringTypeDefinitions.forEach(dtd -> stepTypeRegistry.defineDocStringType(dtd.docStringType()));
        if (this.defaultParameterTransformers.size() == 1) {
            definition = this.defaultParameterTransformers.get(0);
            transformer = definition.parameterByTypeTransformer();
            stepTypeRegistry.setDefaultParameterTransformer(transformer);
        } else if (this.defaultParameterTransformers.size() > 1) {
            throw new DuplicateDefaultParameterTransformers(this.defaultParameterTransformers);
        }
        if (this.defaultDataTableEntryTransformers.size() == 1) {
            definition = this.defaultDataTableEntryTransformers.get(0);
            transformer = definition.tableEntryByTypeTransformer();
            stepTypeRegistry.setDefaultDataTableEntryTransformer((TableEntryByTypeTransformer)transformer);
        } else if (this.defaultDataTableEntryTransformers.size() > 1) {
            throw new DuplicateDefaultDataTableEntryTransformers(this.defaultDataTableEntryTransformers);
        }
        if (this.defaultDataTableCellTransformers.size() == 1) {
            definition = this.defaultDataTableCellTransformers.get(0);
            transformer = definition.tableCellByTypeTransformer();
            stepTypeRegistry.setDefaultDataTableCellTransformer((TableCellByTypeTransformer)transformer);
        } else if (this.defaultDataTableCellTransformers.size() > 1) {
            throw new DuplicateDefaultDataTableCellTransformers(this.defaultDataTableCellTransformers);
        }
        this.beforeHooks.forEach(this::emitHook);
        this.beforeStepHooks.forEach(this::emitHook);
        this.stepDefinitions.forEach(stepDefinition -> {
            StepExpression expression = stepExpressionFactory.createExpression((io.cucumber.core.backend.StepDefinition)stepDefinition);
            CoreStepDefinition coreStepDefinition = new CoreStepDefinition(this.bus.generateId(), (io.cucumber.core.backend.StepDefinition)stepDefinition, expression);
            CoreStepDefinition previous = this.stepDefinitionsByPattern.get(stepDefinition.getPattern());
            if (previous != null) {
                throw new DuplicateStepDefinitionException(previous, (io.cucumber.core.backend.StepDefinition)stepDefinition);
            }
            this.stepDefinitionsByPattern.put(coreStepDefinition.getExpression().getSource(), coreStepDefinition);
            this.emitStepDefined(coreStepDefinition);
        });
        this.afterStepHooks.forEach(this::emitHook);
        this.afterHooks.forEach(this::emitHook);
    }

    private void emitParameterTypeDefined(ParameterType<?> parameterType) {
        this.bus.send(Messages.Envelope.newBuilder().setParameterType(Messages.ParameterType.newBuilder().setId(this.bus.generateId().toString()).setName(parameterType.getName()).addAllRegularExpressions((Iterable)parameterType.getRegexps()).setPreferForRegularExpressionMatch(parameterType.preferForRegexpMatch()).setUseForSnippets(parameterType.useForSnippets())).build());
    }

    private void emitHook(CoreHookDefinition hook) {
        Messages.Hook.Builder hookDefinitionBuilder = Messages.Hook.newBuilder().setId(hook.getId().toString()).setTagExpression(hook.getTagExpression());
        hook.getDefinitionLocation().ifPresent(reference -> hookDefinitionBuilder.setSourceReference(this.createSourceReference((SourceReference)reference)));
        this.bus.send(Messages.Envelope.newBuilder().setHook(hookDefinitionBuilder).build());
    }

    private void emitStepDefined(CoreStepDefinition stepDefinition) {
        this.bus.send(new StepDefinedEvent(this.bus.getInstant(), new StepDefinition(stepDefinition.getStepDefinition().getLocation(), stepDefinition.getExpression().getSource())));
        Messages.StepDefinition.Builder stepDefinitionBuilder = Messages.StepDefinition.newBuilder().setId(stepDefinition.getId().toString()).setPattern(Messages.StepDefinition.StepDefinitionPattern.newBuilder().setSource(stepDefinition.getExpression().getSource()).setType(this.getExpressionType(stepDefinition)));
        stepDefinition.getDefinitionLocation().ifPresent(reference -> stepDefinitionBuilder.setSourceReference(this.createSourceReference((SourceReference)reference)));
        this.bus.send(Messages.Envelope.newBuilder().setStepDefinition(stepDefinitionBuilder).build());
    }

    private Messages.SourceReference.Builder createSourceReference(SourceReference reference) {
        Messages.SourceReference.Builder sourceReferenceBuilder = Messages.SourceReference.newBuilder();
        if (reference instanceof JavaMethodReference) {
            JavaMethodReference methodReference = (JavaMethodReference)reference;
            sourceReferenceBuilder.setJavaMethod(Messages.SourceReference.JavaMethod.newBuilder().setClassName(methodReference.className()).setMethodName(methodReference.methodName()).addAllMethodParameterTypes(methodReference.methodParameterTypes()));
        }
        if (reference instanceof StackTraceElementReference) {
            StackTraceElementReference stackReference = (StackTraceElementReference)reference;
            Messages.SourceReference.JavaStackTraceElement.Builder stackTraceElementBuilder = Messages.SourceReference.JavaStackTraceElement.newBuilder().setClassName(stackReference.className()).setMethodName(stackReference.methodName());
            stackReference.fileName().ifPresent(arg_0 -> ((Messages.SourceReference.JavaStackTraceElement.Builder)stackTraceElementBuilder).setFileName(arg_0));
            sourceReferenceBuilder.setJavaStackTraceElement(stackTraceElementBuilder).setLocation(Messages.Location.newBuilder().setLine(stackReference.lineNumber()));
        }
        return sourceReferenceBuilder;
    }

    private Messages.StepDefinition.StepDefinitionPattern.StepDefinitionPatternType getExpressionType(CoreStepDefinition stepDefinition) {
        Class<? extends Expression> expressionType = stepDefinition.getExpression().getExpressionType();
        if (expressionType.isAssignableFrom(RegularExpression.class)) {
            return Messages.StepDefinition.StepDefinitionPattern.StepDefinitionPatternType.REGULAR_EXPRESSION;
        }
        if (expressionType.isAssignableFrom(CucumberExpression.class)) {
            return Messages.StepDefinition.StepDefinitionPattern.StepDefinitionPatternType.CUCUMBER_EXPRESSION;
        }
        throw new IllegalArgumentException(expressionType.getName());
    }

    PickleStepDefinitionMatch stepDefinitionMatch(URI uri, Step step) throws AmbiguousStepDefinitionsException {
        PickleStepDefinitionMatch cachedMatch = this.cachedStepDefinitionMatch(uri, step);
        if (cachedMatch != null) {
            return cachedMatch;
        }
        return this.findStepDefinitionMatch(uri, step);
    }

    private PickleStepDefinitionMatch cachedStepDefinitionMatch(URI uri, Step step) {
        String stepDefinitionPattern = this.stepPatternByStepText.get(step.getText());
        if (stepDefinitionPattern == null) {
            return null;
        }
        CoreStepDefinition coreStepDefinition = this.stepDefinitionsByPattern.get(stepDefinitionPattern);
        if (coreStepDefinition == null) {
            return null;
        }
        List<Argument> arguments = coreStepDefinition.matchedArguments(step);
        return new PickleStepDefinitionMatch(arguments, coreStepDefinition, uri, step);
    }

    private PickleStepDefinitionMatch findStepDefinitionMatch(URI uri, Step step) throws AmbiguousStepDefinitionsException {
        List<PickleStepDefinitionMatch> matches = this.stepDefinitionMatches(uri, step);
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            throw new AmbiguousStepDefinitionsException(step, matches);
        }
        PickleStepDefinitionMatch match = matches.get(0);
        this.stepPatternByStepText.put(step.getText(), match.getPattern());
        return match;
    }

    private List<PickleStepDefinitionMatch> stepDefinitionMatches(URI uri, Step step) {
        ArrayList<PickleStepDefinitionMatch> result = new ArrayList<PickleStepDefinitionMatch>();
        for (CoreStepDefinition coreStepDefinition : this.stepDefinitionsByPattern.values()) {
            List<Argument> arguments = coreStepDefinition.matchedArguments(step);
            if (arguments == null) continue;
            result.add(new PickleStepDefinitionMatch(arguments, coreStepDefinition, uri, step));
        }
        return result;
    }

    void removeScenarioScopedGlue() {
        this.stepDefinitionsByPattern.clear();
        this.removeScenarioScopedGlue(this.beforeHooks);
        this.removeScenarioScopedGlue(this.beforeStepHooks);
        this.removeScenarioScopedGlue(this.afterHooks);
        this.removeScenarioScopedGlue(this.afterStepHooks);
        this.removeScenarioScopedGlue(this.stepDefinitions);
        this.removeScenarioScopedGlue(this.dataTableTypeDefinitions);
        this.removeScenarioScopedGlue(this.docStringTypeDefinitions);
        this.removeScenarioScopedGlue(this.parameterTypeDefinitions);
        this.removeScenarioScopedGlue(this.defaultParameterTransformers);
        this.removeScenarioScopedGlue(this.defaultDataTableEntryTransformers);
        this.removeScenarioScopedGlue(this.defaultDataTableCellTransformers);
    }

    private void removeScenarioScopedGlue(Iterable<?> glues) {
        Iterator<?> glueIterator = glues.iterator();
        while (glueIterator.hasNext()) {
            Object glue = glueIterator.next();
            if (!(glue instanceof ScenarioScoped)) continue;
            ScenarioScoped scenarioScoped = (ScenarioScoped)glue;
            scenarioScoped.dispose();
            glueIterator.remove();
        }
    }
}

