/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.eventbus.IncrementingUuidGenerator;
import io.cucumber.core.eventbus.Options;
import io.cucumber.core.eventbus.RandomUuidGenerator;
import io.cucumber.core.eventbus.UuidGenerator;
import io.cucumber.core.exception.CucumberException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class UuidGeneratorServiceLoader {
    private final Supplier<ClassLoader> classLoaderSupplier;
    private final Options options;

    public UuidGeneratorServiceLoader(Supplier<ClassLoader> classLoaderSupplier, Options options) {
        this.classLoaderSupplier = Objects.requireNonNull(classLoaderSupplier);
        this.options = Objects.requireNonNull(options);
    }

    UuidGenerator loadUuidGenerator() {
        Class<? extends UuidGenerator> objectFactoryClass = this.options.getUuidGeneratorClass();
        ClassLoader classLoader = this.classLoaderSupplier.get();
        ServiceLoader<UuidGenerator> loader = ServiceLoader.load(UuidGenerator.class, classLoader);
        if (objectFactoryClass == null) {
            return UuidGeneratorServiceLoader.loadSingleUuidGeneratorOrDefault(loader);
        }
        return UuidGeneratorServiceLoader.loadSelectedUuidGenerator(loader, objectFactoryClass);
    }

    private static UuidGenerator loadSingleUuidGeneratorOrDefault(ServiceLoader<UuidGenerator> loader) {
        Iterator<UuidGenerator> uuidGenerators = loader.iterator();
        UuidGenerator randomGenerator = null;
        UuidGenerator incrementingGenerator = null;
        UuidGenerator externalGenerator = null;
        while (uuidGenerators.hasNext()) {
            UuidGenerator uuidGenerator = uuidGenerators.next();
            if (uuidGenerator instanceof RandomUuidGenerator) {
                randomGenerator = uuidGenerator;
                continue;
            }
            if (uuidGenerator instanceof IncrementingUuidGenerator) {
                incrementingGenerator = uuidGenerator;
                continue;
            }
            if (externalGenerator != null) {
                throw new CucumberException(UuidGeneratorServiceLoader.getMultipleUuidGeneratorLogMessage(Arrays.asList(externalGenerator, uuidGenerator)));
            }
            externalGenerator = uuidGenerator;
        }
        if (externalGenerator != null) {
            return externalGenerator;
        }
        if (randomGenerator != null) {
            return randomGenerator;
        }
        if (incrementingGenerator != null) {
            return incrementingGenerator;
        }
        throw new CucumberException("Could not find any UUID generator.\n\nCucumber uses SPI to discover UUID generator implementations.\nThis typically happens when using shaded jars. Make sure\nto merge all SPI definitions in META-INF/services correctly");
    }

    private static UuidGenerator loadSelectedUuidGenerator(ServiceLoader<UuidGenerator> loader, Class<? extends UuidGenerator> uuidGeneratorClass) {
        for (UuidGenerator uuidGenerator : loader) {
            if (!uuidGeneratorClass.equals(uuidGenerator.getClass())) continue;
            return uuidGenerator;
        }
        throw new CucumberException("Could not find UUID generator " + uuidGeneratorClass.getName() + ".\n\nCucumber uses SPI to discover UUID generator implementations.\nHas the class been registered with SPI and is it available on\nthe classpath?");
    }

    private static String getMultipleUuidGeneratorLogMessage(List<UuidGenerator> uuidGenerators) {
        String factoryNames = Stream.of(uuidGenerators).map(Object::getClass).map(Class::getName).collect(Collectors.joining(", "));
        return "More than one Cucumber UuidGenerator was found on the classpath\n\nFound: " + factoryNames + "\n\nYou can either remove the unnecessary SPI dependencies from your classpath\nor use the `cucumber.uuid-generator` property\nor `@CucumberOptions(uuidGenerator=...)` to select one UUID generator.\n";
    }
}

