/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.messages.Convertor;
import io.cucumber.messages.types.Attachment;
import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Hook;
import io.cucumber.messages.types.JavaMethod;
import io.cucumber.messages.types.JavaStackTraceElement;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.SourceReference;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.messages.types.TestStepStarted;
import io.cucumber.messages.types.Timestamp;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import io.cucumber.query.LineageReducer;
import io.cucumber.query.Query;
import java.io.Closeable;
import java.io.PrintStream;
import java.net.URI;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TeamCityPlugin
implements EventListener {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    private static final String TEAMCITY_PREFIX = "##teamcity";
    private static final String TEMPLATE_ENTER_THE_MATRIX = "##teamcity[enteredTheMatrix timestamp = '%s']";
    private static final String TEMPLATE_TEST_RUN_STARTED = "##teamcity[testSuiteStarted timestamp = '%s' name = 'Cucumber']";
    private static final String TEMPLATE_TEST_RUN_FINISHED = "##teamcity[testSuiteFinished timestamp = '%s' name = 'Cucumber']";
    private static final String TEMPLATE_TEST_SUITE_STARTED = "##teamcity[testSuiteStarted timestamp = '%s' locationHint = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_SUITE_FINISHED = "##teamcity[testSuiteFinished timestamp = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_STARTED = "##teamcity[testStarted timestamp = '%s' locationHint = '%s' captureStandardOutput = 'true' name = '%s']";
    private static final String TEMPLATE_TEST_FINISHED = "##teamcity[testFinished timestamp = '%s' duration = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_FAILED = "##teamcity[testFailed timestamp = '%s' duration = '%s' message = '%s' details = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_COMPARISON_FAILED = "##teamcity[testFailed timestamp = '%s' duration = '%s' message = '%s' details = '%s' expected = '%s' actual = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_IGNORED = "##teamcity[testIgnored timestamp = '%s' duration = '%s' message = '%s' name = '%s']";
    private static final String TEMPLATE_BEFORE_ALL_AFTER_ALL_STARTED = "##teamcity[testStarted timestamp = '%s' name = '%s']";
    private static final String TEMPLATE_BEFORE_ALL_AFTER_ALL_FAILED = "##teamcity[testFailed timestamp = '%s' message = '%s' details = '%s' name = '%s']";
    private static final String TEMPLATE_BEFORE_ALL_AFTER_ALL_FINISHED = "##teamcity[testFinished timestamp = '%s' name = '%s']";
    private static final String TEMPLATE_PROGRESS_COUNTING_STARTED = "##teamcity[customProgressStatus testsCategory = 'Scenarios' count = '0' timestamp = '%s']";
    private static final String TEMPLATE_PROGRESS_COUNTING_FINISHED = "##teamcity[customProgressStatus testsCategory = '' count = '0' timestamp = '%s']";
    private static final String TEMPLATE_PROGRESS_TEST_STARTED = "##teamcity[customProgressStatus type = 'testStarted' timestamp = '%s']";
    private static final String TEMPLATE_PROGRESS_TEST_FINISHED = "##teamcity[customProgressStatus type = 'testFinished' timestamp = '%s']";
    private static final String TEMPLATE_ATTACH_WRITE_EVENT = "##teamcity[message text='%s' status='NORMAL']";
    private final LineageReducer<List<TreeNode>> pathCollector = LineageReducer.descending(() -> new PathCollector());
    private final Query query = new Query();
    private final List<SnippetsSuggestedEvent> suggestions = new ArrayList<SnippetsSuggestedEvent>();
    private final TeamCityCommandWriter out;
    private List<TreeNode> currentPath = new ArrayList<TreeNode>();
    private Pickle currentPickle;

    public TeamCityPlugin() {
        this(System.out);
    }

    TeamCityPlugin(PrintStream out) {
        this.out = new TeamCityCommandWriter(out);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, event -> {
            this.query.update(event);
            event.getTestRunStarted().ifPresent(this::printTestRunStarted);
            event.getTestCaseStarted().ifPresent(this::printTestCaseStarted);
            event.getTestStepStarted().ifPresent(this::printTestStepStarted);
            event.getTestStepFinished().ifPresent(this::printTestStepFinished);
            event.getTestCaseFinished().ifPresent(this::printTestCaseFinished);
            event.getTestRunFinished().ifPresent(this::printTestRunFinished);
            event.getAttachment().ifPresent(this::handleEmbedEvent);
        });
        publisher.registerHandlerFor(SnippetsSuggestedEvent.class, this::handleSnippetSuggested);
    }

    private void printTestRunStarted(TestRunStarted event) {
        String timestamp = TeamCityPlugin.formatTimeStamp(event.getTimestamp());
        this.out.print(TEMPLATE_ENTER_THE_MATRIX, new Object[]{timestamp});
        this.out.print(TEMPLATE_TEST_RUN_STARTED, new Object[]{timestamp});
        this.out.print(TEMPLATE_PROGRESS_COUNTING_STARTED, new Object[]{timestamp});
    }

    private void printTestCaseStarted(TestCaseStarted event) {
        this.query.findPickleBy(event).ifPresent(pickle -> this.findPathTo((Pickle)pickle).ifPresent(path -> {
            String timestamp = TeamCityPlugin.formatTimeStamp(event.getTimestamp());
            this.poppedNodes((List<TreeNode>)path).forEach(node -> this.finishNode(timestamp, (TreeNode)node));
            this.pushedNodes((List<TreeNode>)path).forEach(node -> this.startNode(timestamp, (TreeNode)node));
            this.currentPath = path;
            this.currentPickle = pickle;
            this.out.print(TEMPLATE_PROGRESS_TEST_STARTED, new Object[]{timestamp});
        }));
    }

    private Optional<List<TreeNode>> findPathTo(Pickle pickle) {
        return this.query.findLineageBy(pickle).map(lineage -> (List)this.pathCollector.reduce(lineage, pickle));
    }

    private void startNode(String timestamp, TreeNode node) {
        String name = node.getName();
        String location = node.getUri() + ":" + node.getLocation().getLine();
        this.out.print(TEMPLATE_TEST_SUITE_STARTED, new Object[]{timestamp, location, name});
    }

    private void finishNode(String timestamp, TreeNode node) {
        String name = node.getName();
        this.out.print(TEMPLATE_TEST_SUITE_FINISHED, new Object[]{timestamp, name});
    }

    private List<TreeNode> poppedNodes(List<TreeNode> newStack) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(this.reversedPoppedNodes(this.currentPath, newStack));
        Collections.reverse(nodes);
        return nodes;
    }

    private List<TreeNode> reversedPoppedNodes(List<TreeNode> currentStack, List<TreeNode> newStack) {
        for (int i = 0; i < currentStack.size() && i < newStack.size(); ++i) {
            if (currentStack.get(i).equals(newStack.get(i))) continue;
            return currentStack.subList(i, currentStack.size());
        }
        if (newStack.size() < currentStack.size()) {
            return currentStack.subList(newStack.size(), currentStack.size());
        }
        return Collections.emptyList();
    }

    private List<TreeNode> pushedNodes(List<TreeNode> newStack) {
        for (int i = 0; i < this.currentPath.size() && i < newStack.size(); ++i) {
            if (this.currentPath.get(i).equals(newStack.get(i))) continue;
            return newStack.subList(i, newStack.size());
        }
        if (newStack.size() < this.currentPath.size()) {
            return Collections.emptyList();
        }
        return newStack.subList(this.currentPath.size(), newStack.size());
    }

    private void printTestStepStarted(TestStepStarted event) {
        String timestamp = TeamCityPlugin.formatTimeStamp(event.getTimestamp());
        this.query.findTestStepBy(event).ifPresent(testStep -> {
            String name = this.formatTestStepName((TestStep)testStep);
            String location = this.findPickleTestStepLocation(event, (TestStep)testStep).orElseGet(() -> this.findHookStepLocation((TestStep)testStep).orElse(""));
            this.out.print(TEMPLATE_TEST_STARTED, new Object[]{timestamp, location, name});
        });
    }

    private Optional<String> findPickleTestStepLocation(TestStepStarted testStepStarted, TestStep testStep) {
        return this.query.findPickleStepBy(testStep).flatMap(arg_0 -> ((Query)this.query).findStepBy(arg_0)).flatMap(step -> this.query.findPickleBy(testStepStarted).map(pickle -> pickle.getUri() + ":" + step.getLocation().getLine()));
    }

    private Optional<String> findHookStepLocation(TestStep testStep) {
        return this.query.findHookBy(testStep).map(Hook::getSourceReference).map(TeamCityPlugin::formatSourceLocation);
    }

    private static String formatSourceLocation(SourceReference sourceReference) {
        return sourceReference.getJavaMethod().map(TeamCityPlugin::formatJavaMethodLocation).orElseGet(() -> sourceReference.getJavaStackTraceElement().map(TeamCityPlugin::formatJavaStackTraceLocation).orElse(""));
    }

    private static String formatJavaStackTraceLocation(JavaStackTraceElement javaStackTraceElement) {
        String fqClassName = javaStackTraceElement.getClassName();
        String methodName = javaStackTraceElement.getMethodName();
        return TeamCityPlugin.createJavaTestUri(fqClassName, TeamCityPlugin.sanitizeMethodName(fqClassName, methodName));
    }

    private static String formatJavaMethodLocation(JavaMethod javaMethod) {
        String fqClassName = javaMethod.getClassName();
        String methodName = javaMethod.getMethodName();
        return TeamCityPlugin.createJavaTestUri(fqClassName, methodName);
    }

    private static String createJavaTestUri(String fqClassName, String methodName) {
        return String.format("java:test://%s/%s", fqClassName, methodName);
    }

    private void printTestStepFinished(TestStepFinished event) {
        String timeStamp = TeamCityPlugin.formatTimeStamp(event.getTimestamp());
        TestStepResult testStepResult = event.getTestStepResult();
        long duration = Convertor.toDuration((Duration)testStepResult.getDuration()).toMillis();
        this.query.findTestStepBy(event).ifPresent(testStep -> {
            String name = this.formatTestStepName((TestStep)testStep);
            Optional error = testStepResult.getException();
            TestStepResultStatus status = testStepResult.getStatus();
            switch (status) {
                case SKIPPED: {
                    String message = error.flatMap(Exception::getMessage).orElse("Step skipped");
                    this.out.print(TEMPLATE_TEST_IGNORED, new Object[]{timeStamp, duration, message, name});
                    break;
                }
                case PENDING: {
                    String details = error.flatMap(Exception::getMessage).orElse("");
                    this.out.print(TEMPLATE_TEST_FAILED, new Object[]{timeStamp, duration, "Step pending", details, name});
                    break;
                }
                case UNDEFINED: {
                    String snippets = this.findSnippets(this.currentPickle).orElse("");
                    this.out.print(TEMPLATE_TEST_FAILED, new Object[]{timeStamp, duration, "Step undefined", snippets, name});
                    break;
                }
                case AMBIGUOUS: 
                case FAILED: {
                    String details = error.flatMap(Exception::getStackTrace).orElse("");
                    String message = error.flatMap(Exception::getMessage).orElse(null);
                    if (message == null) {
                        this.out.print(TEMPLATE_TEST_FAILED, new Object[]{timeStamp, duration, "Step failed", details, name});
                        break;
                    }
                    ComparisonFailure comparisonFailure = ComparisonFailure.parse(message.trim());
                    if (comparisonFailure == null) {
                        this.out.print(TEMPLATE_TEST_FAILED, new Object[]{timeStamp, duration, "Step failed", details, name});
                        break;
                    }
                    this.out.print(TEMPLATE_TEST_COMPARISON_FAILED, new Object[]{timeStamp, duration, "Step failed", details, comparisonFailure.getExpected(), comparisonFailure.getActual(), name});
                    break;
                }
            }
            this.out.print(TEMPLATE_TEST_FINISHED, new Object[]{timeStamp, duration, name});
        });
    }

    private String formatTestStepName(TestStep testStep) {
        return this.query.findPickleStepBy(testStep).map(PickleStep::getText).orElseGet(() -> this.query.findHookBy(testStep).map(TeamCityPlugin::formatHookStepName).orElse("Unknown step"));
    }

    private static String formatHookStepName(Hook hook) {
        SourceReference sourceReference = hook.getSourceReference();
        return sourceReference.getJavaMethod().map(javaMethod -> TeamCityPlugin.formatJavaMethodName(hook, javaMethod)).orElseGet(() -> sourceReference.getJavaStackTraceElement().map(javaStackTraceElement -> TeamCityPlugin.formatJavaStackTraceName(hook, javaStackTraceElement)).orElse("Unknown"));
    }

    private static String formatJavaStackTraceName(Hook hook, JavaStackTraceElement javaStackTraceElement) {
        String methodName = javaStackTraceElement.getMethodName();
        String fqClassName = javaStackTraceElement.getClassName();
        String hookName = TeamCityPlugin.getHookName(hook);
        String sanitizeMethodName = TeamCityPlugin.sanitizeMethodName(fqClassName, methodName);
        return String.format("%s(%s)", hookName, sanitizeMethodName);
    }

    private static String sanitizeMethodName(String fqClassName, String methodName) {
        if (!methodName.equals("<init>")) {
            return methodName;
        }
        int classNameIndex = fqClassName.lastIndexOf(46);
        if (classNameIndex > 0) {
            return fqClassName.substring(classNameIndex + 1);
        }
        return methodName;
    }

    private static String formatJavaMethodName(Hook hook, JavaMethod javaMethod) {
        String methodName = javaMethod.getMethodName();
        String hookName = TeamCityPlugin.getHookName(hook);
        return String.format("%s(%s)", hookName, methodName);
    }

    private static String getHookName(Hook hook) {
        return hook.getType().map(hookType -> {
            switch (hookType) {
                case BEFORE_TEST_RUN: {
                    return "BeforeAll";
                }
                case AFTER_TEST_RUN: {
                    return "AfterAll";
                }
                case BEFORE_TEST_CASE: {
                    return "Before";
                }
                case AFTER_TEST_CASE: {
                    return "After";
                }
                case BEFORE_TEST_STEP: {
                    return "BeforeStep";
                }
                case AFTER_TEST_STEP: {
                    return "AfterStep";
                }
            }
            return "Unknown";
        }).orElse("Unknown");
    }

    private Optional<String> findSnippets(Pickle pickle) {
        return this.query.findLocationOf(pickle).map(location -> {
            URI uri = URI.create(pickle.getUri());
            List<SnippetsSuggestedEvent.Suggestion> suggestionForTestCase = this.suggestions.stream().filter(suggestion -> TeamCityPlugin.isSuggestionForPickleAt(suggestion, uri, location)).map(SnippetsSuggestedEvent::getSuggestion).collect(Collectors.toList());
            return TeamCityPlugin.createMessage(suggestionForTestCase);
        });
    }

    private static boolean isSuggestionForPickleAt(SnippetsSuggestedEvent suggestion, URI uri, Location location) {
        return suggestion.getUri().equals(uri) && (long)suggestion.getTestCaseLocation().getLine() == location.getLine();
    }

    private static String createMessage(Collection<SnippetsSuggestedEvent.Suggestion> suggestions) {
        if (suggestions.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("You can implement this step");
        if (suggestions.size() > 1) {
            sb.append(" and ").append(suggestions.size() - 1).append(" other step(s)");
        }
        sb.append(" using the snippet(s) below:\n\n");
        String snippets = suggestions.stream().map(SnippetsSuggestedEvent.Suggestion::getSnippets).flatMap(Collection::stream).distinct().collect(Collectors.joining("\n", "", "\n"));
        sb.append(snippets);
        return sb.toString();
    }

    private void printTestCaseFinished(TestCaseFinished event) {
        String timestamp = TeamCityPlugin.formatTimeStamp(event.getTimestamp());
        this.out.print(TEMPLATE_PROGRESS_TEST_FINISHED, new Object[]{timestamp});
        this.finishNode(timestamp, this.currentPath.remove(this.currentPath.size() - 1));
        this.currentPickle = null;
    }

    private void printTestRunFinished(TestRunFinished event) {
        String timestamp = TeamCityPlugin.formatTimeStamp(event.getTimestamp());
        this.out.print(TEMPLATE_PROGRESS_COUNTING_FINISHED, new Object[]{timestamp});
        ArrayList<TreeNode> emptyPath = new ArrayList<TreeNode>();
        this.poppedNodes(emptyPath).forEach(node -> this.finishNode(timestamp, (TreeNode)node));
        this.currentPath = emptyPath;
        this.printBeforeAfterAllResult(event, timestamp);
        this.out.print(TEMPLATE_TEST_RUN_FINISHED, new Object[]{timestamp});
    }

    private void printBeforeAfterAllResult(TestRunFinished event, String timestamp) {
        Optional error = event.getException();
        if (!error.isPresent()) {
            return;
        }
        String name = "Before All/After All";
        this.out.print(TEMPLATE_BEFORE_ALL_AFTER_ALL_STARTED, new Object[]{timestamp, name});
        String details = error.flatMap(Exception::getStackTrace).orElse("");
        this.out.print(TEMPLATE_BEFORE_ALL_AFTER_ALL_FAILED, new Object[]{timestamp, "Before All/After All failed", details, name});
        this.out.print(TEMPLATE_BEFORE_ALL_AFTER_ALL_FINISHED, new Object[]{timestamp, name});
    }

    private void handleSnippetSuggested(SnippetsSuggestedEvent event) {
        this.suggestions.add(event);
    }

    private void handleEmbedEvent(Attachment event) {
        switch (event.getContentEncoding()) {
            case IDENTITY: {
                this.out.print(TEMPLATE_ATTACH_WRITE_EVENT, new Object[]{"Write event:\n" + event.getBody() + "\n"});
                return;
            }
            case BASE64: {
                String name = event.getFileName().map(s -> s + " ").orElse("");
                this.out.print(TEMPLATE_ATTACH_WRITE_EVENT, new Object[]{"Embed event: " + name + "[" + event.getMediaType() + " " + event.getBody().length() / 4 * 3 + " bytes]\n"});
                return;
            }
        }
    }

    private static String formatTimeStamp(Timestamp timestamp) {
        ZonedDateTime date = Convertor.toInstant((Timestamp)timestamp).atZone(ZoneOffset.UTC);
        return DATE_FORMAT.format(date);
    }

    private static class TeamCityCommandWriter
    implements Closeable {
        private final PrintStream out;

        public TeamCityCommandWriter(PrintStream out) {
            this.out = out;
        }

        private void print(String command, Object ... args) {
            this.out.println(this.formatCommand(command, args));
        }

        private String formatCommand(String command, Object ... parameters) {
            String[] escapedParameters = new String[parameters.length];
            for (int i = 0; i < escapedParameters.length; ++i) {
                escapedParameters[i] = this.escape(parameters[i].toString());
            }
            return String.format(command, escapedParameters);
        }

        private String escape(String source) {
            if (source == null) {
                return "";
            }
            return source.replace("|", "||").replace("'", "|'").replace("\n", "|n").replace("\r", "|r").replace("[", "|[").replace("]", "|]");
        }

        @Override
        public void close() {
            this.out.close();
        }
    }

    private static final class TreeNode {
        private final String name;
        private final String uri;
        private final Location location;

        private TreeNode(String name, String uri, Location location) {
            this.name = name;
            this.uri = uri;
            this.location = location;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }

        public Location getLocation() {
            return this.location;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreeNode that = (TreeNode)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.uri, that.uri) && Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.uri, this.location);
        }
    }

    private static class ComparisonFailure {
        private static final Pattern[] COMPARE_PATTERNS = new Pattern[]{Pattern.compile("expected: (.*)(?:\r\n|\r|\n) {5}but: was (.*)$", 34), Pattern.compile("expected: (.*)(?:\r\n|\r|\n) but was: (.*)$", 34), Pattern.compile("expected: <(.*)> but was: <(.*)>$", 34), Pattern.compile("expected:\\s?<(.*)> but was:\\s?<(.*)>$", 34), Pattern.compile("expected \\[(.*)] but found \\[(.*)]\n$", 34)};
        private final String expected;
        private final String actual;

        static ComparisonFailure parse(String message) {
            for (Pattern pattern : COMPARE_PATTERNS) {
                ComparisonFailure result = ComparisonFailure.parse(message, pattern);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        static ComparisonFailure parse(String message, Pattern pattern) {
            Matcher matcher = pattern.matcher(message);
            if (!matcher.find()) {
                return null;
            }
            String expected = matcher.group(1);
            String actual = matcher.group(2);
            return new ComparisonFailure(expected, actual);
        }

        ComparisonFailure(String expected, String actual) {
            this.expected = Objects.requireNonNull(expected);
            this.actual = Objects.requireNonNull(actual);
        }

        public String getExpected() {
            return this.expected;
        }

        public String getActual() {
            return this.actual;
        }
    }

    private static class PathCollector
    implements LineageReducer.Collector<List<TreeNode>> {
        private final List<TreeNode> path = new ArrayList<TreeNode>(5);
        private String uri;
        private String scenarioName;
        private int examplesIndex;
        private boolean isExample;

        private PathCollector() {
        }

        public void add(GherkinDocument document) {
            this.uri = document.getUri().orElse("");
        }

        public void add(Feature feature) {
            String name = PathCollector.getNameOrKeyword(feature.getName(), feature.getKeyword());
            this.path.add(new TreeNode(name, this.uri, feature.getLocation()));
        }

        public void add(Rule rule) {
            String name = PathCollector.getNameOrKeyword(rule.getName(), rule.getKeyword());
            this.path.add(new TreeNode(name, this.uri, rule.getLocation()));
        }

        public void add(Scenario scenario) {
            String name = PathCollector.getNameOrKeyword(scenario.getName(), scenario.getKeyword());
            this.path.add(new TreeNode(name, this.uri, scenario.getLocation()));
            this.scenarioName = name;
        }

        public void add(Examples examples, int index) {
            String name = PathCollector.getNameOrKeyword(examples.getName(), examples.getKeyword());
            this.path.add(new TreeNode(name, this.uri, examples.getLocation()));
            this.examplesIndex = index;
        }

        public void add(TableRow example, int index) {
            this.isExample = true;
            String name = "#" + (this.examplesIndex + 1) + "." + (index + 1);
            this.path.add(new TreeNode(name, this.uri, example.getLocation()));
        }

        public void add(Pickle pickle) {
            if (this.isExample) {
                boolean parameterized;
                String pickleName = pickle.getName();
                boolean bl = parameterized = !this.scenarioName.equals(pickleName);
                if (parameterized) {
                    TreeNode example = this.path.remove(this.path.size() - 1);
                    String parameterizedExampleName = example.getName() + ": " + pickleName;
                    this.path.add(new TreeNode(parameterizedExampleName, example.getUri(), example.getLocation()));
                }
            }
        }

        public List<TreeNode> finish() {
            return this.path;
        }

        private static String getNameOrKeyword(String name, String keyword) {
            if (!name.isEmpty()) {
                return name;
            }
            if (!keyword.isEmpty()) {
                return keyword;
            }
            return "Unknown";
        }
    }
}

