/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.ScenarioScoped;
import io.cucumber.core.backend.SourceReference;
import io.cucumber.core.backend.TestCaseState;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionException;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;

class CoreHookDefinition {
    private final UUID id;
    protected final HookDefinition delegate;
    private final Expression tagExpression;

    private CoreHookDefinition(UUID id, HookDefinition delegate) {
        this.id = Objects.requireNonNull(id);
        this.delegate = delegate;
        try {
            this.tagExpression = TagExpressionParser.parse((String)delegate.getTagExpression());
        }
        catch (TagExpressionException tee) {
            throw new IllegalArgumentException(String.format("Invalid tag expression at '%s'", delegate.getLocation()), tee);
        }
    }

    static CoreHookDefinition create(HookDefinition hookDefinition, Supplier<UUID> uuidGenerator) {
        if (hookDefinition instanceof ScenarioScoped) {
            return new ScenarioScopedCoreHookDefinition(uuidGenerator.get(), hookDefinition);
        }
        return new CoreHookDefinition(uuidGenerator.get(), hookDefinition);
    }

    void execute(TestCaseState scenario) {
        this.delegate.execute(scenario);
    }

    HookDefinition getDelegate() {
        return this.delegate;
    }

    String getLocation() {
        return this.delegate.getLocation();
    }

    UUID getId() {
        return this.id;
    }

    int getOrder() {
        return this.delegate.getOrder();
    }

    boolean matches(List<String> tags) {
        return this.tagExpression.evaluate(tags);
    }

    String getTagExpression() {
        return this.delegate.getTagExpression();
    }

    Optional<HookDefinition.HookType> getHookType() {
        return this.delegate.getHookType();
    }

    Optional<SourceReference> getDefinitionLocation() {
        return this.delegate.getSourceReference();
    }

    static class ScenarioScopedCoreHookDefinition
    extends CoreHookDefinition
    implements ScenarioScoped {
        private ScenarioScopedCoreHookDefinition(UUID id, HookDefinition delegate) {
            super(id, delegate);
        }

        @Override
        public void dispose() {
            if (this.delegate instanceof ScenarioScoped) {
                ScenarioScoped scenarioScoped = (ScenarioScoped)((Object)this.delegate);
                scenarioScoped.dispose();
            }
        }
    }
}

