/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.prettyformatter.MessagesToPrettyWriter;
import io.cucumber.prettyformatter.Theme;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public final class PrettyFormatter
implements ConcurrentEventListener,
ColorAware {
    private final OutputStream out;
    private MessagesToPrettyWriter writer;

    public PrettyFormatter(OutputStream out) {
        this.out = out;
        this.writer = PrettyFormatter.createBuilder().build(out);
    }

    private static MessagesToPrettyWriter.Builder createBuilder() {
        String cwdUri = new File("").toPath().toUri().toString();
        return MessagesToPrettyWriter.builder().feature(MessagesToPrettyWriter.PrettyFeature.INCLUDE_FEATURE_LINE, false).feature(MessagesToPrettyWriter.PrettyFeature.INCLUDE_RULE_LINE, false).theme(Theme.cucumber()).removeUriPrefix(cwdUri);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, this::write);
    }

    private void write(Envelope event) {
        try {
            this.writer.write(event);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (event.getTestRunFinished().isPresent()) {
            this.writer.close();
        }
    }

    public void setMonochrome(boolean monochrome) {
        if (monochrome) {
            this.writer = PrettyFormatter.createBuilder().theme(Theme.plain()).build(this.out);
        }
    }
}

