/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.usageformatter.MessagesToUsageWriter;
import io.cucumber.usageformatter.UsageReportSerializer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public final class UsageFormatter
implements Plugin,
ConcurrentEventListener {
    private final MessagesToUsageWriter writer;

    public UsageFormatter(OutputStream out) {
        String cwdUri = new File("").toPath().toUri().toString();
        this.writer = MessagesToUsageWriter.builder((MessagesToUsageWriter.Serializer)UsageReportSerializer.builder().feature(UsageReportSerializer.PlainTextFeature.INCLUDE_STEPS, true).maxStepsPerStepDefinition(5).removeUriPrefix(cwdUri).build()).build(out);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, this::write);
    }

    private void write(Envelope event) {
        try {
            this.writer.write(event);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (event.getTestRunFinished().isPresent()) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

