/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.snippets;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class GherkinKeywordNormalizer {
    private GherkinKeywordNormalizer() {
    }

    public static String normalizeKeyword(String language, String keyword) {
        if ("em".equals(language)) {
            return GherkinKeywordNormalizer.normalizeEmojiKeyword(keyword);
        }
        return GherkinKeywordNormalizer.normalizeKeyword(keyword);
    }

    public static String normalizeLanguage(String language) {
        return language.replaceAll("[\\s-]", "_").toLowerCase();
    }

    private static String normalizeKeyword(String keyword) {
        return GherkinKeywordNormalizer.normalize(keyword.replaceAll("[\\s',!\u00ad\u2019]", ""));
    }

    private static String normalizeEmojiKeyword(String keyword) {
        String titleCasedName = GherkinKeywordNormalizer.getCodePoints(keyword).mapToObj(Character::getName).map(s -> s.split(" ")).flatMap(Arrays::stream).map(String::toLowerCase).map(GherkinKeywordNormalizer::capitalize).collect(Collectors.joining(" "));
        return GherkinKeywordNormalizer.normalizeKeyword(titleCasedName);
    }

    private static String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static String normalize(CharSequence s) {
        return Normalizer.normalize(s, Normalizer.Form.NFC);
    }

    private static IntStream getCodePoints(String s) {
        int codepoint;
        int length = s.length();
        ArrayList<Integer> codePoints = new ArrayList<Integer>();
        for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(offset);
            codePoints.add(codepoint);
        }
        return codePoints.stream().mapToInt(value -> value);
    }
}

