/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.messages.GherkinMessagesLocation;
import io.cucumber.core.gherkin.messages.GherkinMessagesRule;
import io.cucumber.core.gherkin.messages.GherkinMessagesScenario;
import io.cucumber.core.gherkin.messages.GherkinMessagesScenarioOutline;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Node;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

final class GherkinMessagesFeature
implements Feature {
    private final Messages.GherkinDocument.Feature feature;
    private final URI uri;
    private final List<Pickle> pickles;
    private final List<Messages.Envelope> envelopes;
    private final String gherkinSource;
    private final List<Node> children;

    GherkinMessagesFeature(Messages.GherkinDocument.Feature feature, URI uri, String gherkinSource, List<Pickle> pickles, List<Messages.Envelope> envelopes) {
        this.feature = Objects.requireNonNull(feature);
        this.uri = Objects.requireNonNull(uri);
        this.gherkinSource = Objects.requireNonNull(gherkinSource);
        this.pickles = Objects.requireNonNull(pickles);
        this.envelopes = Objects.requireNonNull(envelopes);
        this.children = feature.getChildrenList().stream().filter(this::hasRuleOrScenario).map(this::mapRuleOrScenario).collect(Collectors.toList());
    }

    private Node mapRuleOrScenario(Messages.GherkinDocument.Feature.FeatureChild featureChild) {
        if (featureChild.hasRule()) {
            return new GherkinMessagesRule(featureChild.getRule());
        }
        Messages.GherkinDocument.Feature.Scenario scenario = featureChild.getScenario();
        if (scenario.getExamplesCount() > 0) {
            return new GherkinMessagesScenarioOutline(scenario);
        }
        return new GherkinMessagesScenario(scenario);
    }

    private boolean hasRuleOrScenario(Messages.GherkinDocument.Feature.FeatureChild featureChild) {
        return featureChild.hasRule() || featureChild.hasScenario();
    }

    public Collection<Node> elements() {
        return this.children;
    }

    public Location getLocation() {
        return GherkinMessagesLocation.from(this.feature.getLocation());
    }

    public Optional<String> getKeyword() {
        return Optional.of(this.feature.getKeyword());
    }

    public Optional<String> getName() {
        String name = this.feature.getName();
        return name.isEmpty() ? Optional.empty() : Optional.of(name);
    }

    public Pickle getPickleAt(Node node) {
        Location location = node.getLocation();
        return this.pickles.stream().filter(pickle -> pickle.getLocation().equals((Object)location)).findFirst().orElseThrow(() -> new NoSuchElementException("No pickle in " + this.uri + " at " + location));
    }

    public List<Pickle> getPickles() {
        return this.pickles;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getSource() {
        return this.gherkinSource;
    }

    public Iterable<?> getParseEvents() {
        return this.envelopes;
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GherkinMessagesFeature that = (GherkinMessagesFeature)o;
        return this.uri.equals(that.uri);
    }
}

