/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.messages.GherkinMessagesExample;
import io.cucumber.core.gherkin.messages.GherkinMessagesLocation;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Node;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

final class GherkinMessagesExamples
implements Node.Examples {
    private final Messages.GherkinDocument.Feature.Scenario.Examples examples;
    private final List<Node.Example> children;
    private final Location location;

    GherkinMessagesExamples(Messages.GherkinDocument.Feature.Scenario.Examples examples) {
        this.examples = examples;
        this.location = GherkinMessagesLocation.from(examples.getLocation());
        AtomicInteger row = new AtomicInteger(1);
        this.children = examples.getTableBodyList().stream().map(tableRow -> new GherkinMessagesExample((Messages.GherkinDocument.Feature.TableRow)tableRow, row.getAndIncrement())).collect(Collectors.toList());
    }

    public Collection<Node.Example> elements() {
        return this.children;
    }

    public Location getLocation() {
        return this.location;
    }

    public Optional<String> getKeyword() {
        return Optional.of(this.examples.getKeyword());
    }

    public Optional<String> getName() {
        String name = this.examples.getName();
        return name.isEmpty() ? Optional.empty() : Optional.of(name);
    }
}

