/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java.ObjectFactory;
import cucumber.runtime.MethodFormat;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.Utils;
import cucumber.runtime.java.ParameterInfo;
import gherkin.pickles.PickleStep;
import io.cucumber.stepexpression.Argument;
import io.cucumber.stepexpression.ExpressionArgumentMatcher;
import io.cucumber.stepexpression.StepExpression;
import io.cucumber.stepexpression.StepExpressionFactory;
import io.cucumber.stepexpression.TypeRegistry;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

class JavaStepDefinition
implements StepDefinition {
    private final Method method;
    private final StepExpression expression;
    private final long timeoutMillis;
    private final ObjectFactory objectFactory;
    private final List<ParameterInfo> parameterInfos;

    JavaStepDefinition(Method method, String expression, long timeoutMillis, ObjectFactory objectFactory, TypeRegistry typeRegistry) {
        this.method = method;
        this.timeoutMillis = timeoutMillis;
        this.objectFactory = objectFactory;
        this.parameterInfos = ParameterInfo.fromMethod(method);
        this.expression = this.createExpression(expression, typeRegistry);
    }

    private StepExpression createExpression(String expression, TypeRegistry typeRegistry) {
        if (this.parameterInfos.isEmpty()) {
            return new StepExpressionFactory(typeRegistry).createExpression(expression);
        }
        ParameterInfo parameterInfo = this.parameterInfos.get(this.parameterInfos.size() - 1);
        return new StepExpressionFactory(typeRegistry).createExpression(expression, parameterInfo.getType(), parameterInfo.isTransposed());
    }

    public void execute(Object[] args) throws Throwable {
        Utils.invoke(this.objectFactory.getInstance(this.method.getDeclaringClass()), (Method)this.method, (long)this.timeoutMillis, (Object[])args);
    }

    public List<Argument> matchedArguments(PickleStep step) {
        ExpressionArgumentMatcher argumentMatcher = new ExpressionArgumentMatcher(this.expression);
        Type[] types = new Type[this.parameterInfos.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.parameterInfos.get(i).getType();
        }
        return argumentMatcher.argumentsFrom(step, types);
    }

    public String getLocation(boolean detail) {
        MethodFormat format = detail ? MethodFormat.FULL : MethodFormat.SHORT;
        return format.format(this.method);
    }

    public Integer getParameterCount() {
        return this.parameterInfos.size();
    }

    public boolean isDefinedAt(StackTraceElement e) {
        return e.getClassName().equals(this.method.getDeclaringClass().getName()) && e.getMethodName().equals(this.method.getName());
    }

    public String getPattern() {
        return this.expression.getSource();
    }

    public boolean isScenarioScoped() {
        return false;
    }
}

