/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java.After;
import cucumber.api.java.AfterStep;
import cucumber.api.java.Before;
import cucumber.api.java.BeforeStep;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Utils;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.java.JavaBackend;
import cucumber.runtime.java.StepDefAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;

class MethodScanner {
    private final ClassFinder classFinder;

    public MethodScanner(ClassFinder classFinder) {
        this.classFinder = classFinder;
    }

    public void scan(JavaBackend javaBackend, List<String> gluePaths) {
        for (String gluePath : gluePaths) {
            Iterator iterator = this.classFinder.getDescendants(Object.class, MultiLoader.packageName((String)gluePath)).iterator();
            while (iterator.hasNext()) {
                Class glueCodeClass;
                for (glueCodeClass = (Class)iterator.next(); glueCodeClass != null && glueCodeClass != Object.class && !Utils.isInstantiable((Class)glueCodeClass); glueCodeClass = glueCodeClass.getSuperclass()) {
                }
                if (glueCodeClass == null || glueCodeClass == Object.class) continue;
                for (Method method : glueCodeClass.getMethods()) {
                    if (method.getDeclaringClass() == Object.class) continue;
                    this.scan(javaBackend, method, glueCodeClass);
                }
            }
        }
    }

    public void scan(JavaBackend javaBackend, Method method, Class<?> glueCodeClass) {
        Annotation[] methodAnnotations;
        for (Annotation annotation : methodAnnotations = method.getAnnotations()) {
            if (this.isHookAnnotation(annotation)) {
                this.validateMethod(method, glueCodeClass);
                javaBackend.addHook(annotation, method);
                continue;
            }
            if (!this.isStepdefAnnotation(annotation)) continue;
            this.validateMethod(method, glueCodeClass);
            javaBackend.addStepDefinition(annotation, method);
        }
    }

    private void validateMethod(Method method, Class<?> glueCodeClass) {
        if (!method.getDeclaringClass().isAssignableFrom(glueCodeClass)) {
            throw new CucumberException(String.format("%s isn't assignable from %s", method.getDeclaringClass(), glueCodeClass));
        }
        if (!glueCodeClass.equals(method.getDeclaringClass())) {
            throw new CucumberException(String.format("You're not allowed to extend classes that define Step Definitions or hooks. %s extends %s", glueCodeClass, method.getDeclaringClass()));
        }
    }

    private boolean isHookAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.equals(Before.class) || annotationClass.equals(After.class) || annotationClass.equals(BeforeStep.class) || annotationClass.equals(AfterStep.class);
    }

    private boolean isStepdefAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        return annotationClass.getAnnotation(StepDefAnnotation.class) != null;
    }
}

