/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.DefaultParameterTransformerDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.cucumberexpressions.ParameterByTypeTransformer;
import io.cucumber.java.AbstractGlueDefinition;
import io.cucumber.java.DefaultParameterTransformer;
import io.cucumber.java.InvalidMethodSignatureException;
import io.cucumber.java.Invoker;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class JavaDefaultParameterTransformerDefinition
extends AbstractGlueDefinition
implements DefaultParameterTransformerDefinition {
    private final Lookup lookup;
    private final ParameterByTypeTransformer transformer;

    JavaDefaultParameterTransformerDefinition(Method method, Lookup lookup) {
        super(JavaDefaultParameterTransformerDefinition.requireValidMethod(method), lookup);
        this.lookup = lookup;
        this.transformer = this::execute;
    }

    private static Method requireValidMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        if (Void.class.equals(returnType) || Void.TYPE.equals(returnType)) {
            throw JavaDefaultParameterTransformerDefinition.createInvalidSignatureException(method);
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 2) {
            throw JavaDefaultParameterTransformerDefinition.createInvalidSignatureException(method);
        }
        if (!Object.class.equals(parameterTypes[0]) && !String.class.equals(parameterTypes[0])) {
            throw JavaDefaultParameterTransformerDefinition.createInvalidSignatureException(method);
        }
        if (!Type.class.equals(parameterTypes[1])) {
            throw JavaDefaultParameterTransformerDefinition.createInvalidSignatureException(method);
        }
        return method;
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(DefaultParameterTransformer.class).addSignature("public Object defaultDataTableEntry(String fromValue, Type toValueType)").addSignature("public Object defaultDataTableEntry(Object fromValue, Type toValueType)").build();
    }

    public ParameterByTypeTransformer parameterByTypeTransformer() {
        return this.transformer;
    }

    private Object execute(String fromValue, Type toValueType) {
        return Invoker.invoke(this, this.lookup.getInstance(this.method.getDeclaringClass()), this.method, fromValue, toValueType);
    }
}

