/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.DataTableTypeDefinition;
import io.cucumber.core.backend.DefaultDataTableCellTransformerDefinition;
import io.cucumber.core.backend.DefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.backend.DefaultParameterTransformerDefinition;
import io.cucumber.core.backend.DocStringTypeDefinition;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.ParameterTypeDefinition;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.java.After;
import io.cucumber.java.AfterStep;
import io.cucumber.java.Before;
import io.cucumber.java.BeforeStep;
import io.cucumber.java.DataTableType;
import io.cucumber.java.DefaultDataTableCellTransformer;
import io.cucumber.java.DefaultDataTableEntryTransformer;
import io.cucumber.java.DefaultParameterTransformer;
import io.cucumber.java.DocStringType;
import io.cucumber.java.Invoker;
import io.cucumber.java.JavaDataTableTypeDefinition;
import io.cucumber.java.JavaDefaultDataTableCellTransformerDefinition;
import io.cucumber.java.JavaDefaultDataTableEntryTransformerDefinition;
import io.cucumber.java.JavaDefaultParameterTransformerDefinition;
import io.cucumber.java.JavaDocStringTypeDefinition;
import io.cucumber.java.JavaHookDefinition;
import io.cucumber.java.JavaParameterTypeDefinition;
import io.cucumber.java.JavaStepDefinition;
import io.cucumber.java.ParameterType;
import io.cucumber.java.StepDefinitionAnnotation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

final class GlueAdaptor {
    private final Lookup lookup;
    private final Glue glue;

    GlueAdaptor(Lookup lookup, Glue glue) {
        this.lookup = lookup;
        this.glue = glue;
    }

    void addDefinition(Method method, Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (annotationType.getAnnotation(StepDefinitionAnnotation.class) != null) {
            String expression = GlueAdaptor.expression(annotation);
            this.glue.addStepDefinition((StepDefinition)new JavaStepDefinition(method, expression, this.lookup));
        } else if (annotationType.equals(Before.class)) {
            Before before = (Before)annotation;
            String tagExpression = before.value();
            this.glue.addBeforeHook((HookDefinition)new JavaHookDefinition(method, tagExpression, before.order(), this.lookup));
        } else if (annotationType.equals(After.class)) {
            After after = (After)annotation;
            String tagExpression = after.value();
            this.glue.addAfterHook((HookDefinition)new JavaHookDefinition(method, tagExpression, after.order(), this.lookup));
        } else if (annotationType.equals(BeforeStep.class)) {
            BeforeStep beforeStep = (BeforeStep)annotation;
            String tagExpression = beforeStep.value();
            this.glue.addBeforeStepHook((HookDefinition)new JavaHookDefinition(method, tagExpression, beforeStep.order(), this.lookup));
        } else if (annotationType.equals(AfterStep.class)) {
            AfterStep afterStep = (AfterStep)annotation;
            String tagExpression = afterStep.value();
            this.glue.addAfterStepHook((HookDefinition)new JavaHookDefinition(method, tagExpression, afterStep.order(), this.lookup));
        } else if (annotationType.equals(ParameterType.class)) {
            ParameterType parameterType = (ParameterType)annotation;
            String pattern = parameterType.value();
            String name = parameterType.name();
            boolean useForSnippets = parameterType.useForSnippets();
            boolean preferForRegexMatch = parameterType.preferForRegexMatch();
            boolean useRegexpMatchAsStrongTypeHint = parameterType.useRegexpMatchAsStrongTypeHint();
            this.glue.addParameterType((ParameterTypeDefinition)new JavaParameterTypeDefinition(name, pattern, method, useForSnippets, preferForRegexMatch, useRegexpMatchAsStrongTypeHint, this.lookup));
        } else if (annotationType.equals(DataTableType.class)) {
            DataTableType dataTableType = (DataTableType)annotation;
            this.glue.addDataTableType((DataTableTypeDefinition)new JavaDataTableTypeDefinition(method, this.lookup, dataTableType.replaceWithEmptyString()));
        } else if (annotationType.equals(DefaultParameterTransformer.class)) {
            this.glue.addDefaultParameterTransformer((DefaultParameterTransformerDefinition)new JavaDefaultParameterTransformerDefinition(method, this.lookup));
        } else if (annotationType.equals(DefaultDataTableEntryTransformer.class)) {
            DefaultDataTableEntryTransformer transformer = (DefaultDataTableEntryTransformer)annotation;
            boolean headersToProperties = transformer.headersToProperties();
            String[] replaceWithEmptyString = transformer.replaceWithEmptyString();
            this.glue.addDefaultDataTableEntryTransformer((DefaultDataTableEntryTransformerDefinition)new JavaDefaultDataTableEntryTransformerDefinition(method, this.lookup, headersToProperties, replaceWithEmptyString));
        } else if (annotationType.equals(DefaultDataTableCellTransformer.class)) {
            DefaultDataTableCellTransformer cellTransformer = (DefaultDataTableCellTransformer)annotation;
            String[] emptyPatterns = cellTransformer.replaceWithEmptyString();
            this.glue.addDefaultDataTableCellTransformer((DefaultDataTableCellTransformerDefinition)new JavaDefaultDataTableCellTransformerDefinition(method, this.lookup, emptyPatterns));
        } else if (annotationType.equals(DocStringType.class)) {
            DocStringType docStringType = (DocStringType)annotation;
            String contentType = docStringType.contentType();
            this.glue.addDocStringType((DocStringTypeDefinition)new JavaDocStringTypeDefinition(contentType, method, this.lookup));
        }
    }

    private static String expression(Annotation annotation) {
        try {
            Method expressionMethod = annotation.getClass().getMethod("value", new Class[0]);
            return (String)Invoker.invoke(annotation, expressionMethod);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }
}

