package cucumber.api.java8;

import cucumber.api.java8.StepdefBody.A0;
import cucumber.api.java8.StepdefBody.A1;
import cucumber.api.java8.StepdefBody.A2;
import cucumber.api.java8.StepdefBody.A3;
import cucumber.api.java8.StepdefBody.A4;
import cucumber.api.java8.StepdefBody.A5;
import cucumber.api.java8.StepdefBody.A6;
import cucumber.api.java8.StepdefBody.A7;
import cucumber.api.java8.StepdefBody.A8;
import cucumber.api.java8.StepdefBody.A9;

import cucumber.runtime.java.LambdaGlueRegistry;
import cucumber.runtime.java8.Java8StepDefinition;
import cucumber.runtime.java8.LambdaGlueBase;

/**
 * To execute steps in a feature file the steps must be
 * connected to executable code. This can be done by
 * implementing this interface.
 * <p>
 * The parameters extracted from the step by the expression
 * along with the data table or doc string argument are provided as
 * arguments to the lambda expression.
 * <p>
 * The types of the parameters are determined by the cucumber or
 * regular expression.
 * <p>
 * The type of the data table or doc string argument is determined
 * by the argument name value. When none is provided cucumber will
 * attempt to transform the data table or doc string to the the
 * type of last argument.
 */
public interface Ga extends LambdaGlueBase {

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Ach(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Ach(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Ach(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Ach(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Ach(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Ach(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Ach(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Ach(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Ach(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Ach(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Ach(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Ach(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Ach(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Ach(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Ach(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Ach(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ach(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ach(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ach(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ach(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Agus(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Agus(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Agus(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Agus(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Agus(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Agus(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Agus(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Agus(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Agus(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Agus(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Agus(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Agus(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Agus(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Agus(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Agus(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Agus(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Agus(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Agus(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Agus(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Agus(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Ansin(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Ansin(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Ansin(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Ansin(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Ansin(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Ansin(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Ansin(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Ansin(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Ansin(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Ansin(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Ansin(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Ansin(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Ansin(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Ansin(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Ansin(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Ansin(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ansin(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Ansin(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ansin(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Ansin(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Cuirigcásgo(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Cuirigcásgo(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Cuirigcásgo(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Cuirigcásgo(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Cuirigcásgo(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Cuirigcásgo(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Cuirigcásgo(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Cuirigcásgo(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Cuirigcásgo(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Cuirigcásgo(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Cuirigcásgo(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Cuirigcásgo(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Cuirigcásgo(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Cuirigcásgo(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Cuirigcásgo(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Cuirigcásgo(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Cuirigcásgo(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Cuirigcásgo(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Cuirigcásgo(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Cuirigcásgo(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Cuirigcásgur(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Cuirigcásgur(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Cuirigcásgur(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Cuirigcásgur(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Cuirigcásgur(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Cuirigcásgur(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Cuirigcásgur(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Cuirigcásgur(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Cuirigcásgur(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Cuirigcásgur(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Cuirigcásgur(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Cuirigcásgur(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Cuirigcásgur(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Cuirigcásgur(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Cuirigcásgur(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Cuirigcásgur(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Cuirigcásgur(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Cuirigcásgur(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Cuirigcásgur(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Cuirigcásgur(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Cuirigcásnach(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Cuirigcásnach(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Cuirigcásnach(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Cuirigcásnach(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Cuirigcásnach(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Cuirigcásnach(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Cuirigcásnach(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Cuirigcásnach(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Cuirigcásnach(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Cuirigcásnach(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Cuirigcásnach(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Cuirigcásnach(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Cuirigcásnach(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Cuirigcásnach(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Cuirigcásnach(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Cuirigcásnach(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Cuirigcásnach(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Cuirigcásnach(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Cuirigcásnach(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Cuirigcásnach(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Cuirigcásnár(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Cuirigcásnár(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Cuirigcásnár(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Cuirigcásnár(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Cuirigcásnár(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Cuirigcásnár(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Cuirigcásnár(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Cuirigcásnár(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Cuirigcásnár(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Cuirigcásnár(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Cuirigcásnár(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Cuirigcásnár(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Cuirigcásnár(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Cuirigcásnár(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Cuirigcásnár(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Cuirigcásnár(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Cuirigcásnár(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Cuirigcásnár(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Cuirigcásnár(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Cuirigcásnár(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Nuaira(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Nuaira(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Nuaira(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Nuaira(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Nuaira(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Nuaira(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Nuaira(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Nuaira(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Nuaira(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Nuaira(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Nuaira(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Nuaira(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Nuaira(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Nuaira(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Nuaira(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Nuaira(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nuaira(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nuaira(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nuaira(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nuaira(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Nuairba(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Nuairba(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Nuairba(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Nuairba(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Nuairba(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Nuairba(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Nuairba(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Nuairba(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Nuairba(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Nuairba(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Nuairba(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Nuairba(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Nuairba(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Nuairba(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Nuairba(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Nuairba(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nuairba(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nuairba(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nuairba(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nuairba(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Nuairnach(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Nuairnach(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Nuairnach(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Nuairnach(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Nuairnach(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Nuairnach(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Nuairnach(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Nuairnach(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Nuairnach(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Nuairnach(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Nuairnach(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Nuairnach(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Nuairnach(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Nuairnach(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Nuairnach(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Nuairnach(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nuairnach(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nuairnach(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nuairnach(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nuairnach(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with no parameters
     */
    default void Nuairnár(String expression, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A0.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with no parameters
     */
    default void Nuairnár(String expression, long timeoutMillis, A0 body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A0.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 1 parameters
     */      
    default <T1> void Nuairnár(String expression, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A1.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 1 parameters
     */
    default <T1> void Nuairnár(String expression, long timeoutMillis, A1<T1> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A1.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 2 parameters
     */      
    default <T1,T2> void Nuairnár(String expression, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A2.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 2 parameters
     */
    default <T1,T2> void Nuairnár(String expression, long timeoutMillis, A2<T1,T2> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A2.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 3 parameters
     */      
    default <T1,T2,T3> void Nuairnár(String expression, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A3.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 3 parameters
     */
    default <T1,T2,T3> void Nuairnár(String expression, long timeoutMillis, A3<T1,T2,T3> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A3.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 4 parameters
     */      
    default <T1,T2,T3,T4> void Nuairnár(String expression, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A4.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 4 parameters
     */
    default <T1,T2,T3,T4> void Nuairnár(String expression, long timeoutMillis, A4<T1,T2,T3,T4> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A4.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 5 parameters
     */      
    default <T1,T2,T3,T4,T5> void Nuairnár(String expression, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A5.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 5 parameters
     */
    default <T1,T2,T3,T4,T5> void Nuairnár(String expression, long timeoutMillis, A5<T1,T2,T3,T4,T5> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A5.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 6 parameters
     */      
    default <T1,T2,T3,T4,T5,T6> void Nuairnár(String expression, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A6.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 6 parameters
     */
    default <T1,T2,T3,T4,T5,T6> void Nuairnár(String expression, long timeoutMillis, A6<T1,T2,T3,T4,T5,T6> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A6.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 7 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7> void Nuairnár(String expression, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A7.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 7 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7> void Nuairnár(String expression, long timeoutMillis, A7<T1,T2,T3,T4,T5,T6,T7> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A7.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 8 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nuairnár(String expression, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A8.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 8 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8> void Nuairnár(String expression, long timeoutMillis, A8<T1,T2,T3,T4,T5,T6,T7,T8> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A8.class, body, typeRegistry)
        );
    }

        
    /**
     * Creates a new step definition.
     *
     * @param expression the cucumber expression
     * @param body       a lambda expression with 9 parameters
     */      
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nuairnár(String expression, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, A9.class, body, typeRegistry)
        );
    }

    /**
     * Creates a new step definition.
     *
     * @param expression    the cucumber expression
     * @param timeoutMillis max amount of milliseconds this is allowed to run for. 0 (default) means no restriction.
     * @param body          a lambda expression with 9 parameters
     */
    default <T1,T2,T3,T4,T5,T6,T7,T8,T9> void Nuairnár(String expression, long timeoutMillis, A9<T1,T2,T3,T4,T5,T6,T7,T8,T9> body) {
        LambdaGlueRegistry.INSTANCE.get().addStepDefinition((typeRegistry) ->
            Java8StepDefinition.create(expression, timeoutMillis, A9.class, body, typeRegistry)
        );
    }

    

}
