/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java8;

import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.TypeResolver;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.jodah.typetools.TypeResolver;

final class LambdaTypeResolver
implements TypeResolver {
    private final Type type;
    private final String expression;
    private final StackTraceElement location;

    LambdaTypeResolver(Type type, String expression, StackTraceElement location) {
        this.type = type;
        this.expression = expression;
        this.location = location;
    }

    public Type resolve() {
        return this.requireNonMapOrListType(this.getType());
    }

    public Type getType() {
        if (TypeResolver.Unknown.class.equals((Object)this.type)) {
            return Object.class;
        }
        return this.type;
    }

    private Type requireNonMapOrListType(Type argumentType) {
        Class argumentClass;
        if (argumentType instanceof Class && (List.class.isAssignableFrom(argumentClass = (Class)argumentType) || Map.class.isAssignableFrom(argumentClass))) {
            throw this.withLocation(new CucumberBackendException(String.format("Can't use %s in lambda step definition \"%s\". Declare a DataTable or DocString argument instead and convert manually with 'asList/asLists/asMap/asMaps' and 'convert' respectively", argumentClass.getName(), this.expression)));
        }
        return argumentType;
    }

    private CucumberBackendException withLocation(CucumberBackendException exception) {
        exception.setStackTrace(new StackTraceElement[]{this.location});
        return exception;
    }
}

