/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.jsonformatter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;

class RelativeUriFormatter
implements Function<URI, URI> {
    private final URI base;

    public RelativeUriFormatter(URI base) {
        this.base = base;
    }

    @Override
    public URI apply(URI uri) {
        if (!"file".equals(uri.getScheme())) {
            return uri;
        }
        try {
            URI relative = this.base.relativize(uri);
            return new URI("file", relative.getSchemeSpecificPart(), relative.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

