/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.resource.Resource;
import io.cucumber.junit.platform.engine.FeatureOrigin;
import java.util.Optional;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

class FeatureParserWithIssueReporting {
    private final FeatureParser delegate;
    private final DiscoveryIssueReporter issueReporter;

    FeatureParserWithIssueReporting(FeatureParser delegate, DiscoveryIssueReporter issueReporter) {
        this.delegate = delegate;
        this.issueReporter = issueReporter;
    }

    Optional<Feature> parseResource(Resource resource) {
        try {
            return this.delegate.parseResource(resource);
        }
        catch (FeatureParserException e) {
            FeatureOrigin featureOrigin = FeatureOrigin.fromUri(resource.getUri());
            this.issueReporter.reportIssue(DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.ERROR, (String)e.getMessage()).cause(e.getCause()).source(featureOrigin.source()));
            return Optional.empty();
        }
    }
}

