/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.testng;

import io.cucumber.testng.CucumberPropertiesProvider;
import io.cucumber.testng.FeatureWrapper;
import io.cucumber.testng.PickleWrapper;
import io.cucumber.testng.TestNGCucumberRunner;
import org.apiguardian.api.API;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.testng.xml.XmlTest;

@API(status=API.Status.STABLE)
public abstract class AbstractTestNGCucumberTests {
    private TestNGCucumberRunner testNGCucumberRunner;

    @BeforeClass(alwaysRun=true)
    public void setUpClass(ITestContext context) {
        XmlTest currentXmlTest = context.getCurrentXmlTest();
        CucumberPropertiesProvider properties = arg_0 -> ((XmlTest)currentXmlTest).getParameter(arg_0);
        this.testNGCucumberRunner = new TestNGCucumberRunner(this.getClass(), properties);
    }

    @Test(groups={"cucumber"}, description="Runs Cucumber Scenarios", dataProvider="scenarios")
    public void runScenario(PickleWrapper pickleWrapper, FeatureWrapper featureWrapper) {
        this.testNGCucumberRunner.runScenario(pickleWrapper.getPickle());
    }

    @DataProvider
    public Object[][] scenarios() {
        if (this.testNGCucumberRunner == null) {
            return new Object[0][0];
        }
        return this.testNGCucumberRunner.provideScenarios();
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() {
        if (this.testNGCucumberRunner == null) {
            return;
        }
        this.testNGCucumberRunner.finish();
    }
}

