/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import java.io.IOException;
import java.util.List;

class TablePrinter {
    private int[][] cellLengths;
    private int[] maxLengths;

    TablePrinter() {
    }

    void printTable(List<List<String>> table, StringBuilder appendable) {
        try {
            this.printTable(table, (Appendable)appendable);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    void printTable(List<List<String>> table, Appendable appendable) throws IOException {
        this.calculateColumnAndMaxLengths(table);
        for (int i = 0; i < table.size(); ++i) {
            this.printRow(table.get(i), i, appendable);
            appendable.append("\n");
        }
    }

    protected void printStartIndent(Appendable buffer, int rowIndex) throws IOException {
        buffer.append("      ");
    }

    private void calculateColumnAndMaxLengths(List<List<String>> rows) {
        int columnCount = 0;
        for (List<String> row : rows) {
            if (columnCount >= row.size()) continue;
            columnCount = row.size();
        }
        this.cellLengths = new int[rows.size()][columnCount];
        this.maxLengths = new int[columnCount];
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            List<String> cells = rows.get(rowIndex);
            for (int colIndex = 0; colIndex < columnCount; ++colIndex) {
                int length;
                String cell = this.getCellSafely(cells, colIndex);
                this.cellLengths[rowIndex][colIndex] = length = this.escapeCell(cell).length();
                this.maxLengths[colIndex] = Math.max(this.maxLengths[colIndex], length);
            }
        }
    }

    private String getCellSafely(List<String> cells, int colIndex) {
        return colIndex < cells.size() ? cells.get(colIndex) : "";
    }

    private void printRow(List<String> cells, int rowIndex, Appendable buffer) throws IOException {
        this.printStartIndent(buffer, rowIndex);
        buffer.append("| ");
        for (int colIndex = 0; colIndex < this.maxLengths.length; ++colIndex) {
            String cellText = this.escapeCell(this.getCellSafely(cells, colIndex));
            buffer.append(cellText);
            int padding = this.maxLengths[colIndex] - this.cellLengths[rowIndex][colIndex];
            this.padSpace(buffer, padding);
            if (colIndex < this.maxLengths.length - 1) {
                buffer.append(" | ");
                continue;
            }
            buffer.append(" |");
        }
    }

    private String escapeCell(String cell) {
        if (cell == null) {
            return "";
        }
        if (cell.isEmpty()) {
            return "[empty]";
        }
        return cell.replaceAll("\\\\(?!\\|)", "\\\\\\\\").replaceAll("\\n", "\\\\n").replaceAll("\\|", "\\\\|");
    }

    private void padSpace(Appendable buffer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            buffer.append(" ");
        }
    }
}

