/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.ConversionRequired;
import io.cucumber.datatable.CucumberDataTableException;
import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.TableCellByTypeTransformer;
import io.cucumber.datatable.TableCellTransformer;
import io.cucumber.datatable.TableEntryByTypeTransformer;
import io.cucumber.datatable.TableEntryTransformer;
import io.cucumber.datatable.TableRowTransformer;
import io.cucumber.datatable.TableTransformer;
import io.cucumber.datatable.TypeFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class DataTableType {
    private static final ConversionRequired CONVERSION_REQUIRED = new ConversionRequired();
    private final RawTableTransformer<?> transformer;
    private final Type elementType;
    private final boolean replaceable;

    private DataTableType(Type type, RawTableTransformer<?> transformer) {
        this(type, transformer, false);
    }

    private DataTableType(Type type, RawTableTransformer<?> transformer, boolean replaceable) {
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        if (transformer == null) {
            throw new NullPointerException("transformer cannot be null");
        }
        this.elementType = type;
        this.transformer = transformer;
        this.replaceable = replaceable;
    }

    public <T> DataTableType(Type type, TableTransformer<T> transformer) {
        this(type, new TableTransformerAdaptor<T>(type, transformer));
    }

    public <T> DataTableType(Type type, TableRowTransformer<T> transformer) {
        this(type, new TableRowTransformerAdaptor<T>(type, transformer));
    }

    public <T> DataTableType(Type type, TableEntryTransformer<T> transformer) {
        this(type, new TableEntryTransformerAdaptor<T>(type, transformer));
    }

    <T> DataTableType(Type type, TableCellTransformer<T> transformer, boolean replaceable) {
        this(type, new TableCellTransformerAdaptor<T>(type, transformer), replaceable);
    }

    public <T> DataTableType(Type type, TableCellTransformer<T> transformer) {
        this(type, new TableCellTransformerAdaptor<T>(type, transformer));
    }

    static DataTableType defaultCell(Type cellType, TableCellByTypeTransformer defaultDataTableTransformer) {
        return new DataTableType(cellType, cell -> defaultDataTableTransformer.transform(cell, cellType));
    }

    static DataTableType defaultEntry(Type entryType, TableEntryByTypeTransformer defaultDataTableTransformer, TableCellByTypeTransformer tableCellByTypeTransformer) {
        return new DataTableType(entryType, entry -> defaultDataTableTransformer.transform(entry, entryType, tableCellByTypeTransformer));
    }

    public Object transform(List<List<String>> raw) {
        try {
            return this.transformer.transform(raw);
        }
        catch (Throwable throwable) {
            throw new CucumberDataTableException(String.format("'%s' could not transform%n%s", this.toCanonical(), DataTable.create(raw)), throwable);
        }
    }

    TypeFactory.JavaType getTargetType() {
        return this.transformer.getTargetType();
    }

    String toCanonical() {
        return this.getTargetType().getTypeName();
    }

    Type getElementType() {
        return this.elementType;
    }

    Class<?> getTransformerType() {
        return this.transformer.getOriginalTransformerType();
    }

    boolean isReplaceable() {
        return this.replaceable;
    }

    DataTableType asOptional() {
        return new DataTableType(this.elementType, this.transformer.asOptional(), this.replaceable);
    }

    public String toString() {
        return new StringJoiner(", ", DataTableType.class.getSimpleName() + "[", "]").add("targetType=" + this.toCanonical()).add("replaceable=" + this.replaceable).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTableType that = (DataTableType)o;
        return this.getTargetType().equals(that.getTargetType());
    }

    public int hashCode() {
        return this.getTargetType().hashCode();
    }

    static interface RawTableTransformer<T> {
        public Class<?> getOriginalTransformerType();

        public T transform(List<List<String>> var1) throws Throwable;

        public RawTableTransformer<?> asOptional();

        public TypeFactory.JavaType getTargetType();
    }

    private static class TableTransformerAdaptor<T>
    implements RawTableTransformer<T> {
        private final TypeFactory.JavaType targetType;
        private final TableTransformer<T> transformer;

        TableTransformerAdaptor(Type targetType, TableTransformer<T> transformer) {
            if (targetType == null) {
                throw new NullPointerException("targetType cannot be null");
            }
            this.targetType = TypeFactory.constructType(targetType);
            if (transformer == null) {
                throw new NullPointerException("transformer cannot be null");
            }
            this.transformer = transformer;
        }

        @Override
        public Class<?> getOriginalTransformerType() {
            return TableTransformer.class;
        }

        @Override
        public T transform(List<List<String>> raw) throws Throwable {
            return this.transformer.transform(DataTable.create(raw, CONVERSION_REQUIRED));
        }

        @Override
        public RawTableTransformer<?> asOptional() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TypeFactory.JavaType getTargetType() {
            return this.targetType;
        }
    }

    private static class TableRowTransformerAdaptor<T>
    implements RawTableTransformer<List<T>> {
        private final TypeFactory.ListType targetType;
        private final TableRowTransformer<T> transformer;

        TableRowTransformerAdaptor(Type targetType, TableRowTransformer<T> transformer) {
            if (targetType == null) {
                throw new NullPointerException("targetType cannot be null");
            }
            this.targetType = TypeFactory.aListOf(targetType);
            if (transformer == null) {
                throw new NullPointerException("transformer cannot be null");
            }
            this.transformer = transformer;
        }

        @Override
        public Class<?> getOriginalTransformerType() {
            return TableRowTransformer.class;
        }

        @Override
        public List<T> transform(List<List<String>> raw) throws Throwable {
            ArrayList<T> list = new ArrayList<T>();
            for (List<String> tableRow : raw) {
                list.add(this.transformer.transform(tableRow));
            }
            return list;
        }

        @Override
        public RawTableTransformer<?> asOptional() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TypeFactory.JavaType getTargetType() {
            return this.targetType;
        }
    }

    private static class TableEntryTransformerAdaptor<T>
    implements RawTableTransformer<List<T>> {
        private final TypeFactory.ListType targetType;
        private final TableEntryTransformer<T> transformer;

        TableEntryTransformerAdaptor(Type targetType, TableEntryTransformer<T> transformer) {
            if (targetType == null) {
                throw new NullPointerException("targetType cannot be null");
            }
            this.targetType = TypeFactory.aListOf(targetType);
            if (transformer == null) {
                throw new NullPointerException("transformer cannot be null");
            }
            this.transformer = transformer;
        }

        @Override
        public Class<?> getOriginalTransformerType() {
            return TableEntryTransformer.class;
        }

        @Override
        public List<T> transform(List<List<String>> raw) throws Throwable {
            DataTable table = DataTable.create(raw, CONVERSION_REQUIRED);
            ArrayList<T> list = new ArrayList<T>();
            for (Map<String, String> entry : table.entries()) {
                list.add(this.transformer.transform(entry));
            }
            return list;
        }

        @Override
        public RawTableTransformer<?> asOptional() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TypeFactory.JavaType getTargetType() {
            return this.targetType;
        }
    }

    private static class TableCellTransformerAdaptor<T>
    implements RawTableTransformer<List<List<T>>> {
        private final TypeFactory.JavaType targetType;
        private final TableCellTransformer<T> transformer;
        private final Type elementType;

        TableCellTransformerAdaptor(Type targetType, TableCellTransformer<T> transformer) {
            if (targetType == null) {
                throw new NullPointerException("targetType cannot be null");
            }
            this.elementType = targetType;
            this.targetType = TypeFactory.aListOf(TypeFactory.aListOf(targetType));
            if (transformer == null) {
                throw new NullPointerException("transformer cannot be null");
            }
            this.transformer = transformer;
        }

        @Override
        public Class<?> getOriginalTransformerType() {
            return TableCellTransformer.class;
        }

        @Override
        public List<List<T>> transform(List<List<String>> raw) throws Throwable {
            ArrayList<List<T>> list = new ArrayList<List<T>>(raw.size());
            for (List<String> tableRow : raw) {
                ArrayList<T> row = new ArrayList<T>(tableRow.size());
                for (String entry : tableRow) {
                    row.add(this.transformer.transform(entry));
                }
                list.add(row);
            }
            return list;
        }

        @Override
        public RawTableTransformer<?> asOptional() {
            return new TableCellTransformerAdaptor<Object>(TypeFactory.optionalOf(this.elementType), new OptionalTableCellTransformer());
        }

        @Override
        public TypeFactory.JavaType getTargetType() {
            return this.targetType;
        }

        private class OptionalTableCellTransformer
        implements TableCellTransformer<Object> {
            private OptionalTableCellTransformer() {
            }

            @Override
            public Object transform(String cell) throws Throwable {
                return cell == null ? Optional.empty() : Optional.ofNullable(TableCellTransformerAdaptor.this.transformer.transform(cell));
            }
        }
    }
}

