/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.GherkinLineSpan;
import io.cucumber.gherkin.Locations;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.StringUtils;
import io.cucumber.messages.types.Location;
import java.util.ArrayList;
import java.util.List;

final class GherkinTagLine {
    GherkinTagLine() {
    }

    static List<GherkinLineSpan> parse(int indent, String text, Location location) {
        int indexEndOfLine;
        int textLength = text.length();
        int indexStartCurrentTag = 0;
        for (indexEndOfLine = 1; !(indexEndOfLine >= textLength || text.charAt(indexEndOfLine) == '#' && StringUtils.isWhitespace(text.charAt(indexEndOfLine - 1))); ++indexEndOfLine) {
        }
        ArrayList<GherkinLineSpan> tags = new ArrayList<GherkinLineSpan>();
        while (indexStartCurrentTag < indexEndOfLine) {
            int indexEndCurrentTag;
            int indexStartNextTag;
            for (indexStartNextTag = indexStartCurrentTag + 1; indexStartNextTag < indexEndOfLine && text.charAt(indexStartNextTag) != '@'; ++indexStartNextTag) {
            }
            for (indexEndCurrentTag = indexStartNextTag - 1; indexEndCurrentTag > indexStartCurrentTag && StringUtils.isWhitespace(text.charAt(indexEndCurrentTag)); --indexEndCurrentTag) {
            }
            if (++indexEndCurrentTag > indexStartCurrentTag + 1) {
                int symbolLength = text.codePointCount(0, indexStartCurrentTag);
                int column = indent + symbolLength + 1;
                if (StringUtils.containsWhitespace(text, indexStartCurrentTag + 1, indexEndCurrentTag)) {
                    throw new ParserException("A tag may not contain whitespace", Locations.atColumn(location, column));
                }
                String token = text.substring(indexStartCurrentTag, indexEndCurrentTag);
                tags.add(new GherkinLineSpan(column, token));
            }
            indexStartCurrentTag = indexStartNextTag;
        }
        return tags;
    }
}

