/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.gherkin.GherkinDialectProvider;
import io.cucumber.gherkin.GherkinLineSpan;
import io.cucumber.gherkin.GherkinTableRowLine;
import io.cucumber.gherkin.GherkinTagLine;
import io.cucumber.gherkin.Locations;
import io.cucumber.gherkin.Parser;
import io.cucumber.gherkin.ParserException;
import io.cucumber.gherkin.Token;
import io.cucumber.messages.types.StepKeywordType;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GherkinTokenMatcher
implements Parser.TokenMatcher {
    private static final Pattern LANGUAGE_PATTERN = Pattern.compile("^#\\s*language\\s*:\\s*([a-zA-Z\\-_]+)\\s*$");
    private final GherkinDialectProvider dialectProvider;
    private GherkinDialect currentDialect;
    private String activeDocStringSeparator = null;
    private int indentToRemove = 0;

    GherkinTokenMatcher(GherkinDialectProvider dialectProvider) {
        this.dialectProvider = dialectProvider;
        this.reset();
    }

    GherkinTokenMatcher() {
        this(new GherkinDialectProvider());
    }

    GherkinTokenMatcher(String defaultDialectName) {
        this(new GherkinDialectProvider(defaultDialectName));
    }

    @Override
    public void reset() {
        this.activeDocStringSeparator = null;
        this.indentToRemove = 0;
        this.currentDialect = this.dialectProvider.getDefaultDialect();
    }

    private void setTokenMatched(Token token, Parser.TokenType matchedType, String text, String keyword, int indent, StepKeywordType keywordType, List<GherkinLineSpan> items) {
        token.matchedType = matchedType;
        token.matchedKeyword = keyword;
        token.keywordType = keywordType;
        token.matchedText = text;
        token.matchedItems = items;
        token.matchedGherkinDialect = this.currentDialect;
        token.matchedIndent = indent;
        token.location = Locations.atColumn(token.location, token.matchedIndent + 1);
    }

    @Override
    public boolean match_EOF(Token token) {
        if (token.isEOF()) {
            this.setTokenMatched(token, Parser.TokenType.EOF, null, null, 0, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_Other(Token token) {
        String text = this.removeDocStringIndent(token);
        this.setTokenMatched(token, Parser.TokenType.Other, this.unescapeDocString(text), null, 0, null, null);
        return true;
    }

    @Override
    public boolean match_Empty(Token token) {
        if (token.line.isEmpty()) {
            this.setTokenMatched(token, Parser.TokenType.Empty, null, null, 0, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_Comment(Token token) {
        if (token.line.startsWith('#')) {
            String text = token.line.getRawText();
            this.setTokenMatched(token, Parser.TokenType.Comment, text, null, 0, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_Language(Token token) {
        Matcher matcher = LANGUAGE_PATTERN.matcher(token.line.getText());
        if (matcher.matches()) {
            String language = matcher.group(1);
            this.setTokenMatched(token, Parser.TokenType.Language, language, null, token.line.getIndent(), null, null);
            this.currentDialect = this.dialectProvider.getDialect(language).orElseThrow(() -> new ParserException.NoSuchLanguageException(language, token.location));
            return true;
        }
        return false;
    }

    @Override
    public boolean match_TagLine(Token token) {
        if (token.line.startsWith('@')) {
            List<GherkinLineSpan> tags = GherkinTagLine.parse(token.line.getIndent(), token.line.getText(), token.location);
            this.setTokenMatched(token, Parser.TokenType.TagLine, null, null, token.line.getIndent(), null, tags);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_FeatureLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.FeatureLine, this.currentDialect.getFeatureKeywords());
    }

    @Override
    public boolean match_RuleLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.RuleLine, this.currentDialect.getRuleKeywords());
    }

    @Override
    public boolean match_BackgroundLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.BackgroundLine, this.currentDialect.getBackgroundKeywords());
    }

    @Override
    public boolean match_ScenarioLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.ScenarioLine, this.currentDialect.getScenarioKeywords()) || this.matchTitleLine(token, Parser.TokenType.ScenarioLine, this.currentDialect.getScenarioOutlineKeywords());
    }

    @Override
    public boolean match_ExamplesLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.ExamplesLine, this.currentDialect.getExamplesKeywords());
    }

    private boolean matchTitleLine(Token token, Parser.TokenType tokenType, List<String> keywords) {
        int keywordsSize = keywords.size();
        for (int i = 0; i < keywordsSize; ++i) {
            String keyword = keywords.get(i);
            if (!token.line.startsWithTitleKeyword(keyword)) continue;
            String title = token.line.substringTrimmed(keyword.length() + 1);
            this.setTokenMatched(token, tokenType, title, keyword, token.line.getIndent(), null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_DocStringSeparator(Token token) {
        return this.activeDocStringSeparator == null ? this.match_DocStringSeparator(token, "\"\"\"", true) || this.match_DocStringSeparator(token, "```", true) : this.match_DocStringSeparator(token, this.activeDocStringSeparator, false);
    }

    private boolean match_DocStringSeparator(Token token, String separator, boolean isOpen) {
        if (token.line.startsWith(separator)) {
            String mediaType = null;
            if (isOpen) {
                mediaType = token.line.substringTrimmed(separator.length());
                this.activeDocStringSeparator = separator;
                this.indentToRemove = token.line.getIndent();
            } else {
                this.activeDocStringSeparator = null;
                this.indentToRemove = 0;
            }
            this.setTokenMatched(token, Parser.TokenType.DocStringSeparator, mediaType, separator, token.line.getIndent(), null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_StepLine(Token token) {
        List<String> keywords = this.currentDialect.getStepKeywords();
        for (String keyword : keywords) {
            if (!token.line.startsWith(keyword)) continue;
            String stepText = token.line.substringTrimmed(keyword.length());
            StepKeywordType keywordType = this.currentDialect.getStepKeywordType(keyword);
            this.setTokenMatched(token, Parser.TokenType.StepLine, stepText, keyword, token.line.getIndent(), keywordType, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_TableRow(Token token) {
        if (token.line.startsWith('|')) {
            List<GherkinLineSpan> tableCells = GherkinTableRowLine.parse(token.line.getIndent(), token.line.getText());
            this.setTokenMatched(token, Parser.TokenType.TableRow, null, null, token.line.getIndent(), null, tableCells);
            return true;
        }
        return false;
    }

    private String removeDocStringIndent(Token token) {
        if (this.activeDocStringSeparator == null) {
            return token.line.getRawText();
        }
        if (this.indentToRemove > token.line.getIndent()) {
            return token.line.getText();
        }
        return token.line.getRawTextSubstring(this.indentToRemove);
    }

    private String unescapeDocString(String text) {
        if ("\"\"\"".equals(this.activeDocStringSeparator)) {
            return text.replace("\\\"\\\"\\\"", "\"\"\"");
        }
        if ("```".equals(this.activeDocStringSeparator)) {
            return text.replace("\\`\\`\\`", "```");
        }
        return text;
    }
}

