/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.gherkin.GherkinLine;
import io.cucumber.gherkin.GherkinLineSpan;
import io.cucumber.gherkin.Parser;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.StepKeywordType;
import java.util.List;
import java.util.Objects;

class Token {
    final GherkinLine line;
    final boolean eof;
    Parser.TokenType matchedType;
    String matchedKeyword;
    String matchedText;
    List<GherkinLineSpan> matchedItems;
    int matchedIndent;
    GherkinDialect matchedGherkinDialect;
    StepKeywordType keywordType;
    Location location;

    private Token(GherkinLine line, Location location) {
        this.line = line;
        this.location = location;
        this.eof = line == null;
    }

    static Token createEOF(Location location) {
        Objects.requireNonNull(location);
        return new Token(null, location);
    }

    static Token createGherkinLine(String text, Location location) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(location);
        return new Token(new GherkinLine(text), location);
    }

    boolean isEOF() {
        return this.eof;
    }

    String getTokenValue() {
        return this.isEOF() ? "EOF" : this.line.getText();
    }

    public String toString() {
        return String.format("%s: %s/%s", new Object[]{this.matchedType, this.matchedKeyword, this.matchedText});
    }
}

