/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.GherkinDialect;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class GherkinDialects {
    private static final Map<String, GherkinDialect> DIALECTS;

    private GherkinDialects() {
    }

    public static Set<String> getLanguages() {
        return DIALECTS.keySet();
    }

    public static Collection<GherkinDialect> getDialects() {
        return DIALECTS.values();
    }

    public static Optional<GherkinDialect> getDialect(String language) {
        Objects.requireNonNull(language);
        return Optional.ofNullable(DIALECTS.get(language));
    }

    static {
        LinkedHashMap<String, GherkinDialect> dialects = new LinkedHashMap<String, GherkinDialect>();
        dialects.put("af", new GherkinDialect("af", "Afrikaans", "Afrikaans", Collections.unmodifiableList(Arrays.asList("Funksie", "Besigheid Behoefte", "Vermo\u00eb")), Collections.unmodifiableList(Arrays.asList("Re\u00ebl", "Reel")), Collections.unmodifiableList(Arrays.asList("Voorbeeld", "Situasie")), Collections.unmodifiableList(Arrays.asList("Situasie Uiteensetting")), Collections.unmodifiableList(Arrays.asList("Agtergrond")), Collections.unmodifiableList(Arrays.asList("Voorbeelde")), Collections.unmodifiableList(Arrays.asList("* ", "Gegewe ")), Collections.unmodifiableList(Arrays.asList("* ", "Wanneer ")), Collections.unmodifiableList(Arrays.asList("* ", "Dan ")), Collections.unmodifiableList(Arrays.asList("* ", "En ")), Collections.unmodifiableList(Arrays.asList("* ", "Maar "))));
        dialects.put("am", new GherkinDialect("am", "Armenian", "\u0570\u0561\u0575\u0565\u0580\u0565\u0576", Collections.unmodifiableList(Arrays.asList("\u0556\u0578\u0582\u0576\u056f\u0581\u056b\u0578\u0576\u0561\u056c\u0578\u0582\u0569\u0575\u0578\u0582\u0576", "\u0540\u0561\u057f\u056f\u0578\u0582\u0569\u0575\u0578\u0582\u0576")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u0555\u0580\u056b\u0576\u0561\u056f", "\u054d\u0581\u0565\u0576\u0561\u0580")), Collections.unmodifiableList(Arrays.asList("\u054d\u0581\u0565\u0576\u0561\u0580\u056b \u056f\u0561\u057c\u0578\u0582\u0581\u057e\u0561\u0581\u0584\u0568")), Collections.unmodifiableList(Arrays.asList("\u053f\u0578\u0576\u057f\u0565\u0584\u057d\u057f")), Collections.unmodifiableList(Arrays.asList("\u0555\u0580\u056b\u0576\u0561\u056f\u0576\u0565\u0580")), Collections.unmodifiableList(Arrays.asList("* ", "\u0534\u056b\u0581\u0578\u0582\u0584 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0535\u0569\u0565 ", "\u0535\u0580\u0562 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0531\u057a\u0561 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0535\u057e ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0532\u0561\u0575\u0581 "))));
        dialects.put("amh", new GherkinDialect("amh", "Amharic", "\u12a0\u121b\u122d\u129b", Collections.unmodifiableList(Arrays.asList("\u1235\u122b", "\u12e8\u1270\u1348\u1208\u1308\u12cd \u1235\u122b", "\u12e8\u121a\u1348\u1208\u1308\u12cd \u12f5\u122d\u130a\u1275")), Collections.unmodifiableList(Arrays.asList("\u1205\u130d")), Collections.unmodifiableList(Arrays.asList("\u121d\u1233\u120c", "\u1201\u1293\u1274")), Collections.unmodifiableList(Arrays.asList("\u1201\u1293\u1274 \u12dd\u122d\u12dd\u122d", "\u1201\u1293\u1274 \u12a0\u1265\u1290\u1275")), Collections.unmodifiableList(Arrays.asList("\u1245\u12f5\u1218 \u1201\u1294\u1273", "\u1218\u1290\u123b", "\u1218\u1290\u123b \u1200\u1233\u1265")), Collections.unmodifiableList(Arrays.asList("\u121d\u1233\u120c\u12ce\u127d", "\u1201\u1293\u1274\u12ce\u127d")), Collections.unmodifiableList(Arrays.asList("* ", "\u12e8\u1270\u1230\u1320 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u1218\u127c ")), Collections.unmodifiableList(Arrays.asList("* ", "\u12a8\u12da\u12eb ")), Collections.unmodifiableList(Arrays.asList("* ", "\u12a5\u1293 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u130d\u1295 "))));
        dialects.put("an", new GherkinDialect("an", "Aragonese", "Aragon\u00e9s", Collections.unmodifiableList(Arrays.asList("Caracteristica")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Eixemplo", "Caso")), Collections.unmodifiableList(Arrays.asList("Esquema del caso")), Collections.unmodifiableList(Arrays.asList("Antecedents")), Collections.unmodifiableList(Arrays.asList("Eixemplos")), Collections.unmodifiableList(Arrays.asList("* ", "Dau ", "Dada ", "Daus ", "Dadas ")), Collections.unmodifiableList(Arrays.asList("* ", "Cuan ")), Collections.unmodifiableList(Arrays.asList("* ", "Alavez ", "Allora ", "Antonces ")), Collections.unmodifiableList(Arrays.asList("* ", "Y ", "E ")), Collections.unmodifiableList(Arrays.asList("* ", "Pero "))));
        dialects.put("ar", new GherkinDialect("ar", "Arabic", "\u0627\u0644\u0639\u0631\u0628\u064a\u0629", Collections.unmodifiableList(Arrays.asList("\u062e\u0627\u0635\u064a\u0629")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u0645\u062b\u0627\u0644", "\u0633\u064a\u0646\u0627\u0631\u064a\u0648")), Collections.unmodifiableList(Arrays.asList("\u0633\u064a\u0646\u0627\u0631\u064a\u0648 \u0645\u062e\u0637\u0637")), Collections.unmodifiableList(Arrays.asList("\u0627\u0644\u062e\u0644\u0641\u064a\u0629")), Collections.unmodifiableList(Arrays.asList("\u0627\u0645\u062b\u0644\u0629")), Collections.unmodifiableList(Arrays.asList("* ", "\u0628\u0641\u0631\u0636 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0645\u062a\u0649 ", "\u0639\u0646\u062f\u0645\u0627 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0627\u0630\u0627\u064b ", "\u062b\u0645 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0648 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0644\u0643\u0646 "))));
        dialects.put("ast", new GherkinDialect("ast", "Asturian", "asturianu", Collections.unmodifiableList(Arrays.asList("Carauter\u00edstica")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Exemplo", "Casu")), Collections.unmodifiableList(Arrays.asList("Esbozu del casu")), Collections.unmodifiableList(Arrays.asList("Antecedentes")), Collections.unmodifiableList(Arrays.asList("Exemplos")), Collections.unmodifiableList(Arrays.asList("* ", "D\u00e1u ", "Dada ", "Daos ", "Daes ")), Collections.unmodifiableList(Arrays.asList("* ", "Cuando ")), Collections.unmodifiableList(Arrays.asList("* ", "Ent\u00f3s ")), Collections.unmodifiableList(Arrays.asList("* ", "Y ", "Ya ")), Collections.unmodifiableList(Arrays.asList("* ", "Peru "))));
        dialects.put("az", new GherkinDialect("az", "Azerbaijani", "Az\u0259rbaycanca", Collections.unmodifiableList(Arrays.asList("\u00d6z\u0259llik")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("N\u00fcmun\u0259", "Ssenari")), Collections.unmodifiableList(Arrays.asList("Ssenarinin strukturu")), Collections.unmodifiableList(Arrays.asList("Ke\u00e7mi\u015f", "Kontekst")), Collections.unmodifiableList(Arrays.asList("N\u00fcmun\u0259l\u0259r")), Collections.unmodifiableList(Arrays.asList("* ", "Tutaq ki ", "Verilir ")), Collections.unmodifiableList(Arrays.asList("* ", "\u018fg\u0259r ", "N\u0259 vaxt ki ")), Collections.unmodifiableList(Arrays.asList("* ", "O halda ")), Collections.unmodifiableList(Arrays.asList("* ", "V\u0259 ", "H\u0259m ")), Collections.unmodifiableList(Arrays.asList("* ", "Amma ", "Ancaq "))));
        dialects.put("be", new GherkinDialect("be", "Belarusian", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f", Collections.unmodifiableList(Arrays.asList("\u0424\u0443\u043d\u043a\u0446\u044b\u044f\u043d\u0430\u043b\u044c\u043d\u0430\u0441\u0446\u044c", "\u0424\u0456\u0447\u0430")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0430\u0432\u0456\u043b\u044b")), Collections.unmodifiableList(Arrays.asList("\u0421\u0446\u044d\u043d\u0430\u0440\u044b\u0439", "C\u0446\u044d\u043d\u0430\u0440")), Collections.unmodifiableList(Arrays.asList("\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u0446\u044d\u043d\u0430\u0440\u044b\u044f", "\u0423\u0437\u043e\u0440 \u0441\u0446\u044d\u043d\u0430\u0440\u0430")), Collections.unmodifiableList(Arrays.asList("\u041a\u0430\u043d\u0442\u044d\u043a\u0441\u0442")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u044b\u043a\u043b\u0430\u0434\u044b")), Collections.unmodifiableList(Arrays.asList("* ", "\u041d\u044f\u0445\u0430\u0439 ", "\u0414\u0430\u0434\u0437\u0435\u043d\u0430 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041a\u0430\u043b\u0456 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0422\u0430\u0434\u044b ")), Collections.unmodifiableList(Arrays.asList("* ", "I ", "\u0414\u044b ", "\u0422\u0430\u043a\u0441\u0430\u043c\u0430 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0410\u043b\u0435 ", "\u0406\u043d\u0430\u043a\u0448 "))));
        dialects.put("bg", new GherkinDialect("bg", "Bulgarian", "\u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438", Collections.unmodifiableList(Arrays.asList("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e\u0441\u0442")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0430\u0432\u0438\u043b\u043e")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0438\u043c\u0435\u0440", "\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439")), Collections.unmodifiableList(Arrays.asList("\u0420\u0430\u043c\u043a\u0430 \u043d\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0439")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0435\u0434\u0438\u0441\u0442\u043e\u0440\u0438\u044f")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0438\u043c\u0435\u0440\u0438")), Collections.unmodifiableList(Arrays.asList("* ", "\u0414\u0430\u0434\u0435\u043d\u043e ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041a\u043e\u0433\u0430\u0442\u043e ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0422\u043e ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0418 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041d\u043e "))));
        dialects.put("bm", new GherkinDialect("bm", "Malay", "Bahasa Melayu", Collections.unmodifiableList(Arrays.asList("Fungsi")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Senario", "Situasi", "Keadaan")), Collections.unmodifiableList(Arrays.asList("Kerangka Senario", "Kerangka Situasi", "Kerangka Keadaan", "Garis Panduan Senario")), Collections.unmodifiableList(Arrays.asList("Latar Belakang")), Collections.unmodifiableList(Arrays.asList("Contoh")), Collections.unmodifiableList(Arrays.asList("* ", "Diberi ", "Bagi ")), Collections.unmodifiableList(Arrays.asList("* ", "Apabila ")), Collections.unmodifiableList(Arrays.asList("* ", "Maka ", "Kemudian ")), Collections.unmodifiableList(Arrays.asList("* ", "Dan ")), Collections.unmodifiableList(Arrays.asList("* ", "Tetapi ", "Tapi "))));
        dialects.put("bs", new GherkinDialect("bs", "Bosnian", "Bosanski", Collections.unmodifiableList(Arrays.asList("Karakteristika")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Primjer", "Scenariju", "Scenario")), Collections.unmodifiableList(Arrays.asList("Scenariju-obris", "Scenario-outline")), Collections.unmodifiableList(Arrays.asList("Pozadina")), Collections.unmodifiableList(Arrays.asList("Primjeri")), Collections.unmodifiableList(Arrays.asList("* ", "Dato ")), Collections.unmodifiableList(Arrays.asList("* ", "Kada ")), Collections.unmodifiableList(Arrays.asList("* ", "Zatim ")), Collections.unmodifiableList(Arrays.asList("* ", "I ", "A ")), Collections.unmodifiableList(Arrays.asList("* ", "Ali "))));
        dialects.put("ca", new GherkinDialect("ca", "Catalan", "catal\u00e0", Collections.unmodifiableList(Arrays.asList("Caracter\u00edstica", "Funcionalitat")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Exemple", "Escenari")), Collections.unmodifiableList(Arrays.asList("Esquema de l'escenari")), Collections.unmodifiableList(Arrays.asList("Rerefons", "Antecedents")), Collections.unmodifiableList(Arrays.asList("Exemples")), Collections.unmodifiableList(Arrays.asList("* ", "Donat ", "Donada ", "At\u00e8s ", "Atesa ")), Collections.unmodifiableList(Arrays.asList("* ", "Quan ")), Collections.unmodifiableList(Arrays.asList("* ", "Aleshores ", "Cal ")), Collections.unmodifiableList(Arrays.asList("* ", "I ")), Collections.unmodifiableList(Arrays.asList("* ", "Per\u00f2 "))));
        dialects.put("cs", new GherkinDialect("cs", "Czech", "\u010cesky", Collections.unmodifiableList(Arrays.asList("Po\u017eadavek")), Collections.unmodifiableList(Arrays.asList("Pravidlo")), Collections.unmodifiableList(Arrays.asList("P\u0159\u00edklad", "Sc\u00e9n\u00e1\u0159")), Collections.unmodifiableList(Arrays.asList("N\u00e1\u010drt Sc\u00e9n\u00e1\u0159e", "Osnova sc\u00e9n\u00e1\u0159e")), Collections.unmodifiableList(Arrays.asList("Pozad\u00ed", "Kontext")), Collections.unmodifiableList(Arrays.asList("P\u0159\u00edklady")), Collections.unmodifiableList(Arrays.asList("* ", "Pokud ", "Za p\u0159edpokladu ")), Collections.unmodifiableList(Arrays.asList("* ", "Kdy\u017e ")), Collections.unmodifiableList(Arrays.asList("* ", "Pak ")), Collections.unmodifiableList(Arrays.asList("* ", "A tak\u00e9 ", "A ")), Collections.unmodifiableList(Arrays.asList("* ", "Ale "))));
        dialects.put("cy-GB", new GherkinDialect("cy-GB", "Welsh", "Cymraeg", Collections.unmodifiableList(Arrays.asList("Arwedd")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Enghraifft", "Scenario")), Collections.unmodifiableList(Arrays.asList("Scenario Amlinellol")), Collections.unmodifiableList(Arrays.asList("Cefndir")), Collections.unmodifiableList(Arrays.asList("Enghreifftiau")), Collections.unmodifiableList(Arrays.asList("* ", "Anrhegedig a ")), Collections.unmodifiableList(Arrays.asList("* ", "Pryd ")), Collections.unmodifiableList(Arrays.asList("* ", "Yna ")), Collections.unmodifiableList(Arrays.asList("* ", "A ")), Collections.unmodifiableList(Arrays.asList("* ", "Ond "))));
        dialects.put("da", new GherkinDialect("da", "Danish", "dansk", Collections.unmodifiableList(Arrays.asList("Egenskab")), Collections.unmodifiableList(Arrays.asList("Regel")), Collections.unmodifiableList(Arrays.asList("Eksempel", "Scenarie")), Collections.unmodifiableList(Arrays.asList("Abstrakt Scenario")), Collections.unmodifiableList(Arrays.asList("Baggrund")), Collections.unmodifiableList(Arrays.asList("Eksempler")), Collections.unmodifiableList(Arrays.asList("* ", "Givet ")), Collections.unmodifiableList(Arrays.asList("* ", "N\u00e5r ")), Collections.unmodifiableList(Arrays.asList("* ", "S\u00e5 ")), Collections.unmodifiableList(Arrays.asList("* ", "Og ")), Collections.unmodifiableList(Arrays.asList("* ", "Men "))));
        dialects.put("de", new GherkinDialect("de", "German", "Deutsch", Collections.unmodifiableList(Arrays.asList("Funktionalit\u00e4t", "Funktion")), Collections.unmodifiableList(Arrays.asList("Rule", "Regel")), Collections.unmodifiableList(Arrays.asList("Beispiel", "Szenario")), Collections.unmodifiableList(Arrays.asList("Szenariogrundriss", "Szenarien")), Collections.unmodifiableList(Arrays.asList("Grundlage", "Hintergrund", "Voraussetzungen", "Vorbedingungen")), Collections.unmodifiableList(Arrays.asList("Beispiele")), Collections.unmodifiableList(Arrays.asList("* ", "Angenommen ", "Gegeben sei ", "Gegeben seien ")), Collections.unmodifiableList(Arrays.asList("* ", "Wenn ")), Collections.unmodifiableList(Arrays.asList("* ", "Dann ")), Collections.unmodifiableList(Arrays.asList("* ", "Und ")), Collections.unmodifiableList(Arrays.asList("* ", "Aber "))));
        dialects.put("el", new GherkinDialect("el", "Greek", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", Collections.unmodifiableList(Arrays.asList("\u0394\u03c5\u03bd\u03b1\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1", "\u039b\u03b5\u03b9\u03c4\u03bf\u03c5\u03c1\u03b3\u03af\u03b1")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u03a0\u03b1\u03c1\u03ac\u03b4\u03b5\u03b9\u03b3\u03bc\u03b1", "\u03a3\u03b5\u03bd\u03ac\u03c1\u03b9\u03bf")), Collections.unmodifiableList(Arrays.asList("\u03a0\u03b5\u03c1\u03b9\u03b3\u03c1\u03b1\u03c6\u03ae \u03a3\u03b5\u03bd\u03b1\u03c1\u03af\u03bf\u03c5", "\u03a0\u03b5\u03c1\u03af\u03b3\u03c1\u03b1\u03bc\u03bc\u03b1 \u03a3\u03b5\u03bd\u03b1\u03c1\u03af\u03bf\u03c5")), Collections.unmodifiableList(Arrays.asList("\u03a5\u03c0\u03cc\u03b2\u03b1\u03b8\u03c1\u03bf")), Collections.unmodifiableList(Arrays.asList("\u03a0\u03b1\u03c1\u03b1\u03b4\u03b5\u03af\u03b3\u03bc\u03b1\u03c4\u03b1", "\u03a3\u03b5\u03bd\u03ac\u03c1\u03b9\u03b1")), Collections.unmodifiableList(Arrays.asList("* ", "\u0394\u03b5\u03b4\u03bf\u03bc\u03ad\u03bd\u03bf\u03c5 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u038c\u03c4\u03b1\u03bd ")), Collections.unmodifiableList(Arrays.asList("* ", "\u03a4\u03cc\u03c4\u03b5 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u039a\u03b1\u03b9 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0391\u03bb\u03bb\u03ac "))));
        dialects.put("em", new GherkinDialect("em", "Emoji", "\ud83d\ude00", Collections.unmodifiableList(Arrays.asList("\ud83d\udcda")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\ud83e\udd52", "\ud83d\udcd5")), Collections.unmodifiableList(Arrays.asList("\ud83d\udcd6")), Collections.unmodifiableList(Arrays.asList("\ud83d\udca4")), Collections.unmodifiableList(Arrays.asList("\ud83d\udcd3")), Collections.unmodifiableList(Arrays.asList("* ", "\ud83d\ude10")), Collections.unmodifiableList(Arrays.asList("* ", "\ud83c\udfac")), Collections.unmodifiableList(Arrays.asList("* ", "\ud83d\ude4f")), Collections.unmodifiableList(Arrays.asList("* ", "\ud83d\ude02")), Collections.unmodifiableList(Arrays.asList("* ", "\ud83d\ude14"))));
        dialects.put("en", new GherkinDialect("en", "English", "English", Collections.unmodifiableList(Arrays.asList("Feature", "Business Need", "Ability")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Example", "Scenario")), Collections.unmodifiableList(Arrays.asList("Scenario Outline", "Scenario Template")), Collections.unmodifiableList(Arrays.asList("Background")), Collections.unmodifiableList(Arrays.asList("Examples", "Scenarios")), Collections.unmodifiableList(Arrays.asList("* ", "Given ")), Collections.unmodifiableList(Arrays.asList("* ", "When ")), Collections.unmodifiableList(Arrays.asList("* ", "Then ")), Collections.unmodifiableList(Arrays.asList("* ", "And ")), Collections.unmodifiableList(Arrays.asList("* ", "But "))));
        dialects.put("en-Scouse", new GherkinDialect("en-Scouse", "Scouse", "Scouse", Collections.unmodifiableList(Arrays.asList("Feature")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("The thing of it is")), Collections.unmodifiableList(Arrays.asList("Wharrimean is")), Collections.unmodifiableList(Arrays.asList("Dis is what went down")), Collections.unmodifiableList(Arrays.asList("Examples")), Collections.unmodifiableList(Arrays.asList("* ", "Givun ", "Youse know when youse got ")), Collections.unmodifiableList(Arrays.asList("* ", "Wun ", "Youse know like when ")), Collections.unmodifiableList(Arrays.asList("* ", "Dun ", "Den youse gotta ")), Collections.unmodifiableList(Arrays.asList("* ", "An ")), Collections.unmodifiableList(Arrays.asList("* ", "Buh "))));
        dialects.put("en-au", new GherkinDialect("en-au", "Australian", "Australian", Collections.unmodifiableList(Arrays.asList("Pretty much")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Awww, look mate")), Collections.unmodifiableList(Arrays.asList("Reckon it's like")), Collections.unmodifiableList(Arrays.asList("First off")), Collections.unmodifiableList(Arrays.asList("You'll wanna")), Collections.unmodifiableList(Arrays.asList("* ", "Y'know ")), Collections.unmodifiableList(Arrays.asList("* ", "It's just unbelievable ")), Collections.unmodifiableList(Arrays.asList("* ", "But at the end of the day I reckon ")), Collections.unmodifiableList(Arrays.asList("* ", "Too right ")), Collections.unmodifiableList(Arrays.asList("* ", "Yeah nah "))));
        dialects.put("en-lol", new GherkinDialect("en-lol", "LOLCAT", "LOLCAT", Collections.unmodifiableList(Arrays.asList("OH HAI")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("MISHUN")), Collections.unmodifiableList(Arrays.asList("MISHUN SRSLY")), Collections.unmodifiableList(Arrays.asList("B4")), Collections.unmodifiableList(Arrays.asList("EXAMPLZ")), Collections.unmodifiableList(Arrays.asList("* ", "I CAN HAZ ")), Collections.unmodifiableList(Arrays.asList("* ", "WEN ")), Collections.unmodifiableList(Arrays.asList("* ", "DEN ")), Collections.unmodifiableList(Arrays.asList("* ", "AN ")), Collections.unmodifiableList(Arrays.asList("* ", "BUT "))));
        dialects.put("en-old", new GherkinDialect("en-old", "Old English", "Englisc", Collections.unmodifiableList(Arrays.asList("Hwaet", "Hw\u00e6t")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Swa")), Collections.unmodifiableList(Arrays.asList("Swa hwaer swa", "Swa hw\u00e6r swa")), Collections.unmodifiableList(Arrays.asList("Aer", "\u00c6r")), Collections.unmodifiableList(Arrays.asList("Se the", "Se \u00fee", "Se \u00f0e")), Collections.unmodifiableList(Arrays.asList("* ", "Thurh ", "\u00deurh ", "\u00d0urh ")), Collections.unmodifiableList(Arrays.asList("* ", "B\u00e6\u00fesealf ", "B\u00e6\u00fesealfa ", "B\u00e6\u00fesealfe ", "Ciric\u00e6w ", "Ciric\u00e6we ", "Ciric\u00e6wa ")), Collections.unmodifiableList(Arrays.asList("* ", "Tha ", "\u00dea ", "\u00d0a ", "Tha the ", "\u00dea \u00fee ", "\u00d0a \u00f0e ")), Collections.unmodifiableList(Arrays.asList("* ", "Ond ", "7 ")), Collections.unmodifiableList(Arrays.asList("* ", "Ac "))));
        dialects.put("en-pirate", new GherkinDialect("en-pirate", "Pirate", "Pirate", Collections.unmodifiableList(Arrays.asList("Ahoy matey!")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Heave to")), Collections.unmodifiableList(Arrays.asList("Shiver me timbers")), Collections.unmodifiableList(Arrays.asList("Yo-ho-ho")), Collections.unmodifiableList(Arrays.asList("Dead men tell no tales")), Collections.unmodifiableList(Arrays.asList("* ", "Gangway! ")), Collections.unmodifiableList(Arrays.asList("* ", "Blimey! ")), Collections.unmodifiableList(Arrays.asList("* ", "Let go and haul ")), Collections.unmodifiableList(Arrays.asList("* ", "Aye ")), Collections.unmodifiableList(Arrays.asList("* ", "Avast! "))));
        dialects.put("en-tx", new GherkinDialect("en-tx", "Texas", "Texas", Collections.unmodifiableList(Arrays.asList("This ain\u2019t my first rodeo", "All gussied up")), Collections.unmodifiableList(Arrays.asList("Rule ")), Collections.unmodifiableList(Arrays.asList("All hat and no cattle")), Collections.unmodifiableList(Arrays.asList("Serious as a snake bite", "Busy as a hound in flea season")), Collections.unmodifiableList(Arrays.asList("Lemme tell y'all a story")), Collections.unmodifiableList(Arrays.asList("Now that's a story longer than a cattle drive in July")), Collections.unmodifiableList(Arrays.asList("Fixin' to ", "All git out ")), Collections.unmodifiableList(Arrays.asList("Quick out of the chute ")), Collections.unmodifiableList(Arrays.asList("There\u2019s no tree but bears some fruit ")), Collections.unmodifiableList(Arrays.asList("Come hell or high water ")), Collections.unmodifiableList(Arrays.asList("Well now hold on, I'll you what "))));
        dialects.put("eo", new GherkinDialect("eo", "Esperanto", "Esperanto", Collections.unmodifiableList(Arrays.asList("Trajto")), Collections.unmodifiableList(Arrays.asList("Regulo")), Collections.unmodifiableList(Arrays.asList("Ekzemplo", "Scenaro", "Kazo")), Collections.unmodifiableList(Arrays.asList("Konturo de la scenaro", "Skizo", "Kazo-skizo")), Collections.unmodifiableList(Arrays.asList("Fono")), Collections.unmodifiableList(Arrays.asList("Ekzemploj")), Collections.unmodifiableList(Arrays.asList("* ", "Donita\u0135o ", "Komence ")), Collections.unmodifiableList(Arrays.asList("* ", "Se ")), Collections.unmodifiableList(Arrays.asList("* ", "Do ")), Collections.unmodifiableList(Arrays.asList("* ", "Kaj ")), Collections.unmodifiableList(Arrays.asList("* ", "Sed "))));
        dialects.put("es", new GherkinDialect("es", "Spanish", "espa\u00f1ol", Collections.unmodifiableList(Arrays.asList("Caracter\u00edstica", "Necesidad del negocio", "Requisito")), Collections.unmodifiableList(Arrays.asList("Regla", "Regla de negocio")), Collections.unmodifiableList(Arrays.asList("Ejemplo", "Escenario")), Collections.unmodifiableList(Arrays.asList("Esquema del escenario")), Collections.unmodifiableList(Arrays.asList("Antecedentes")), Collections.unmodifiableList(Arrays.asList("Ejemplos")), Collections.unmodifiableList(Arrays.asList("* ", "Dado ", "Dada ", "Dados ", "Dadas ")), Collections.unmodifiableList(Arrays.asList("* ", "Cuando ")), Collections.unmodifiableList(Arrays.asList("* ", "Entonces ")), Collections.unmodifiableList(Arrays.asList("* ", "Y ", "E ")), Collections.unmodifiableList(Arrays.asList("* ", "Pero "))));
        dialects.put("et", new GherkinDialect("et", "Estonian", "eesti keel", Collections.unmodifiableList(Arrays.asList("Omadus")), Collections.unmodifiableList(Arrays.asList("Reegel")), Collections.unmodifiableList(Arrays.asList("Juhtum", "Stsenaarium")), Collections.unmodifiableList(Arrays.asList("Raamjuhtum", "Raamstsenaarium")), Collections.unmodifiableList(Arrays.asList("Taust")), Collections.unmodifiableList(Arrays.asList("Juhtumid")), Collections.unmodifiableList(Arrays.asList("* ", "Eeldades ")), Collections.unmodifiableList(Arrays.asList("* ", "Kui ")), Collections.unmodifiableList(Arrays.asList("* ", "Siis ")), Collections.unmodifiableList(Arrays.asList("* ", "Ja ")), Collections.unmodifiableList(Arrays.asList("* ", "Kuid "))));
        dialects.put("fa", new GherkinDialect("fa", "Persian", "\u0641\u0627\u0631\u0633\u06cc", Collections.unmodifiableList(Arrays.asList("\u0648\u0650\u06cc\u0698\u06af\u06cc")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u0645\u062b\u0627\u0644", "\u0633\u0646\u0627\u0631\u06cc\u0648")), Collections.unmodifiableList(Arrays.asList("\u0627\u0644\u06af\u0648\u06cc \u0633\u0646\u0627\u0631\u06cc\u0648")), Collections.unmodifiableList(Arrays.asList("\u0632\u0645\u06cc\u0646\u0647")), Collections.unmodifiableList(Arrays.asList("\u0646\u0645\u0648\u0646\u0647 \u0647\u0627")), Collections.unmodifiableList(Arrays.asList("* ", "\u0628\u0627 \u0641\u0631\u0636 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0647\u0646\u06af\u0627\u0645\u06cc ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0622\u0646\u06af\u0627\u0647 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0648 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0627\u0645\u0627 "))));
        dialects.put("fi", new GherkinDialect("fi", "Finnish", "suomi", Collections.unmodifiableList(Arrays.asList("Ominaisuus")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Tapaus")), Collections.unmodifiableList(Arrays.asList("Tapausaihio")), Collections.unmodifiableList(Arrays.asList("Tausta")), Collections.unmodifiableList(Arrays.asList("Tapaukset")), Collections.unmodifiableList(Arrays.asList("* ", "Oletetaan ")), Collections.unmodifiableList(Arrays.asList("* ", "Kun ")), Collections.unmodifiableList(Arrays.asList("* ", "Niin ")), Collections.unmodifiableList(Arrays.asList("* ", "Ja ")), Collections.unmodifiableList(Arrays.asList("* ", "Mutta "))));
        dialects.put("fr", new GherkinDialect("fr", "French", "fran\u00e7ais", Collections.unmodifiableList(Arrays.asList("Fonctionnalit\u00e9")), Collections.unmodifiableList(Arrays.asList("R\u00e8gle")), Collections.unmodifiableList(Arrays.asList("Exemple", "Sc\u00e9nario")), Collections.unmodifiableList(Arrays.asList("Plan du sc\u00e9nario", "Plan du Sc\u00e9nario")), Collections.unmodifiableList(Arrays.asList("Contexte")), Collections.unmodifiableList(Arrays.asList("Exemples")), Collections.unmodifiableList(Arrays.asList("* ", "Soit ", "Sachant que ", "Sachant qu'", "Sachant ", "Etant donn\u00e9 que ", "Etant donn\u00e9 qu'", "Etant donn\u00e9 ", "Etant donn\u00e9e ", "Etant donn\u00e9s ", "Etant donn\u00e9es ", "\u00c9tant donn\u00e9 que ", "\u00c9tant donn\u00e9 qu'", "\u00c9tant donn\u00e9 ", "\u00c9tant donn\u00e9e ", "\u00c9tant donn\u00e9s ", "\u00c9tant donn\u00e9es ")), Collections.unmodifiableList(Arrays.asList("* ", "Quand ", "Lorsque ", "Lorsqu'")), Collections.unmodifiableList(Arrays.asList("* ", "Alors ", "Donc ")), Collections.unmodifiableList(Arrays.asList("* ", "Et que ", "Et qu'", "Et ")), Collections.unmodifiableList(Arrays.asList("* ", "Mais que ", "Mais qu'", "Mais "))));
        dialects.put("ga", new GherkinDialect("ga", "Irish", "Gaeilge", Collections.unmodifiableList(Arrays.asList("Gn\u00e9")), Collections.unmodifiableList(Arrays.asList("Riail")), Collections.unmodifiableList(Arrays.asList("Sampla", "C\u00e1s")), Collections.unmodifiableList(Arrays.asList("C\u00e1s Achomair")), Collections.unmodifiableList(Arrays.asList("C\u00falra")), Collections.unmodifiableList(Arrays.asList("Sampla\u00ed")), Collections.unmodifiableList(Arrays.asList("* ", "Cuir i gc\u00e1s go ", "Cuir i gc\u00e1s nach ", "Cuir i gc\u00e1s gur ", "Cuir i gc\u00e1s n\u00e1r ")), Collections.unmodifiableList(Arrays.asList("* ", "Nuair a ", "Nuair nach ", "Nuair ba ", "Nuair n\u00e1r ")), Collections.unmodifiableList(Arrays.asList("* ", "Ansin ")), Collections.unmodifiableList(Arrays.asList("* ", "Agus ")), Collections.unmodifiableList(Arrays.asList("* ", "Ach "))));
        dialects.put("gj", new GherkinDialect("gj", "Gujarati", "\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0", Collections.unmodifiableList(Arrays.asList("\u0ab2\u0a95\u0acd\u0ab7\u0aa3", "\u0ab5\u0acd\u0aaf\u0abe\u0aaa\u0abe\u0ab0 \u0a9c\u0ab0\u0ac2\u0ab0", "\u0a95\u0acd\u0ab7\u0aae\u0aa4\u0abe")), Collections.unmodifiableList(Arrays.asList("\u0aa8\u0abf\u0aaf\u0aae")), Collections.unmodifiableList(Arrays.asList("\u0a89\u0aa6\u0abe\u0ab9\u0ab0\u0aa3", "\u0ab8\u0acd\u0aa5\u0abf\u0aa4\u0abf")), Collections.unmodifiableList(Arrays.asList("\u0aaa\u0ab0\u0abf\u0aa6\u0acd\u0aa6\u0ab6\u0acd\u0aaf \u0ab0\u0ac2\u0aaa\u0ab0\u0ac7\u0a96\u0abe", "\u0aaa\u0ab0\u0abf\u0aa6\u0acd\u0aa6\u0ab6\u0acd\u0aaf \u0aa2\u0abe\u0a82\u0a9a\u0acb")), Collections.unmodifiableList(Arrays.asList("\u0aac\u0ac7\u0a95\u0a97\u0acd\u0ab0\u0abe\u0a89\u0aa8\u0acd\u0aa1")), Collections.unmodifiableList(Arrays.asList("\u0a89\u0aa6\u0abe\u0ab9\u0ab0\u0aa3\u0acb")), Collections.unmodifiableList(Arrays.asList("* ", "\u0a86\u0aaa\u0ac7\u0ab2 \u0a9b\u0ac7 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0a95\u0acd\u0aaf\u0abe\u0ab0\u0ac7 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0aaa\u0a9b\u0ac0 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0a85\u0aa8\u0ac7 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0aaa\u0aa3 "))));
        dialects.put("gl", new GherkinDialect("gl", "Galician", "galego", Collections.unmodifiableList(Arrays.asList("Caracter\u00edstica")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Exemplo", "Escenario")), Collections.unmodifiableList(Arrays.asList("Esbozo do escenario")), Collections.unmodifiableList(Arrays.asList("Contexto")), Collections.unmodifiableList(Arrays.asList("Exemplos")), Collections.unmodifiableList(Arrays.asList("* ", "Dado ", "Dada ", "Dados ", "Dadas ")), Collections.unmodifiableList(Arrays.asList("* ", "Cando ")), Collections.unmodifiableList(Arrays.asList("* ", "Ent\u00f3n ", "Logo ")), Collections.unmodifiableList(Arrays.asList("* ", "E ")), Collections.unmodifiableList(Arrays.asList("* ", "Mais ", "Pero "))));
        dialects.put("he", new GherkinDialect("he", "Hebrew", "\u05e2\u05d1\u05e8\u05d9\u05ea", Collections.unmodifiableList(Arrays.asList("\u05ea\u05db\u05d5\u05e0\u05d4")), Collections.unmodifiableList(Arrays.asList("\u05db\u05dc\u05dc")), Collections.unmodifiableList(Arrays.asList("\u05d3\u05d5\u05d2\u05de\u05d0", "\u05ea\u05e8\u05d7\u05d9\u05e9")), Collections.unmodifiableList(Arrays.asList("\u05ea\u05d1\u05e0\u05d9\u05ea \u05ea\u05e8\u05d7\u05d9\u05e9")), Collections.unmodifiableList(Arrays.asList("\u05e8\u05e7\u05e2")), Collections.unmodifiableList(Arrays.asList("\u05d3\u05d5\u05d2\u05de\u05d0\u05d5\u05ea")), Collections.unmodifiableList(Arrays.asList("* ", "\u05d1\u05d4\u05d9\u05e0\u05ea\u05df ")), Collections.unmodifiableList(Arrays.asList("* ", "\u05db\u05d0\u05e9\u05e8 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u05d0\u05d6 ", "\u05d0\u05d6\u05d9 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u05d5\u05d2\u05dd ")), Collections.unmodifiableList(Arrays.asList("* ", "\u05d0\u05d1\u05dc "))));
        dialects.put("hi", new GherkinDialect("hi", "Hindi", "\u0939\u093f\u0902\u0926\u0940", Collections.unmodifiableList(Arrays.asList("\u0930\u0942\u092a \u0932\u0947\u0916")), Collections.unmodifiableList(Arrays.asList("\u0928\u093f\u092f\u092e")), Collections.unmodifiableList(Arrays.asList("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f")), Collections.unmodifiableList(Arrays.asList("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f \u0930\u0942\u092a\u0930\u0947\u0916\u093e")), Collections.unmodifiableList(Arrays.asList("\u092a\u0943\u0937\u094d\u0920\u092d\u0942\u092e\u093f")), Collections.unmodifiableList(Arrays.asList("\u0909\u0926\u093e\u0939\u0930\u0923")), Collections.unmodifiableList(Arrays.asList("* ", "\u0905\u0917\u0930 ", "\u092f\u0926\u093f ", "\u091a\u0942\u0902\u0915\u093f ")), Collections.unmodifiableList(Arrays.asList("* ", "\u091c\u092c ", "\u0915\u0926\u093e ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0924\u092c ", "\u0924\u0926\u093e ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0914\u0930 ", "\u0924\u0925\u093e ")), Collections.unmodifiableList(Arrays.asList("* ", "\u092a\u0930 ", "\u092a\u0930\u0928\u094d\u0924\u0941 ", "\u0915\u093f\u0928\u094d\u0924\u0941 "))));
        dialects.put("hr", new GherkinDialect("hr", "Croatian", "hrvatski", Collections.unmodifiableList(Arrays.asList("Osobina", "Mogu\u0107nost", "Mogucnost")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Primjer", "Scenarij")), Collections.unmodifiableList(Arrays.asList("Skica", "Koncept")), Collections.unmodifiableList(Arrays.asList("Pozadina")), Collections.unmodifiableList(Arrays.asList("Primjeri", "Scenariji")), Collections.unmodifiableList(Arrays.asList("* ", "Zadan ", "Zadani ", "Zadano ", "Ukoliko ")), Collections.unmodifiableList(Arrays.asList("* ", "Kada ", "Kad ")), Collections.unmodifiableList(Arrays.asList("* ", "Onda ")), Collections.unmodifiableList(Arrays.asList("* ", "I ")), Collections.unmodifiableList(Arrays.asList("* ", "Ali "))));
        dialects.put("ht", new GherkinDialect("ht", "Creole", "krey\u00f2l", Collections.unmodifiableList(Arrays.asList("Karakteristik", "Mak", "Fonksyonalite")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Senaryo")), Collections.unmodifiableList(Arrays.asList("Plan senaryo", "Plan Senaryo", "Senaryo deskripsyon", "Senaryo Deskripsyon", "Dyagram senaryo", "Dyagram Senaryo")), Collections.unmodifiableList(Arrays.asList("Kont\u00e8ks", "Istorik")), Collections.unmodifiableList(Arrays.asList("Egzanp")), Collections.unmodifiableList(Arrays.asList("* ", "Sipoze ", "Sipoze ke ", "Sipoze Ke ")), Collections.unmodifiableList(Arrays.asList("* ", "L\u00e8 ", "Le ")), Collections.unmodifiableList(Arrays.asList("* ", "L\u00e8 sa a ", "Le sa a ")), Collections.unmodifiableList(Arrays.asList("* ", "Ak ", "Epi ", "E ")), Collections.unmodifiableList(Arrays.asList("* ", "Men "))));
        dialects.put("hu", new GherkinDialect("hu", "Hungarian", "magyar", Collections.unmodifiableList(Arrays.asList("Jellemz\u0151")), Collections.unmodifiableList(Arrays.asList("Szab\u00e1ly")), Collections.unmodifiableList(Arrays.asList("P\u00e9lda", "Forgat\u00f3k\u00f6nyv")), Collections.unmodifiableList(Arrays.asList("Forgat\u00f3k\u00f6nyv v\u00e1zlat")), Collections.unmodifiableList(Arrays.asList("H\u00e1tt\u00e9r")), Collections.unmodifiableList(Arrays.asList("P\u00e9ld\u00e1k")), Collections.unmodifiableList(Arrays.asList("* ", "Amennyiben ", "Adott ")), Collections.unmodifiableList(Arrays.asList("* ", "Majd ", "Ha ", "Amikor ")), Collections.unmodifiableList(Arrays.asList("* ", "Akkor ")), Collections.unmodifiableList(Arrays.asList("* ", "\u00c9s ")), Collections.unmodifiableList(Arrays.asList("* ", "De "))));
        dialects.put("id", new GherkinDialect("id", "Indonesian", "Bahasa Indonesia", Collections.unmodifiableList(Arrays.asList("Fitur")), Collections.unmodifiableList(Arrays.asList("Rule", "Aturan")), Collections.unmodifiableList(Arrays.asList("Skenario")), Collections.unmodifiableList(Arrays.asList("Skenario konsep", "Garis-Besar Skenario")), Collections.unmodifiableList(Arrays.asList("Dasar", "Latar Belakang")), Collections.unmodifiableList(Arrays.asList("Contoh", "Misal")), Collections.unmodifiableList(Arrays.asList("* ", "Dengan ", "Diketahui ", "Diasumsikan ", "Bila ", "Jika ")), Collections.unmodifiableList(Arrays.asList("* ", "Ketika ")), Collections.unmodifiableList(Arrays.asList("* ", "Maka ", "Kemudian ")), Collections.unmodifiableList(Arrays.asList("* ", "Dan ")), Collections.unmodifiableList(Arrays.asList("* ", "Tapi ", "Tetapi "))));
        dialects.put("is", new GherkinDialect("is", "Icelandic", "\u00cdslenska", Collections.unmodifiableList(Arrays.asList("Eiginleiki")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Atbur\u00f0ar\u00e1s")), Collections.unmodifiableList(Arrays.asList("L\u00fdsing Atbur\u00f0ar\u00e1sar", "L\u00fdsing D\u00e6ma")), Collections.unmodifiableList(Arrays.asList("Bakgrunnur")), Collections.unmodifiableList(Arrays.asList("D\u00e6mi", "Atbur\u00f0ar\u00e1sir")), Collections.unmodifiableList(Arrays.asList("* ", "Ef ")), Collections.unmodifiableList(Arrays.asList("* ", "\u00deegar ")), Collections.unmodifiableList(Arrays.asList("* ", "\u00de\u00e1 ")), Collections.unmodifiableList(Arrays.asList("* ", "Og ")), Collections.unmodifiableList(Arrays.asList("* ", "En "))));
        dialects.put("it", new GherkinDialect("it", "Italian", "italiano", Collections.unmodifiableList(Arrays.asList("Funzionalit\u00e0", "Esigenza di Business", "Abilit\u00e0")), Collections.unmodifiableList(Arrays.asList("Regola")), Collections.unmodifiableList(Arrays.asList("Esempio", "Scenario")), Collections.unmodifiableList(Arrays.asList("Schema dello scenario")), Collections.unmodifiableList(Arrays.asList("Contesto")), Collections.unmodifiableList(Arrays.asList("Esempi")), Collections.unmodifiableList(Arrays.asList("* ", "Dato ", "Data ", "Dati ", "Date ")), Collections.unmodifiableList(Arrays.asList("* ", "Quando ")), Collections.unmodifiableList(Arrays.asList("* ", "Allora ")), Collections.unmodifiableList(Arrays.asList("* ", "E ", "Ed ")), Collections.unmodifiableList(Arrays.asList("* ", "Ma "))));
        dialects.put("ja", new GherkinDialect("ja", "Japanese", "\u65e5\u672c\u8a9e", Collections.unmodifiableList(Arrays.asList("\u30d5\u30a3\u30fc\u30c1\u30e3", "\u6a5f\u80fd")), Collections.unmodifiableList(Arrays.asList("\u30eb\u30fc\u30eb")), Collections.unmodifiableList(Arrays.asList("\u30b7\u30ca\u30ea\u30aa")), Collections.unmodifiableList(Arrays.asList("\u30b7\u30ca\u30ea\u30aa\u30a2\u30a6\u30c8\u30e9\u30a4\u30f3", "\u30b7\u30ca\u30ea\u30aa\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8", "\u30c6\u30f3\u30d7\u30ec", "\u30b7\u30ca\u30ea\u30aa\u30c6\u30f3\u30d7\u30ec")), Collections.unmodifiableList(Arrays.asList("\u80cc\u666f")), Collections.unmodifiableList(Arrays.asList("\u4f8b", "\u30b5\u30f3\u30d7\u30eb")), Collections.unmodifiableList(Arrays.asList("* ", "\u524d\u63d0")), Collections.unmodifiableList(Arrays.asList("* ", "\u3082\u3057")), Collections.unmodifiableList(Arrays.asList("* ", "\u306a\u3089\u3070")), Collections.unmodifiableList(Arrays.asList("* ", "\u4e14\u3064", "\u304b\u3064")), Collections.unmodifiableList(Arrays.asList("* ", "\u7136\u3057", "\u3057\u304b\u3057", "\u4f46\u3057", "\u305f\u3060\u3057"))));
        dialects.put("jv", new GherkinDialect("jv", "Javanese", "Basa Jawa", Collections.unmodifiableList(Arrays.asList("Fitur")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Skenario")), Collections.unmodifiableList(Arrays.asList("Konsep skenario")), Collections.unmodifiableList(Arrays.asList("Dasar")), Collections.unmodifiableList(Arrays.asList("Conto", "Contone")), Collections.unmodifiableList(Arrays.asList("* ", "Nalika ", "Nalikaning ")), Collections.unmodifiableList(Arrays.asList("* ", "Manawa ", "Menawa ")), Collections.unmodifiableList(Arrays.asList("* ", "Njuk ", "Banjur ")), Collections.unmodifiableList(Arrays.asList("* ", "Lan ")), Collections.unmodifiableList(Arrays.asList("* ", "Tapi ", "Nanging ", "Ananging "))));
        dialects.put("ka", new GherkinDialect("ka", "Georgian", "\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8", Collections.unmodifiableList(Arrays.asList("\u10d7\u10d5\u10d8\u10e1\u10d4\u10d1\u10d0", "\u10db\u10dd\u10d7\u10ee\u10dd\u10d5\u10dc\u10d0")), Collections.unmodifiableList(Arrays.asList("\u10ec\u10d4\u10e1\u10d8")), Collections.unmodifiableList(Arrays.asList("\u10db\u10d0\u10d2\u10d0\u10da\u10d8\u10d7\u10d0\u10d3", "\u10db\u10d0\u10d2\u10d0\u10da\u10d8\u10d7\u10d8", "\u10db\u10d0\u10d2", "\u10e1\u10ea\u10d4\u10dc\u10d0\u10e0\u10d8")), Collections.unmodifiableList(Arrays.asList("\u10e1\u10ea\u10d4\u10dc\u10d0\u10e0\u10d8\u10e1 \u10dc\u10d8\u10db\u10e3\u10e8\u10d8", "\u10e1\u10ea\u10d4\u10dc\u10d0\u10e0\u10d8\u10e1 \u10e8\u10d0\u10d1\u10da\u10dd\u10dc\u10d8", "\u10dc\u10d8\u10db\u10e3\u10e8\u10d8", "\u10e8\u10d0\u10d1\u10da\u10dd\u10dc\u10d8")), Collections.unmodifiableList(Arrays.asList("\u10d9\u10dd\u10dc\u10e2\u10d4\u10e5\u10e1\u10e2\u10d8")), Collections.unmodifiableList(Arrays.asList("\u10db\u10d0\u10d2\u10d0\u10da\u10d8\u10d7\u10d4\u10d1\u10d8")), Collections.unmodifiableList(Arrays.asList("* ", "\u10db\u10dd\u10ea\u10d4\u10db\u10e3\u10da\u10d8 ", "\u10db\u10dd\u10ea\u10d4\u10db\u10e3\u10da\u10d8\u10d0 ", "\u10d5\u10d7\u10e5\u10d5\u10d0\u10d7 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u10e0\u10dd\u10d3\u10d4\u10e1\u10d0\u10ea ", "\u10e0\u10dd\u10ea\u10d0 ", "\u10e0\u10dd\u10d2\u10dd\u10e0\u10ea \u10d9\u10d8 ", "\u10d7\u10e3 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u10db\u10d0\u10e8\u10d8\u10dc ")), Collections.unmodifiableList(Arrays.asList("* ", "\u10d3\u10d0 ", "\u10d0\u10e1\u10d4\u10d5\u10d4 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u10db\u10d0\u10d2\u10e0\u10d0\u10db ", "\u10d7\u10e3\u10db\u10ea\u10d0 "))));
        dialects.put("kn", new GherkinDialect("kn", "Kannada", "\u0c95\u0ca8\u0ccd\u0ca8\u0ca1", Collections.unmodifiableList(Arrays.asList("\u0cb9\u0cc6\u0c9a\u0ccd\u0c9a\u0cb3")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u0c89\u0ca6\u0cbe\u0cb9\u0cb0\u0ca3\u0cc6", "\u0c95\u0ca5\u0cbe\u0cb8\u0cbe\u0cb0\u0cbe\u0c82\u0cb6")), Collections.unmodifiableList(Arrays.asList("\u0cb5\u0cbf\u0cb5\u0cb0\u0ca3\u0cc6")), Collections.unmodifiableList(Arrays.asList("\u0cb9\u0cbf\u0ca8\u0ccd\u0ca8\u0cc6\u0cb2\u0cc6")), Collections.unmodifiableList(Arrays.asList("\u0c89\u0ca6\u0cbe\u0cb9\u0cb0\u0ca3\u0cc6\u0c97\u0cb3\u0cc1")), Collections.unmodifiableList(Arrays.asList("* ", "\u0ca8\u0cbf\u0cd5\u0ca1\u0cbf\u0ca6 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0cb8\u0ccd\u0ca5\u0cbf\u0ca4\u0cbf\u0caf\u0ca8\u0ccd\u0ca8\u0cc1 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0ca8\u0c82\u0ca4\u0cb0 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0cae\u0ca4\u0ccd\u0ca4\u0cc1 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0c86\u0ca6\u0cb0\u0cc6 "))));
        dialects.put("ko", new GherkinDialect("ko", "Korean", "\ud55c\uad6d\uc5b4", Collections.unmodifiableList(Arrays.asList("\uae30\ub2a5")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\uc2dc\ub098\ub9ac\uc624")), Collections.unmodifiableList(Arrays.asList("\uc2dc\ub098\ub9ac\uc624 \uac1c\uc694")), Collections.unmodifiableList(Arrays.asList("\ubc30\uacbd")), Collections.unmodifiableList(Arrays.asList("\uc608")), Collections.unmodifiableList(Arrays.asList("* ", "\uc870\uac74 ", "\uba3c\uc800 ")), Collections.unmodifiableList(Arrays.asList("* ", "\ub9cc\uc77c ", "\ub9cc\uc57d ")), Collections.unmodifiableList(Arrays.asList("* ", "\uadf8\ub7ec\uba74 ")), Collections.unmodifiableList(Arrays.asList("* ", "\uadf8\ub9ac\uace0 ")), Collections.unmodifiableList(Arrays.asList("* ", "\ud558\uc9c0\ub9cc ", "\ub2e8 "))));
        dialects.put("lt", new GherkinDialect("lt", "Lithuanian", "lietuvi\u0173 kalba", Collections.unmodifiableList(Arrays.asList("Savyb\u0117")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Pavyzdys", "Scenarijus")), Collections.unmodifiableList(Arrays.asList("Scenarijaus \u0161ablonas")), Collections.unmodifiableList(Arrays.asList("Kontekstas")), Collections.unmodifiableList(Arrays.asList("Pavyzd\u017eiai", "Scenarijai", "Variantai")), Collections.unmodifiableList(Arrays.asList("* ", "Duota ")), Collections.unmodifiableList(Arrays.asList("* ", "Kai ")), Collections.unmodifiableList(Arrays.asList("* ", "Tada ")), Collections.unmodifiableList(Arrays.asList("* ", "Ir ")), Collections.unmodifiableList(Arrays.asList("* ", "Bet "))));
        dialects.put("lu", new GherkinDialect("lu", "Luxemburgish", "L\u00ebtzebuergesch", Collections.unmodifiableList(Arrays.asList("Funktionalit\u00e9it")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Beispill", "Szenario")), Collections.unmodifiableList(Arrays.asList("Plang vum Szenario")), Collections.unmodifiableList(Arrays.asList("Hannergrond")), Collections.unmodifiableList(Arrays.asList("Beispiller")), Collections.unmodifiableList(Arrays.asList("* ", "ugeholl ")), Collections.unmodifiableList(Arrays.asList("* ", "wann ")), Collections.unmodifiableList(Arrays.asList("* ", "dann ")), Collections.unmodifiableList(Arrays.asList("* ", "an ", "a ")), Collections.unmodifiableList(Arrays.asList("* ", "awer ", "m\u00e4 "))));
        dialects.put("lv", new GherkinDialect("lv", "Latvian", "latvie\u0161u", Collections.unmodifiableList(Arrays.asList("Funkcionalit\u0101te", "F\u012b\u010da")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Piem\u0113rs", "Scen\u0101rijs")), Collections.unmodifiableList(Arrays.asList("Scen\u0101rijs p\u0113c parauga")), Collections.unmodifiableList(Arrays.asList("Konteksts", "Situ\u0101cija")), Collections.unmodifiableList(Arrays.asList("Piem\u0113ri", "Paraugs")), Collections.unmodifiableList(Arrays.asList("* ", "Kad ")), Collections.unmodifiableList(Arrays.asList("* ", "Ja ")), Collections.unmodifiableList(Arrays.asList("* ", "Tad ")), Collections.unmodifiableList(Arrays.asList("* ", "Un ")), Collections.unmodifiableList(Arrays.asList("* ", "Bet "))));
        dialects.put("mk-Cyrl", new GherkinDialect("mk-Cyrl", "Macedonian", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438", Collections.unmodifiableList(Arrays.asList("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e\u0441\u0442", "\u0411\u0438\u0437\u043d\u0438\u0441 \u043f\u043e\u0442\u0440\u0435\u0431\u0430", "\u041c\u043e\u0436\u043d\u043e\u0441\u0442")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0438\u043c\u0435\u0440", "\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u043e", "\u041d\u0430 \u043f\u0440\u0438\u043c\u0435\u0440")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0435\u0433\u043b\u0435\u0434 \u043d\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0458\u0430", "\u0421\u043a\u0438\u0446\u0430", "\u041a\u043e\u043d\u0446\u0435\u043f\u0442")), Collections.unmodifiableList(Arrays.asList("\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442", "\u0421\u043e\u0434\u0440\u0436\u0438\u043d\u0430")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0438\u043c\u0435\u0440\u0438", "\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0458\u0430")), Collections.unmodifiableList(Arrays.asList("* ", "\u0414\u0430\u0434\u0435\u043d\u043e ", "\u0414\u0430\u0434\u0435\u043d\u0430 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041a\u043e\u0433\u0430 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0422\u043e\u0433\u0430\u0448 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0418 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041d\u043e "))));
        dialects.put("mk-Latn", new GherkinDialect("mk-Latn", "Macedonian (Latin)", "Makedonski (Latinica)", Collections.unmodifiableList(Arrays.asList("Funkcionalnost", "Biznis potreba", "Mozhnost")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Scenario", "Na primer")), Collections.unmodifiableList(Arrays.asList("Pregled na scenarija", "Skica", "Koncept")), Collections.unmodifiableList(Arrays.asList("Kontekst", "Sodrzhina")), Collections.unmodifiableList(Arrays.asList("Primeri", "Scenaria")), Collections.unmodifiableList(Arrays.asList("* ", "Dadeno ", "Dadena ")), Collections.unmodifiableList(Arrays.asList("* ", "Koga ")), Collections.unmodifiableList(Arrays.asList("* ", "Togash ")), Collections.unmodifiableList(Arrays.asList("* ", "I ")), Collections.unmodifiableList(Arrays.asList("* ", "No "))));
        dialects.put("ml", new GherkinDialect("ml", "Malayalam", "\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02", Collections.unmodifiableList(Arrays.asList("\u0d38\u0d35\u0d3f\u0d36\u0d47\u0d37\u0d24")), Collections.unmodifiableList(Arrays.asList("\u0d28\u0d3f\u0d2f\u0d2e\u0d02")), Collections.unmodifiableList(Arrays.asList("\u0d30\u0d02\u0d17\u0d02")), Collections.unmodifiableList(Arrays.asList("\u0d38\u0d3e\u0d39\u0d1a\u0d30\u0d4d\u0d2f\u0d24\u0d4d\u0d24\u0d3f\u0d28\u0d4d\u0d31\u0d46 \u0d30\u0d42\u0d2a\u0d30\u0d47\u0d16")), Collections.unmodifiableList(Arrays.asList("\u0d2a\u0d36\u0d4d\u0d1a\u0d3e\u0d24\u0d4d\u0d24\u0d32\u0d02")), Collections.unmodifiableList(Arrays.asList("\u0d09\u0d26\u0d3e\u0d39\u0d30\u0d23\u0d19\u0d4d\u0d19\u0d7e")), Collections.unmodifiableList(Arrays.asList("* ", "\u0d28\u0d7d\u0d15\u0d3f\u0d2f\u0d24\u0d4d")), Collections.unmodifiableList(Arrays.asList("\u0d0e\u0d2a\u0d4d\u0d2a\u0d47\u0d3e\u0d7e")), Collections.unmodifiableList(Arrays.asList("* ", "\u0d2a\u0d3f\u0d28\u0d4d\u0d28\u0d46")), Collections.unmodifiableList(Arrays.asList("* ", "\u0d12\u0d2a\u0d4d\u0d2a\u0d02")), Collections.unmodifiableList(Arrays.asList("* ", "\u0d2a\u0d15\u0d4d\u0d37\u0d47"))));
        dialects.put("mn", new GherkinDialect("mn", "Mongolian", "\u043c\u043e\u043d\u0433\u043e\u043b", Collections.unmodifiableList(Arrays.asList("\u0424\u0443\u043d\u043a\u0446", "\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u0421\u0446\u0435\u043d\u0430\u0440")), Collections.unmodifiableList(Arrays.asList("\u0421\u0446\u0435\u043d\u0430\u0440\u044b\u043d \u0442\u04e9\u043b\u04e9\u0432\u043b\u04e9\u0433\u04e9\u04e9")), Collections.unmodifiableList(Arrays.asList("\u0410\u0433\u0443\u0443\u043b\u0433\u0430")), Collections.unmodifiableList(Arrays.asList("\u0422\u0443\u0445\u0430\u0439\u043b\u0431\u0430\u043b")), Collections.unmodifiableList(Arrays.asList("* ", "\u04e8\u0433\u04e9\u0433\u0434\u0441\u04e9\u043d \u043d\u044c ", "\u0410\u043d\u0445 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0425\u044d\u0440\u044d\u0432 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0422\u044d\u0433\u044d\u0445\u044d\u0434 ", "\u04ae\u04af\u043d\u0438\u0439 \u0434\u0430\u0440\u0430\u0430 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041c\u04e9\u043d ", "\u0422\u044d\u0433\u044d\u044d\u0434 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0413\u044d\u0445\u0434\u044d\u044d ", "\u0425\u0430\u0440\u0438\u043d "))));
        dialects.put("mr", new GherkinDialect("mr", "Marathi", "\u092e\u0930\u093e\u0920\u0940", Collections.unmodifiableList(Arrays.asList("\u0935\u0948\u0936\u093f\u0937\u094d\u091f\u094d\u092f", "\u0938\u0941\u0935\u093f\u0927\u093e")), Collections.unmodifiableList(Arrays.asList("\u0928\u093f\u092f\u092e")), Collections.unmodifiableList(Arrays.asList("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f")), Collections.unmodifiableList(Arrays.asList("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f \u0930\u0942\u092a\u0930\u0947\u0916\u093e")), Collections.unmodifiableList(Arrays.asList("\u092a\u093e\u0930\u094d\u0936\u094d\u0935\u092d\u0942\u092e\u0940")), Collections.unmodifiableList(Arrays.asList("\u0909\u0926\u093e\u0939\u0930\u0923")), Collections.unmodifiableList(Arrays.asList("* ", "\u091c\u0930", "\u0926\u093f\u0932\u0947\u0932\u094d\u092f\u093e \u092a\u094d\u0930\u092e\u093e\u0923\u0947 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u091c\u0947\u0935\u094d\u0939\u093e ")), Collections.unmodifiableList(Arrays.asList("* ", "\u092e\u0917 ", "\u0924\u0947\u0935\u094d\u0939\u093e ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0906\u0923\u093f ", "\u0924\u0938\u0947\u091a ")), Collections.unmodifiableList(Arrays.asList("* ", "\u092a\u0923 ", "\u092a\u0930\u0902\u0924\u0941 "))));
        dialects.put("ne", new GherkinDialect("ne", "Nepali", "\u0928\u0947\u092a\u093e\u0932\u0940", Collections.unmodifiableList(Arrays.asList("\u0938\u0941\u0935\u093f\u0927\u093e", "\u0935\u093f\u0936\u0947\u0937\u0924\u093e")), Collections.unmodifiableList(Arrays.asList("\u0928\u093f\u092f\u092e")), Collections.unmodifiableList(Arrays.asList("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f")), Collections.unmodifiableList(Arrays.asList("\u092a\u0930\u093f\u0926\u0943\u0936\u094d\u092f \u0930\u0942\u092a\u0930\u0947\u0916\u093e")), Collections.unmodifiableList(Arrays.asList("\u092a\u0943\u0937\u094d\u0920\u092d\u0942\u092e\u0940")), Collections.unmodifiableList(Arrays.asList("\u0909\u0926\u093e\u0939\u0930\u0923", "\u0909\u0926\u093e\u0939\u0930\u0923\u0939\u0930\u0941")), Collections.unmodifiableList(Arrays.asList("* ", "\u0926\u093f\u0907\u090f\u0915\u094b ", "\u0926\u093f\u090f\u0915\u094b ", "\u092f\u0926\u093f ")), Collections.unmodifiableList(Arrays.asList("* ", "\u091c\u092c ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0924\u094d\u092f\u0938\u092a\u091b\u093f ", "\u0905\u0928\u0940 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0930 ", "\u0905\u0928\u093f ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0924\u0930 "))));
        dialects.put("nl", new GherkinDialect("nl", "Dutch", "Nederlands", Collections.unmodifiableList(Arrays.asList("Functionaliteit")), Collections.unmodifiableList(Arrays.asList("Regel")), Collections.unmodifiableList(Arrays.asList("Voorbeeld", "Scenario")), Collections.unmodifiableList(Arrays.asList("Abstract Scenario")), Collections.unmodifiableList(Arrays.asList("Achtergrond")), Collections.unmodifiableList(Arrays.asList("Voorbeelden")), Collections.unmodifiableList(Arrays.asList("* ", "Gegeven ", "Stel ")), Collections.unmodifiableList(Arrays.asList("* ", "Als ", "Wanneer ")), Collections.unmodifiableList(Arrays.asList("* ", "Dan ")), Collections.unmodifiableList(Arrays.asList("* ", "En ")), Collections.unmodifiableList(Arrays.asList("* ", "Maar "))));
        dialects.put("no", new GherkinDialect("no", "Norwegian", "norsk", Collections.unmodifiableList(Arrays.asList("Egenskap")), Collections.unmodifiableList(Arrays.asList("Regel")), Collections.unmodifiableList(Arrays.asList("Eksempel", "Scenario")), Collections.unmodifiableList(Arrays.asList("Scenariomal", "Abstrakt Scenario")), Collections.unmodifiableList(Arrays.asList("Bakgrunn")), Collections.unmodifiableList(Arrays.asList("Eksempler")), Collections.unmodifiableList(Arrays.asList("* ", "Gitt ")), Collections.unmodifiableList(Arrays.asList("* ", "N\u00e5r ")), Collections.unmodifiableList(Arrays.asList("* ", "S\u00e5 ")), Collections.unmodifiableList(Arrays.asList("* ", "Og ")), Collections.unmodifiableList(Arrays.asList("* ", "Men "))));
        dialects.put("pa", new GherkinDialect("pa", "Panjabi", "\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40", Collections.unmodifiableList(Arrays.asList("\u0a16\u0a3e\u0a38\u0a40\u0a05\u0a24", "\u0a2e\u0a41\u0a39\u0a3e\u0a02\u0a26\u0a30\u0a3e", "\u0a28\u0a15\u0a36 \u0a28\u0a41\u0a39\u0a3e\u0a30")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u0a09\u0a26\u0a3e\u0a39\u0a30\u0a28", "\u0a2a\u0a1f\u0a15\u0a25\u0a3e")), Collections.unmodifiableList(Arrays.asList("\u0a2a\u0a1f\u0a15\u0a25\u0a3e \u0a22\u0a3e\u0a02\u0a1a\u0a3e", "\u0a2a\u0a1f\u0a15\u0a25\u0a3e \u0a30\u0a42\u0a2a \u0a30\u0a47\u0a16\u0a3e")), Collections.unmodifiableList(Arrays.asList("\u0a2a\u0a3f\u0a1b\u0a4b\u0a15\u0a5c")), Collections.unmodifiableList(Arrays.asList("\u0a09\u0a26\u0a3e\u0a39\u0a30\u0a28\u0a3e\u0a02")), Collections.unmodifiableList(Arrays.asList("* ", "\u0a1c\u0a47\u0a15\u0a30 ", "\u0a1c\u0a3f\u0a35\u0a47\u0a02 \u0a15\u0a3f ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0a1c\u0a26\u0a4b\u0a02 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0a24\u0a26 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0a05\u0a24\u0a47 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0a2a\u0a30 "))));
        dialects.put("pl", new GherkinDialect("pl", "Polish", "polski", Collections.unmodifiableList(Arrays.asList("W\u0142a\u015bciwo\u015b\u0107", "Funkcja", "Aspekt", "Potrzeba biznesowa")), Collections.unmodifiableList(Arrays.asList("Zasada", "Regu\u0142a")), Collections.unmodifiableList(Arrays.asList("Przyk\u0142ad", "Scenariusz")), Collections.unmodifiableList(Arrays.asList("Szablon scenariusza")), Collections.unmodifiableList(Arrays.asList("Za\u0142o\u017cenia")), Collections.unmodifiableList(Arrays.asList("Przyk\u0142ady")), Collections.unmodifiableList(Arrays.asList("* ", "Zak\u0142adaj\u0105c ", "Maj\u0105c ", "Zak\u0142adaj\u0105c, \u017ce ")), Collections.unmodifiableList(Arrays.asList("* ", "Je\u017celi ", "Je\u015bli ", "Gdy ", "Kiedy ")), Collections.unmodifiableList(Arrays.asList("* ", "Wtedy ")), Collections.unmodifiableList(Arrays.asList("* ", "Oraz ", "I ")), Collections.unmodifiableList(Arrays.asList("* ", "Ale "))));
        dialects.put("pt", new GherkinDialect("pt", "Portuguese", "portugu\u00eas", Collections.unmodifiableList(Arrays.asList("Funcionalidade", "Caracter\u00edstica", "Caracteristica")), Collections.unmodifiableList(Arrays.asList("Regra")), Collections.unmodifiableList(Arrays.asList("Exemplo", "Cen\u00e1rio", "Cenario")), Collections.unmodifiableList(Arrays.asList("Esquema do Cen\u00e1rio", "Esquema do Cenario", "Delinea\u00e7\u00e3o do Cen\u00e1rio", "Delineacao do Cenario")), Collections.unmodifiableList(Arrays.asList("Contexto", "Cen\u00e1rio de Fundo", "Cenario de Fundo", "Fundo")), Collections.unmodifiableList(Arrays.asList("Exemplos", "Cen\u00e1rios", "Cenarios")), Collections.unmodifiableList(Arrays.asList("* ", "Dado ", "Dada ", "Dados ", "Dadas ")), Collections.unmodifiableList(Arrays.asList("* ", "Quando ")), Collections.unmodifiableList(Arrays.asList("* ", "Ent\u00e3o ", "Entao ")), Collections.unmodifiableList(Arrays.asList("* ", "E ")), Collections.unmodifiableList(Arrays.asList("* ", "Mas "))));
        dialects.put("ro", new GherkinDialect("ro", "Romanian", "rom\u00e2n\u0103", Collections.unmodifiableList(Arrays.asList("Functionalitate", "Func\u021bionalitate", "Func\u0163ionalitate")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Exemplu", "Scenariu")), Collections.unmodifiableList(Arrays.asList("Structura scenariu", "Structur\u0103 scenariu")), Collections.unmodifiableList(Arrays.asList("Context")), Collections.unmodifiableList(Arrays.asList("Exemple")), Collections.unmodifiableList(Arrays.asList("* ", "Date fiind ", "Dat fiind ", "Dat\u0103 fiind", "Dati fiind ", "Da\u021bi fiind ", "Da\u0163i fiind ")), Collections.unmodifiableList(Arrays.asList("* ", "Cand ", "C\u00e2nd ")), Collections.unmodifiableList(Arrays.asList("* ", "Atunci ")), Collections.unmodifiableList(Arrays.asList("* ", "Si ", "\u0218i ", "\u015ei ")), Collections.unmodifiableList(Arrays.asList("* ", "Dar "))));
        dialects.put("ru", new GherkinDialect("ru", "Russian", "\u0440\u0443\u0441\u0441\u043a\u0438\u0439", Collections.unmodifiableList(Arrays.asList("\u0424\u0443\u043d\u043a\u0446\u0438\u044f", "\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c", "\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b", "\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e", "\u0424\u0438\u0447\u0430")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0430\u0432\u0438\u043b\u043e")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0438\u043c\u0435\u0440", "\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439")), Collections.unmodifiableList(Arrays.asList("\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u044f", "\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u044f")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0435\u0434\u044b\u0441\u0442\u043e\u0440\u0438\u044f", "\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0438\u043c\u0435\u0440\u044b")), Collections.unmodifiableList(Arrays.asList("* ", "\u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c ", "\u0414\u0430\u043d\u043e ", "\u041f\u0443\u0441\u0442\u044c ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041a\u043e\u0433\u0434\u0430 ", "\u0415\u0441\u043b\u0438 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0422\u043e ", "\u0417\u0430\u0442\u0435\u043c ", "\u0422\u043e\u0433\u0434\u0430 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0418 ", "\u041a \u0442\u043e\u043c\u0443 \u0436\u0435 ", "\u0422\u0430\u043a\u0436\u0435 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041d\u043e ", "\u0410 ", "\u0418\u043d\u0430\u0447\u0435 "))));
        dialects.put("sk", new GherkinDialect("sk", "Slovak", "Slovensky", Collections.unmodifiableList(Arrays.asList("Po\u017eiadavka", "Funkcia", "Vlastnos\u0165")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Pr\u00edklad", "Scen\u00e1r")), Collections.unmodifiableList(Arrays.asList("N\u00e1\u010drt Scen\u00e1ru", "N\u00e1\u010drt Scen\u00e1ra", "Osnova Scen\u00e1ra")), Collections.unmodifiableList(Arrays.asList("Pozadie")), Collections.unmodifiableList(Arrays.asList("Pr\u00edklady")), Collections.unmodifiableList(Arrays.asList("* ", "Pokia\u013e ", "Za predpokladu ")), Collections.unmodifiableList(Arrays.asList("* ", "Ke\u010f ", "Ak ")), Collections.unmodifiableList(Arrays.asList("* ", "Tak ", "Potom ")), Collections.unmodifiableList(Arrays.asList("* ", "A ", "A tie\u017e ", "A taktie\u017e ", "A z\u00e1rove\u0148 ")), Collections.unmodifiableList(Arrays.asList("* ", "Ale "))));
        dialects.put("sl", new GherkinDialect("sl", "Slovenian", "Slovenski", Collections.unmodifiableList(Arrays.asList("Funkcionalnost", "Funkcija", "Mo\u017enosti", "Moznosti", "Lastnost", "Zna\u010dilnost")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("Primer", "Scenarij")), Collections.unmodifiableList(Arrays.asList("Struktura scenarija", "Skica", "Koncept", "Oris scenarija", "Osnutek")), Collections.unmodifiableList(Arrays.asList("Kontekst", "Osnova", "Ozadje")), Collections.unmodifiableList(Arrays.asList("Primeri", "Scenariji")), Collections.unmodifiableList(Arrays.asList("Dano ", "Podano ", "Zaradi ", "Privzeto ")), Collections.unmodifiableList(Arrays.asList("Ko ", "Ce ", "\u010ce ", "Kadar ")), Collections.unmodifiableList(Arrays.asList("Nato ", "Potem ", "Takrat ")), Collections.unmodifiableList(Arrays.asList("In ", "Ter ")), Collections.unmodifiableList(Arrays.asList("Toda ", "Ampak ", "Vendar "))));
        dialects.put("sr-Cyrl", new GherkinDialect("sr-Cyrl", "Serbian", "\u0421\u0440\u043f\u0441\u043a\u0438", Collections.unmodifiableList(Arrays.asList("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e\u0441\u0442", "\u041c\u043e\u0433\u0443\u045b\u043d\u043e\u0441\u0442", "\u041e\u0441\u043e\u0431\u0438\u043d\u0430")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0430\u0432\u0438\u043b\u043e")), Collections.unmodifiableList(Arrays.asList("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u043e", "\u041f\u0440\u0438\u043c\u0435\u0440")), Collections.unmodifiableList(Arrays.asList("\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0458\u0430", "\u0421\u043a\u0438\u0446\u0430", "\u041a\u043e\u043d\u0446\u0435\u043f\u0442")), Collections.unmodifiableList(Arrays.asList("\u041a\u043e\u043d\u0442\u0435\u043a\u0441\u0442", "\u041e\u0441\u043d\u043e\u0432\u0430", "\u041f\u043e\u0437\u0430\u0434\u0438\u043d\u0430")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0438\u043c\u0435\u0440\u0438", "\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0458\u0438")), Collections.unmodifiableList(Arrays.asList("* ", "\u0417\u0430 \u0434\u0430\u0442\u043e ", "\u0417\u0430 \u0434\u0430\u0442\u0435 ", "\u0417\u0430 \u0434\u0430\u0442\u0438 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041a\u0430\u0434\u0430 ", "\u041a\u0430\u0434 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041e\u043d\u0434\u0430 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0418 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0410\u043b\u0438 "))));
        dialects.put("sr-Latn", new GherkinDialect("sr-Latn", "Serbian (Latin)", "Srpski (Latinica)", Collections.unmodifiableList(Arrays.asList("Funkcionalnost", "Mogu\u0107nost", "Mogucnost", "Osobina")), Collections.unmodifiableList(Arrays.asList("Pravilo")), Collections.unmodifiableList(Arrays.asList("Scenario", "Primer")), Collections.unmodifiableList(Arrays.asList("Struktura scenarija", "Skica", "Koncept")), Collections.unmodifiableList(Arrays.asList("Kontekst", "Osnova", "Pozadina")), Collections.unmodifiableList(Arrays.asList("Primeri", "Scenariji")), Collections.unmodifiableList(Arrays.asList("* ", "Za dato ", "Za date ", "Za dati ")), Collections.unmodifiableList(Arrays.asList("* ", "Kada ", "Kad ")), Collections.unmodifiableList(Arrays.asList("* ", "Onda ")), Collections.unmodifiableList(Arrays.asList("* ", "I ")), Collections.unmodifiableList(Arrays.asList("* ", "Ali "))));
        dialects.put("sv", new GherkinDialect("sv", "Swedish", "Svenska", Collections.unmodifiableList(Arrays.asList("Egenskap")), Collections.unmodifiableList(Arrays.asList("Regel")), Collections.unmodifiableList(Arrays.asList("Scenario")), Collections.unmodifiableList(Arrays.asList("Abstrakt Scenario", "Scenariomall")), Collections.unmodifiableList(Arrays.asList("Bakgrund")), Collections.unmodifiableList(Arrays.asList("Exempel")), Collections.unmodifiableList(Arrays.asList("* ", "Givet ")), Collections.unmodifiableList(Arrays.asList("* ", "N\u00e4r ")), Collections.unmodifiableList(Arrays.asList("* ", "S\u00e5 ")), Collections.unmodifiableList(Arrays.asList("* ", "Och ")), Collections.unmodifiableList(Arrays.asList("* ", "Men "))));
        dialects.put("ta", new GherkinDialect("ta", "Tamil", "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd", Collections.unmodifiableList(Arrays.asList("\u0b85\u0bae\u0bcd\u0b9a\u0bae\u0bcd", "\u0bb5\u0ba3\u0bbf\u0b95 \u0ba4\u0bc7\u0bb5\u0bc8", "\u0ba4\u0bbf\u0bb1\u0ba9\u0bcd")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u0b89\u0ba4\u0bbe\u0bb0\u0ba3\u0bae\u0bbe\u0b95", "\u0b95\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf")), Collections.unmodifiableList(Arrays.asList("\u0b95\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf \u0b9a\u0bc1\u0bb0\u0bc1\u0b95\u0bcd\u0b95\u0bae\u0bcd", "\u0b95\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf \u0bb5\u0bbe\u0bb0\u0bcd\u0baa\u0bcd\u0baa\u0bc1\u0bb0\u0bc1")), Collections.unmodifiableList(Arrays.asList("\u0baa\u0bbf\u0ba9\u0bcd\u0ba9\u0ba3\u0bbf")), Collections.unmodifiableList(Arrays.asList("\u0b8e\u0b9f\u0bc1\u0ba4\u0bcd\u0ba4\u0bc1\u0b95\u0bcd\u0b95\u0bbe\u0b9f\u0bcd\u0b9f\u0bc1\u0b95\u0bb3\u0bcd", "\u0b95\u0bbe\u0b9f\u0bcd\u0b9a\u0bbf\u0b95\u0bb3\u0bcd", "\u0ba8\u0bbf\u0bb2\u0bc8\u0bae\u0bc8\u0b95\u0bb3\u0bbf\u0bb2\u0bcd")), Collections.unmodifiableList(Arrays.asList("* ", "\u0b95\u0bc6\u0bbe\u0b9f\u0bc1\u0b95\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0b9f\u0bcd\u0b9f ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0b8e\u0baa\u0bcd\u0baa\u0bc7\u0bbe\u0ba4\u0bc1 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0b85\u0baa\u0bcd\u0baa\u0bc6\u0bbe\u0bb4\u0bc1\u0ba4\u0bc1 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0bae\u0bc7\u0bb2\u0bc1\u0bae\u0bcd ", "\u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0b86\u0ba9\u0bbe\u0bb2\u0bcd "))));
        dialects.put("te", new GherkinDialect("te", "Telugu", "\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41", Collections.unmodifiableList(Arrays.asList("\u0c17\u0c41\u0c23\u0c2e\u0c41")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u0c09\u0c26\u0c3e\u0c39\u0c30\u0c23", "\u0c38\u0c28\u0c4d\u0c28\u0c3f\u0c35\u0c47\u0c36\u0c02")), Collections.unmodifiableList(Arrays.asList("\u0c15\u0c25\u0c28\u0c02")), Collections.unmodifiableList(Arrays.asList("\u0c28\u0c47\u0c2a\u0c25\u0c4d\u0c2f\u0c02")), Collections.unmodifiableList(Arrays.asList("\u0c09\u0c26\u0c3e\u0c39\u0c30\u0c23\u0c32\u0c41")), Collections.unmodifiableList(Arrays.asList("* ", "\u0c1a\u0c46\u0c2a\u0c4d\u0c2a\u0c2c\u0c21\u0c3f\u0c28\u0c26\u0c3f ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0c08 \u0c2a\u0c30\u0c3f\u0c38\u0c4d\u0c25\u0c3f\u0c24\u0c3f\u0c32\u0c4b ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0c05\u0c2a\u0c4d\u0c2a\u0c41\u0c21\u0c41 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0c2e\u0c30\u0c3f\u0c2f\u0c41 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0c15\u0c3e\u0c28\u0c3f "))));
        dialects.put("th", new GherkinDialect("th", "Thai", "\u0e44\u0e17\u0e22", Collections.unmodifiableList(Arrays.asList("\u0e42\u0e04\u0e23\u0e07\u0e2b\u0e25\u0e31\u0e01", "\u0e04\u0e27\u0e32\u0e21\u0e15\u0e49\u0e2d\u0e07\u0e01\u0e32\u0e23\u0e17\u0e32\u0e07\u0e18\u0e38\u0e23\u0e01\u0e34\u0e08", "\u0e04\u0e27\u0e32\u0e21\u0e2a\u0e32\u0e21\u0e32\u0e23\u0e16")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u0e40\u0e2b\u0e15\u0e38\u0e01\u0e32\u0e23\u0e13\u0e4c")), Collections.unmodifiableList(Arrays.asList("\u0e2a\u0e23\u0e38\u0e1b\u0e40\u0e2b\u0e15\u0e38\u0e01\u0e32\u0e23\u0e13\u0e4c", "\u0e42\u0e04\u0e23\u0e07\u0e2a\u0e23\u0e49\u0e32\u0e07\u0e02\u0e2d\u0e07\u0e40\u0e2b\u0e15\u0e38\u0e01\u0e32\u0e23\u0e13\u0e4c")), Collections.unmodifiableList(Arrays.asList("\u0e41\u0e19\u0e27\u0e04\u0e34\u0e14")), Collections.unmodifiableList(Arrays.asList("\u0e0a\u0e38\u0e14\u0e02\u0e2d\u0e07\u0e15\u0e31\u0e27\u0e2d\u0e22\u0e48\u0e32\u0e07", "\u0e0a\u0e38\u0e14\u0e02\u0e2d\u0e07\u0e40\u0e2b\u0e15\u0e38\u0e01\u0e32\u0e23\u0e13\u0e4c")), Collections.unmodifiableList(Arrays.asList("* ", "\u0e01\u0e33\u0e2b\u0e19\u0e14\u0e43\u0e2b\u0e49 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0e40\u0e21\u0e37\u0e48\u0e2d ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0e14\u0e31\u0e07\u0e19\u0e31\u0e49\u0e19 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0e41\u0e25\u0e30 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0e41\u0e15\u0e48 "))));
        dialects.put("tlh", new GherkinDialect("tlh", "Klingon", "tlhIngan", Collections.unmodifiableList(Arrays.asList("Qap", "Qu'meH 'ut", "perbogh", "poQbogh malja'", "laH")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("lut")), Collections.unmodifiableList(Arrays.asList("lut chovnatlh")), Collections.unmodifiableList(Arrays.asList("mo'")), Collections.unmodifiableList(Arrays.asList("ghantoH", "lutmey")), Collections.unmodifiableList(Arrays.asList("* ", "ghu' noblu' ", "DaH ghu' bejlu' ")), Collections.unmodifiableList(Arrays.asList("* ", "qaSDI' ")), Collections.unmodifiableList(Arrays.asList("* ", "vaj ")), Collections.unmodifiableList(Arrays.asList("* ", "'ej ", "latlh ")), Collections.unmodifiableList(Arrays.asList("* ", "'ach ", "'a "))));
        dialects.put("tr", new GherkinDialect("tr", "Turkish", "T\u00fcrk\u00e7e", Collections.unmodifiableList(Arrays.asList("\u00d6zellik")), Collections.unmodifiableList(Arrays.asList("Kural")), Collections.unmodifiableList(Arrays.asList("\u00d6rnek", "Senaryo")), Collections.unmodifiableList(Arrays.asList("Senaryo tasla\u011f\u0131")), Collections.unmodifiableList(Arrays.asList("Ge\u00e7mi\u015f")), Collections.unmodifiableList(Arrays.asList("\u00d6rnekler")), Collections.unmodifiableList(Arrays.asList("* ", "Diyelim ki ")), Collections.unmodifiableList(Arrays.asList("* ", "E\u011fer ki ")), Collections.unmodifiableList(Arrays.asList("* ", "O zaman ")), Collections.unmodifiableList(Arrays.asList("* ", "Ve ")), Collections.unmodifiableList(Arrays.asList("* ", "Fakat ", "Ama "))));
        dialects.put("tt", new GherkinDialect("tt", "Tatar", "\u0422\u0430\u0442\u0430\u0440\u0447\u0430", Collections.unmodifiableList(Arrays.asList("\u041c\u04e9\u043c\u043a\u0438\u043d\u043b\u0435\u043a", "\u04ae\u0437\u0435\u043d\u0447\u04d9\u043b\u0435\u043a\u043b\u0435\u043b\u0435\u043a")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439")), Collections.unmodifiableList(Arrays.asList("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439\u043d\u044b\u04a3 \u0442\u04e9\u0437\u0435\u043b\u0435\u0448\u0435")), Collections.unmodifiableList(Arrays.asList("\u041a\u0435\u0440\u0435\u0448")), Collections.unmodifiableList(Arrays.asList("\u04ae\u0440\u043d\u04d9\u043a\u043b\u04d9\u0440", "\u041c\u0438\u0441\u0430\u043b\u043b\u0430\u0440")), Collections.unmodifiableList(Arrays.asList("* ", "\u04d8\u0439\u0442\u0438\u043a ")), Collections.unmodifiableList(Arrays.asList("* ", "\u04d8\u0433\u04d9\u0440 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041d\u04d9\u0442\u0438\u0497\u04d9\u0434\u04d9 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u04ba\u04d9\u043c ", "\u0412\u04d9 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041b\u04d9\u043a\u0438\u043d ", "\u04d8\u043c\u043c\u0430 "))));
        dialects.put("uk", new GherkinDialect("uk", "Ukrainian", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430", Collections.unmodifiableList(Arrays.asList("\u0424\u0443\u043d\u043a\u0446\u0456\u043e\u043d\u0430\u043b")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0438\u043a\u043b\u0430\u0434", "\u0421\u0446\u0435\u043d\u0430\u0440\u0456\u0439")), Collections.unmodifiableList(Arrays.asList("\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0441\u0446\u0435\u043d\u0430\u0440\u0456\u044e")), Collections.unmodifiableList(Arrays.asList("\u041f\u0435\u0440\u0435\u0434\u0443\u043c\u043e\u0432\u0430")), Collections.unmodifiableList(Arrays.asList("\u041f\u0440\u0438\u043a\u043b\u0430\u0434\u0438")), Collections.unmodifiableList(Arrays.asList("* ", "\u041f\u0440\u0438\u043f\u0443\u0441\u0442\u0438\u043c\u043e ", "\u041f\u0440\u0438\u043f\u0443\u0441\u0442\u0438\u043c\u043e, \u0449\u043e ", "\u041d\u0435\u0445\u0430\u0439 ", "\u0414\u0430\u043d\u043e ")), Collections.unmodifiableList(Arrays.asList("* ", "\u042f\u043a\u0449\u043e ", "\u041a\u043e\u043b\u0438 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0422\u043e ", "\u0422\u043e\u0434\u0456 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0406 ", "\u0410 \u0442\u0430\u043a\u043e\u0436 ", "\u0422\u0430 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0410\u043b\u0435 "))));
        dialects.put("ur", new GherkinDialect("ur", "Urdu", "\u0627\u0631\u062f\u0648", Collections.unmodifiableList(Arrays.asList("\u0635\u0644\u0627\u062d\u06cc\u062a", "\u06a9\u0627\u0631\u0648\u0628\u0627\u0631 \u06a9\u06cc \u0636\u0631\u0648\u0631\u062a", "\u062e\u0635\u0648\u0635\u06cc\u062a")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u0645\u0646\u0638\u0631\u0646\u0627\u0645\u06c1")), Collections.unmodifiableList(Arrays.asList("\u0645\u0646\u0638\u0631 \u0646\u0627\u0645\u06d2 \u06a9\u0627 \u062e\u0627\u06a9\u06c1")), Collections.unmodifiableList(Arrays.asList("\u067e\u0633 \u0645\u0646\u0638\u0631")), Collections.unmodifiableList(Arrays.asList("\u0645\u062b\u0627\u0644\u06cc\u06ba")), Collections.unmodifiableList(Arrays.asList("* ", "\u0627\u06af\u0631 ", "\u0628\u0627\u0644\u0641\u0631\u0636 ", "\u0641\u0631\u0636 \u06a9\u06cc\u0627 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u062c\u0628 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u067e\u06be\u0631 ", "\u062a\u0628 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0627\u0648\u0631 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0644\u06cc\u06a9\u0646 "))));
        dialects.put("uz", new GherkinDialect("uz", "Uzbek", "\u0423\u0437\u0431\u0435\u043a\u0447\u0430", Collections.unmodifiableList(Arrays.asList("\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439")), Collections.unmodifiableList(Arrays.asList("\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430\u0441\u0438")), Collections.unmodifiableList(Arrays.asList("\u0422\u0430\u0440\u0438\u0445")), Collections.unmodifiableList(Arrays.asList("\u041c\u0438\u0441\u043e\u043b\u043b\u0430\u0440")), Collections.unmodifiableList(Arrays.asList("* ", "Belgilangan ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0410\u0433\u0430\u0440 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0423\u043d\u0434\u0430 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u0412\u0430 ")), Collections.unmodifiableList(Arrays.asList("* ", "\u041b\u0435\u043a\u0438\u043d ", "\u0411\u0438\u0440\u043e\u043a ", "\u0410\u043c\u043c\u043e "))));
        dialects.put("vi", new GherkinDialect("vi", "Vietnamese", "Ti\u1ebfng Vi\u1ec7t", Collections.unmodifiableList(Arrays.asList("T\u00ednh n\u0103ng")), Collections.unmodifiableList(Arrays.asList("Quy t\u1eafc")), Collections.unmodifiableList(Arrays.asList("T\u00ecnh hu\u1ed1ng", "K\u1ecbch b\u1ea3n")), Collections.unmodifiableList(Arrays.asList("Khung t\u00ecnh hu\u1ed1ng", "Khung k\u1ecbch b\u1ea3n")), Collections.unmodifiableList(Arrays.asList("B\u1ed1i c\u1ea3nh")), Collections.unmodifiableList(Arrays.asList("D\u1eef li\u1ec7u")), Collections.unmodifiableList(Arrays.asList("* ", "Bi\u1ebft ", "Cho ")), Collections.unmodifiableList(Arrays.asList("* ", "Khi ")), Collections.unmodifiableList(Arrays.asList("* ", "Th\u00ec ")), Collections.unmodifiableList(Arrays.asList("* ", "V\u00e0 ")), Collections.unmodifiableList(Arrays.asList("* ", "Nh\u01b0ng "))));
        dialects.put("zh-CN", new GherkinDialect("zh-CN", "Chinese simplified", "\u7b80\u4f53\u4e2d\u6587", Collections.unmodifiableList(Arrays.asList("\u529f\u80fd")), Collections.unmodifiableList(Arrays.asList("Rule", "\u89c4\u5219")), Collections.unmodifiableList(Arrays.asList("\u573a\u666f", "\u5267\u672c")), Collections.unmodifiableList(Arrays.asList("\u573a\u666f\u5927\u7eb2", "\u5267\u672c\u5927\u7eb2")), Collections.unmodifiableList(Arrays.asList("\u80cc\u666f")), Collections.unmodifiableList(Arrays.asList("\u4f8b\u5b50")), Collections.unmodifiableList(Arrays.asList("* ", "\u5047\u5982", "\u5047\u8bbe", "\u5047\u5b9a")), Collections.unmodifiableList(Arrays.asList("* ", "\u5f53")), Collections.unmodifiableList(Arrays.asList("* ", "\u90a3\u4e48")), Collections.unmodifiableList(Arrays.asList("* ", "\u800c\u4e14", "\u5e76\u4e14", "\u540c\u65f6")), Collections.unmodifiableList(Arrays.asList("* ", "\u4f46\u662f"))));
        dialects.put("zh-TW", new GherkinDialect("zh-TW", "Chinese traditional", "\u7e41\u9ad4\u4e2d\u6587", Collections.unmodifiableList(Arrays.asList("\u529f\u80fd")), Collections.unmodifiableList(Arrays.asList("Rule")), Collections.unmodifiableList(Arrays.asList("\u5834\u666f", "\u5287\u672c")), Collections.unmodifiableList(Arrays.asList("\u5834\u666f\u5927\u7db1", "\u5287\u672c\u5927\u7db1")), Collections.unmodifiableList(Arrays.asList("\u80cc\u666f")), Collections.unmodifiableList(Arrays.asList("\u4f8b\u5b50")), Collections.unmodifiableList(Arrays.asList("* ", "\u5047\u5982", "\u5047\u8a2d", "\u5047\u5b9a")), Collections.unmodifiableList(Arrays.asList("* ", "\u7576")), Collections.unmodifiableList(Arrays.asList("* ", "\u90a3\u9ebc")), Collections.unmodifiableList(Arrays.asList("* ", "\u800c\u4e14", "\u4e26\u4e14", "\u540c\u6642")), Collections.unmodifiableList(Arrays.asList("* ", "\u4f46\u662f"))));
        DIALECTS = Collections.unmodifiableMap(dialects);
    }
}

