/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.Line;
import io.cucumber.gherkin.LineSpan;
import io.cucumber.gherkin.Parser;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.StepKeywordType;
import java.util.List;
import java.util.Objects;

final class Token {
    final Line line;
    final boolean eof;
    Parser.TokenType matchedType;
    String matchedKeyword;
    String matchedText;
    List<LineSpan> matchedItems;
    int matchedIndent;
    String matchedLanguage;
    StepKeywordType keywordType;
    Location location;

    private Token(Line line, Location location) {
        this.line = line;
        this.location = location;
        this.eof = line == null;
    }

    static Token createEOF(Location location) {
        Objects.requireNonNull(location);
        return new Token(null, location);
    }

    static Token createGherkinLine(String text, Location location) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(location);
        return new Token(new Line(text), location);
    }

    boolean isEOF() {
        return this.eof;
    }

    String getTokenValue() {
        return this.isEOF() ? "EOF" : this.line.getText();
    }

    public String toString() {
        return String.format("%s: %s/%s", new Object[]{this.matchedType, this.matchedKeyword, this.matchedText});
    }
}

