/*
 * Decompiled with CFR 0.152.
 */
package gherkin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GherkinDialect {
    private final Map<String, List<String>> keywords;
    private String language;

    public GherkinDialect(String language, Map<String, List<String>> keywords) {
        this.language = language;
        this.keywords = keywords;
    }

    public List<String> getFeatureKeywords() {
        return this.keywords.get("feature");
    }

    public List<String> getScenarioKeywords() {
        return this.keywords.get("scenario");
    }

    public List<String> getStepKeywords() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getGivenKeywords());
        result.addAll(this.getWhenKeywords());
        result.addAll(this.getThenKeywords());
        result.addAll(this.getAndKeywords());
        result.addAll(this.getButKeywords());
        return result;
    }

    public List<String> getBackgroundKeywords() {
        return this.keywords.get("background");
    }

    public List<String> getScenarioOutlineKeywords() {
        return this.keywords.get("scenarioOutline");
    }

    public List<String> getExamplesKeywords() {
        return this.keywords.get("examples");
    }

    public List<String> getGivenKeywords() {
        return this.keywords.get("given");
    }

    public List<String> getWhenKeywords() {
        return this.keywords.get("when");
    }

    public List<String> getThenKeywords() {
        return this.keywords.get("then");
    }

    public List<String> getAndKeywords() {
        return this.keywords.get("and");
    }

    public List<String> getButKeywords() {
        return this.keywords.get("but");
    }

    public String getLanguage() {
        return this.language;
    }
}

