/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.htmlformatter;

import java.io.IOException;
import java.io.Writer;

class JsonInHtmlWriter
extends Writer {
    private static final int BUFFER_SIZE = 1024;
    private final Writer delegate;
    private char[] escapeBuffer;

    JsonInHtmlWriter(Writer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void write(char[] source, int offset, int length) throws IOException {
        char[] destination = this.prepareBuffer();
        int flushAt = 1022;
        int written = 0;
        for (int i = offset; i < offset + length; ++i) {
            char c = source[i];
            if (written >= flushAt) {
                this.delegate.write(destination, 0, written);
                written = 0;
            }
            if (c == '/') {
                destination[written++] = 92;
            }
            destination[written++] = c;
        }
        if (written > 0) {
            this.delegate.write(destination, 0, written);
        }
    }

    private char[] prepareBuffer() {
        if (this.escapeBuffer == null) {
            this.escapeBuffer = new char[1024];
        }
        return this.escapeBuffer;
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

