/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junitxmlformatter;

import io.cucumber.junitxmlformatter.XmlReportData;
import io.cucumber.junitxmlformatter.XmlReportWriter;
import io.cucumber.messages.types.Envelope;
import io.cucumber.query.NamingStrategy;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;

public final class MessagesToJunitXmlWriter
implements AutoCloseable {
    private static final String DEFAULT_TEST_SUITE_NAME = "Cucumber";
    private final OutputStreamWriter out;
    private final XmlReportData data;
    private boolean streamClosed = false;

    public MessagesToJunitXmlWriter(OutputStream out) {
        this(DEFAULT_TEST_SUITE_NAME, null, MessagesToJunitXmlWriter.createNamingStrategy(NamingStrategy.ExampleName.NUMBER_AND_PICKLE_IF_PARAMETERIZED), out);
    }

    @Deprecated
    public MessagesToJunitXmlWriter(NamingStrategy.ExampleName exampleNameStrategy, OutputStream out) {
        this(DEFAULT_TEST_SUITE_NAME, null, MessagesToJunitXmlWriter.createNamingStrategy(Objects.requireNonNull(exampleNameStrategy)), out);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static NamingStrategy createNamingStrategy(NamingStrategy.ExampleName exampleName) {
        return NamingStrategy.strategy((NamingStrategy.Strategy)NamingStrategy.Strategy.LONG).featureName(NamingStrategy.FeatureName.EXCLUDE).exampleName(exampleName).build();
    }

    private MessagesToJunitXmlWriter(String testSuiteName, String testClassName, NamingStrategy testNamingStrategy, OutputStream out) {
        this.data = new XmlReportData(testSuiteName, testClassName, testNamingStrategy);
        this.out = new OutputStreamWriter(Objects.requireNonNull(out), StandardCharsets.UTF_8);
    }

    public void write(Envelope envelope) throws IOException {
        if (this.streamClosed) {
            throw new IOException("Stream closed");
        }
        this.data.collect(envelope);
    }

    @Override
    public void close() throws IOException {
        if (this.streamClosed) {
            return;
        }
        try {
            new XmlReportWriter(this.data).writeXmlReport(this.out);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error while transforming.", e);
        }
        finally {
            try {
                this.out.close();
            }
            finally {
                this.streamClosed = true;
            }
        }
    }

    public static class Builder {
        private String testSuiteName = "Cucumber";
        private String testClassName;
        private NamingStrategy testNamingStrategy = NamingStrategy.strategy((NamingStrategy.Strategy)NamingStrategy.Strategy.LONG).featureName(NamingStrategy.FeatureName.EXCLUDE).exampleName(NamingStrategy.ExampleName.NUMBER_AND_PICKLE_IF_PARAMETERIZED).build();

        private Builder() {
        }

        public Builder testSuiteName(String testSuiteName) {
            this.testSuiteName = Objects.requireNonNull(testSuiteName);
            return this;
        }

        public Builder testClassName(String testClassName) {
            this.testClassName = testClassName;
            return this;
        }

        public Builder testNamingStrategy(NamingStrategy namingStrategy) {
            this.testNamingStrategy = Objects.requireNonNull(namingStrategy);
            return this;
        }

        public MessagesToJunitXmlWriter build(OutputStream out) {
            return new MessagesToJunitXmlWriter(this.testSuiteName, this.testClassName, this.testNamingStrategy, Objects.requireNonNull(out));
        }
    }
}

