/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junitxmlformatter;

import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.query.NamingStrategy;
import io.cucumber.query.Query;
import java.util.AbstractMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

class XmlReportData {
    private final Query query = new Query();
    private final NamingStrategy namingStrategy = NamingStrategy.strategy((NamingStrategy.Strategy)NamingStrategy.Strategy.LONG).featureName(NamingStrategy.FeatureName.EXCLUDE).build();
    private static final long MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private static final Duration ZERO_DURATION = new Duration(Long.valueOf(0L), Long.valueOf(0L));
    private static final TestStepResult SCENARIO_WITH_NO_STEPS = new TestStepResult(ZERO_DURATION, null, TestStepResultStatus.PASSED, null);

    XmlReportData() {
    }

    void collect(Envelope envelope) {
        this.query.update(envelope);
    }

    double getSuiteDurationInSeconds() {
        return (double)this.query.findTestRunDuration().orElse(java.time.Duration.ZERO).toMillis() / (double)MILLIS_PER_SECOND;
    }

    double getDurationInSeconds(TestCaseStarted testCaseStarted) {
        return (double)this.query.findTestCaseDurationBy(testCaseStarted).orElse(java.time.Duration.ZERO).toMillis() / (double)MILLIS_PER_SECOND;
    }

    Map<TestStepResultStatus, Long> getTestCaseStatusCounts() {
        return this.query.findAllTestCaseStarted().stream().map(arg_0 -> ((Query)this.query).findMostSevereTestStepResulBy(arg_0)).filter(Optional::isPresent).map(Optional::get).map(TestStepResult::getStatus).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    int getTestCaseCount() {
        return this.query.findAllTestCaseStarted().size();
    }

    String getPickleName(TestCaseStarted testCaseStarted) {
        Pickle pickle = (Pickle)this.query.findPickleBy(testCaseStarted).orElseThrow(() -> new IllegalStateException("No pickle for " + testCaseStarted.getId()));
        return this.query.findNameOf(pickle, this.namingStrategy);
    }

    public String getFeatureName(TestCaseStarted testCaseStarted) {
        return this.query.findFeatureBy(testCaseStarted).map(Feature::getName).orElseThrow(() -> new IllegalStateException("No feature for " + testCaseStarted));
    }

    List<Map.Entry<String, String>> getStepsAndResult(TestCaseStarted testCaseStarted) {
        return this.query.findTestStepFinishedAndTestStepBy(testCaseStarted).stream().filter(entry -> ((TestStep)entry.getValue()).getPickleStepId().isPresent()).map(testStep -> {
            String key = this.renderTestStepText((TestStep)testStep.getValue());
            String value = this.renderTestStepResult((TestStepFinished)testStep.getKey());
            return new AbstractMap.SimpleEntry<String, String>(key, value);
        }).collect(Collectors.toList());
    }

    private String renderTestStepResult(TestStepFinished testStepFinished) {
        return testStepFinished.getTestStepResult().getStatus().toString().toLowerCase(Locale.ROOT);
    }

    private String renderTestStepText(TestStep testStep) {
        Optional pickleStep = this.query.findPickleStepBy(testStep);
        String stepKeyWord = pickleStep.flatMap(arg_0 -> ((Query)this.query).findStepBy(arg_0)).map(Step::getKeyword).orElse("");
        String stepText = pickleStep.map(PickleStep::getText).orElse("");
        return stepKeyWord + stepText;
    }

    List<TestCaseStarted> getAllTestCaseStarted() {
        return this.query.findAllTestCaseStarted();
    }

    TestStepResult getTestCaseStatus(TestCaseStarted testCaseStarted) {
        return this.query.findMostSevereTestStepResulBy(testCaseStarted).orElse(SCENARIO_WITH_NO_STEPS);
    }
}

