
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;

public class Examples {

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    private Location location;
    /**
     * 
     * (Required)
     * 
     */
    private List<Tag> tags = new ArrayList<Tag>();
    /**
     * 
     * (Required)
     * 
     */
    private String keyword;
    /**
     * 
     * (Required)
     * 
     */
    private String name;
    /**
     * 
     * (Required)
     * 
     */
    private String description;
    /**
     * A row in a table
     * 
     */
    private TableRow tableHeader;
    /**
     * 
     * (Required)
     * 
     */
    private List<TableRow> tableBody = new ArrayList<TableRow>();
    /**
     * 
     * (Required)
     * 
     */
    private String id;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Examples() {
    }

    /**
     * 
     * @param tableBody
     * @param name
     * @param description
     * @param location
     * @param id
     * @param keyword
     * @param tableHeader
     * @param tags
     */
    public Examples(Location location, List<Tag> tags, String keyword, String name, String description, TableRow tableHeader, List<TableRow> tableBody, String id) {
        super();
        this.location = location;
        this.tags = tags;
        this.keyword = keyword;
        this.name = name;
        this.description = description;
        this.tableHeader = tableHeader;
        this.tableBody = tableBody;
        this.id = id;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public Location getLocation() {
        return location;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    /**
     * 
     * (Required)
     * 
     */
    public List<Tag> getTags() {
        return tags;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getKeyword() {
        return keyword;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getDescription() {
        return description;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * A row in a table
     * 
     */
    public TableRow getTableHeader() {
        return tableHeader;
    }

    /**
     * A row in a table
     * 
     */
    public void setTableHeader(TableRow tableHeader) {
        this.tableHeader = tableHeader;
    }

    /**
     * 
     * (Required)
     * 
     */
    public List<TableRow> getTableBody() {
        return tableBody;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setTableBody(List<TableRow> tableBody) {
        this.tableBody = tableBody;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Examples.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("location");
        sb.append('=');
        sb.append(((this.location == null)?"<null>":this.location));
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(((this.tags == null)?"<null>":this.tags));
        sb.append(',');
        sb.append("keyword");
        sb.append('=');
        sb.append(((this.keyword == null)?"<null>":this.keyword));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("tableHeader");
        sb.append('=');
        sb.append(((this.tableHeader == null)?"<null>":this.tableHeader));
        sb.append(',');
        sb.append("tableBody");
        sb.append('=');
        sb.append(((this.tableBody == null)?"<null>":this.tableBody));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.tableBody == null)? 0 :this.tableBody.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.location == null)? 0 :this.location.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.keyword == null)? 0 :this.keyword.hashCode()));
        result = ((result* 31)+((this.tableHeader == null)? 0 :this.tableHeader.hashCode()));
        result = ((result* 31)+((this.tags == null)? 0 :this.tags.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Examples) == false) {
            return false;
        }
        Examples rhs = ((Examples) other);
        return (((((((((this.tableBody == rhs.tableBody)||((this.tableBody!= null)&&this.tableBody.equals(rhs.tableBody)))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.location == rhs.location)||((this.location!= null)&&this.location.equals(rhs.location))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.keyword == rhs.keyword)||((this.keyword!= null)&&this.keyword.equals(rhs.keyword))))&&((this.tableHeader == rhs.tableHeader)||((this.tableHeader!= null)&&this.tableHeader.equals(rhs.tableHeader))))&&((this.tags == rhs.tags)||((this.tags!= null)&&this.tags.equals(rhs.tags))));
    }

}
