
package io.cucumber.messages.types;


public class JavaStackTraceElement {

    /**
     * 
     * (Required)
     * 
     */
    private String className;
    /**
     * 
     * (Required)
     * 
     */
    private String fileName;
    /**
     * 
     * (Required)
     * 
     */
    private String methodName;

    /**
     * No args constructor for use in serialization
     * 
     */
    public JavaStackTraceElement() {
    }

    /**
     * 
     * @param fileName
     * @param methodName
     * @param className
     */
    public JavaStackTraceElement(String className, String fileName, String methodName) {
        super();
        this.className = className;
        this.fileName = fileName;
        this.methodName = methodName;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getClassName() {
        return className;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setClassName(String className) {
        this.className = className;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getMethodName() {
        return methodName;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JavaStackTraceElement.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("className");
        sb.append('=');
        sb.append(((this.className == null)?"<null>":this.className));
        sb.append(',');
        sb.append("fileName");
        sb.append('=');
        sb.append(((this.fileName == null)?"<null>":this.fileName));
        sb.append(',');
        sb.append("methodName");
        sb.append('=');
        sb.append(((this.methodName == null)?"<null>":this.methodName));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.methodName == null)? 0 :this.methodName.hashCode()));
        result = ((result* 31)+((this.className == null)? 0 :this.className.hashCode()));
        result = ((result* 31)+((this.fileName == null)? 0 :this.fileName.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof JavaStackTraceElement) == false) {
            return false;
        }
        JavaStackTraceElement rhs = ((JavaStackTraceElement) other);
        return ((((this.methodName == rhs.methodName)||((this.methodName!= null)&&this.methodName.equals(rhs.methodName)))&&((this.className == rhs.className)||((this.className!= null)&&this.className.equals(rhs.className))))&&((this.fileName == rhs.fileName)||((this.fileName!= null)&&this.fileName.equals(rhs.fileName))));
    }

}
